/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.menu.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;

public class ActionItemFormat {
    private final List<String> loreBonus;
    private final int amount;
    private final boolean glow;
    private final boolean hideAttributes;
    private final boolean hideEnchants;
    private final List<String> commands;
    private final String displaynamebonus;
    private final List<Integer> hideWhenNoMoney;
    private final List<Integer> hideWhenNoXp;

    public ActionItemFormat(ConfigurationSection config) {
        this.loreBonus = config.getStringList("lore_bonus");
        this.amount = config.getInt("amount", 1);
        this.glow = config.getBoolean("glow", false);
        this.hideAttributes = config.getBoolean("hide-attributes", true);
        this.hideEnchants = config.getBoolean("hide-enchants", true);
        this.commands = config.getStringList("commands");
        this.displaynamebonus = config.getString("display_name_bonus", "");
        this.hideWhenNoMoney = new ArrayList<Integer>();
        this.hideWhenNoXp = new ArrayList<Integer>();
        ConfigurationSection hideLineSection = config.getConfigurationSection("hide_line");
        if (hideLineSection != null) {
            if (hideLineSection.contains("when_no_money")) {
                if (hideLineSection.isInt("when_no_money")) {
                    this.hideWhenNoMoney.add(hideLineSection.getInt("when_no_money"));
                } else if (hideLineSection.isList("when_no_money")) {
                    this.hideWhenNoMoney.addAll(hideLineSection.getIntegerList("when_no_money"));
                }
            }
            if (hideLineSection.contains("when_no_xp")) {
                if (hideLineSection.isInt("when_no_xp")) {
                    this.hideWhenNoXp.add(hideLineSection.getInt("when_no_xp"));
                } else if (hideLineSection.isList("when_no_xp")) {
                    this.hideWhenNoXp.addAll(hideLineSection.getIntegerList("when_no_xp"));
                }
            }
        }
    }

    public ActionItemFormat() {
        this.loreBonus = ActionItemFormat.getDefaultLoreBonus();
        this.amount = 1;
        this.glow = false;
        this.hideAttributes = true;
        this.hideEnchants = true;
        this.commands = new ArrayList<String>();
        this.displaynamebonus = "";
        this.hideWhenNoMoney = new ArrayList<Integer>();
        this.hideWhenNoXp = new ArrayList<Integer>();
    }

    private static List<String> getDefaultLoreBonus() {
        return Arrays.asList("", "<gray>Rewards:", "<gray>\u251c <gray>XP: <#abffb3>+{action_xp}", "<gray>\u2514 <gray>Money: <#FFD700>${action_money}", "", "<gray>Requirements: {action_requirements}");
    }

    public List<String> getLoreBonus() {
        return new ArrayList<String>(this.loreBonus);
    }

    public int getAmount() {
        return this.amount;
    }

    public boolean isGlow() {
        return this.glow;
    }

    public boolean isHideAttributes() {
        return this.hideAttributes;
    }

    public boolean isHideEnchants() {
        return this.hideEnchants;
    }

    public List<String> getCommands() {
        return this.commands != null ? new ArrayList<String>(this.commands) : new ArrayList();
    }

    public String getDisplayNameEnabled() {
        return this.displaynamebonus != null ? this.displaynamebonus : "";
    }

    public List<Integer> getHideWhenNoMoney() {
        return new ArrayList<Integer>(this.hideWhenNoMoney);
    }

    public List<Integer> getHideWhenNoXp() {
        return new ArrayList<Integer>(this.hideWhenNoXp);
    }
}

