/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.storage;

import fr.ax_dev.universejobs.job.PlayerJobData;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.bukkit.configuration.file.FileConfiguration;

public class CacheManager {
    private final int maxSize;
    private final long maxMemoryMB;
    private final Map<UUID, CacheEntry> cache;
    private final Map<UUID, CacheEntry> accessOrder;
    private final ReentrantReadWriteLock lock;
    private final AtomicLong hits = new AtomicLong(0L);
    private final AtomicLong misses = new AtomicLong(0L);
    private final AtomicLong evictions = new AtomicLong(0L);

    public CacheManager(FileConfiguration config) {
        this.maxSize = 1000;
        this.maxMemoryMB = 256L;
        this.cache = new ConcurrentHashMap<UUID, CacheEntry>(Math.min(this.maxSize, 1024));
        this.accessOrder = new LinkedHashMap<UUID, CacheEntry>(16, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<UUID, CacheEntry> eldest) {
                return this.size() > CacheManager.this.maxSize;
            }
        };
        this.lock = new ReentrantReadWriteLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlayerJobData get(UUID playerId) {
        this.lock.readLock().lock();
        try {
            CacheEntry entry = this.cache.get(playerId);
            if (entry != null) {
                this.hits.incrementAndGet();
                this.lock.readLock().unlock();
                this.lock.writeLock().lock();
                try {
                    this.accessOrder.put(playerId, entry.updateAccess());
                    this.lock.readLock().lock();
                }
                finally {
                    this.lock.writeLock().unlock();
                }
                PlayerJobData playerJobData = entry.data;
                return playerJobData;
            }
            this.misses.incrementAndGet();
            PlayerJobData playerJobData = null;
            return playerJobData;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(UUID playerId, PlayerJobData data) {
        this.lock.writeLock().lock();
        try {
            if (this.shouldEvictForMemory()) {
                this.evictLeastRecentlyUsed();
            }
            CacheEntry entry = new CacheEntry(data);
            this.cache.put(playerId, entry);
            this.accessOrder.put(playerId, entry);
            while (this.cache.size() > this.maxSize) {
                this.evictLeastRecentlyUsed();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void remove(UUID playerId) {
        this.lock.writeLock().lock();
        try {
            this.cache.remove(playerId);
            this.accessOrder.remove(playerId);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void clear() {
        this.lock.writeLock().lock();
        try {
            this.cache.clear();
            this.accessOrder.clear();
            this.hits.set(0L);
            this.misses.set(0L);
            this.evictions.set(0L);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public boolean contains(UUID playerId) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.cache.containsKey(playerId);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<UUID> getCachedPlayers() {
        this.lock.readLock().lock();
        try {
            HashSet<UUID> hashSet = new HashSet<UUID>(this.cache.keySet());
            return hashSet;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Map<String, Object> getStats() {
        this.lock.readLock().lock();
        try {
            HashMap<String, Object> stats = new HashMap<String, Object>();
            stats.put("size", this.cache.size());
            stats.put("max_size", this.maxSize);
            stats.put("hits", this.hits.get());
            stats.put("misses", this.misses.get());
            stats.put("evictions", this.evictions.get());
            stats.put("hit_rate", this.getHitRate());
            stats.put("memory_usage_mb", this.getEstimatedMemoryUsageMB());
            stats.put("max_memory_mb", this.maxMemoryMB);
            HashMap<String, Object> hashMap = stats;
            return hashMap;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public double getHitRate() {
        long totalRequests = this.hits.get() + this.misses.get();
        return totalRequests > 0L ? (double)this.hits.get() * 100.0 / (double)totalRequests : 0.0;
    }

    private void evictLeastRecentlyUsed() {
        if (this.accessOrder.isEmpty()) {
            return;
        }
        Iterator<Map.Entry<UUID, CacheEntry>> iterator = this.accessOrder.entrySet().iterator();
        if (iterator.hasNext()) {
            UUID oldestKey = iterator.next().getKey();
            iterator.remove();
            this.cache.remove(oldestKey);
            this.evictions.incrementAndGet();
        }
    }

    private boolean shouldEvictForMemory() {
        return this.getEstimatedMemoryUsageMB() > this.maxMemoryMB;
    }

    private long getEstimatedMemoryUsageMB() {
        return (long)this.cache.size() * 2048L / 0x100000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preload(Map<UUID, PlayerJobData> playerDataMap) {
        this.lock.writeLock().lock();
        try {
            for (Map.Entry<UUID, PlayerJobData> entry : playerDataMap.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupExpired(int maxAgeMinutes) {
        this.lock.writeLock().lock();
        try {
            long cutoffTime = System.currentTimeMillis() - (long)(maxAgeMinutes * 60) * 1000L;
            HashSet<UUID> toRemove = new HashSet<UUID>();
            for (Map.Entry<UUID, CacheEntry> entry : this.cache.entrySet()) {
                if (entry.getValue().accessTime >= cutoffTime) continue;
                toRemove.add(entry.getKey());
            }
            for (UUID playerId : toRemove) {
                this.cache.remove(playerId);
                this.accessOrder.remove(playerId);
                this.evictions.incrementAndGet();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private static class CacheEntry {
        final PlayerJobData data;
        final long timestamp;
        final long accessTime;

        CacheEntry(PlayerJobData data) {
            this.data = data;
            this.timestamp = System.currentTimeMillis();
            this.accessTime = System.currentTimeMillis();
        }

        CacheEntry updateAccess() {
            return new CacheEntry(this, this.data){};
        }
    }
}

