/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.utils;

import fr.ax_dev.universejobs.utils.LegacyToMiniMessageConverter;
import java.util.Arrays;
import java.util.List;

public class LegacyConverterTest {
    public static void runTests() {
        System.out.println("=== Legacy to MiniMessage Converter Tests ===");
        List<String> testCases = Arrays.asList("&aHello World", "&6This is &lgold and bold&r text", "&cRed &4Dark Red &fWhite", "&lBold &oItalic &nUnderlined &mStrikethrough &kObfuscated", "&l&nBold and Underlined", "&6Gold &lBold &rReset to normal", "&#FF0000Red &#00FF00Green &#0000FFBlue", "&#FFD700Golden text with &#FFFFFF white", "&x&F&F&0&0&0&0Red &x&0&0&F&F&0&0Green &x&0&0&0&0&F&FBlue", "\u00a7aGreen \u00a76Gold \u00a7lBold", "&6&lBold Gold &r&cNormal Red", "&#FF5500Orange &lwith bold", "<gold>Already MiniMessage</gold>", "<#FF0000>Hex in MiniMessage</#FF0000>", "&", "&&a", "&zInvalid", "", "Normal text without codes", "&e+{xp} XP ({job})", "&aCongratulations! You reached level {level} in {job}!", "&e&lBONUS XP! &6All players received &e{bonus}% &6bonus XP for &e{duration}&6!", "\u00a7cThis command can only be used by players!", "&6=== {job} ===", "&7Description: &f{description}");
        System.out.println("\nTesting " + testCases.size() + " cases:");
        System.out.println("----------------------------------------");
        int passed = 0;
        int failed = 0;
        for (int i = 0; i < testCases.size(); ++i) {
            String input = testCases.get(i);
            try {
                String output = LegacyToMiniMessageConverter.convert(input);
                boolean hasLegacy = LegacyToMiniMessageConverter.containsLegacyCodes(input);
                System.out.printf("Test %2d: %-40s -> %s%n", i + 1, LegacyConverterTest.truncate(input, 40), LegacyConverterTest.truncate(output, 50));
                if (hasLegacy && input.equals(output)) {
                    System.out.println("  WARNING: Legacy codes detected but no conversion occurred");
                    ++failed;
                    continue;
                }
                ++passed;
                continue;
            }
            catch (Exception e) {
                System.out.printf("Test %2d: FAILED - %s (Error: %s)%n", i + 1, input, e.getMessage());
                ++failed;
            }
        }
        System.out.println("----------------------------------------");
        System.out.printf("Results: %d passed, %d failed%n", passed, failed);
        LegacyConverterTest.testPerformance();
        System.out.println("=== Test Complete ===");
    }

    private static void testPerformance() {
        System.out.println("\n=== Performance Test ===");
        String testMessage = "&6&lUniverseJobs &r&eYou gained &a{xp} XP &ein &b{job}&e! &#FF0000Red &#00FF00Green";
        int iterations = 10000;
        long startTime = System.nanoTime();
        for (int i = 0; i < iterations; ++i) {
            LegacyToMiniMessageConverter.convert(testMessage);
        }
        long endTime = System.nanoTime();
        long duration = endTime - startTime;
        double milliseconds = (double)duration / 1000000.0;
        double averagePerConversion = (double)duration / (double)iterations;
        System.out.printf("Converted %d messages in %.2f ms%n", iterations, milliseconds);
        System.out.printf("Average: %.2f nanoseconds per conversion%n", averagePerConversion);
        System.out.printf("Rate: %.0f conversions per second%n", 1.0E9 / averagePerConversion);
    }

    private static String truncate(String str, int maxLength) {
        if (str == null) {
            return "null";
        }
        if (str.length() <= maxLength) {
            return str;
        }
        return str.substring(0, maxLength - 3) + "...";
    }

    public static void testMinecraftScenarios() {
        String[] scenarios;
        System.out.println("=== Minecraft Plugin Scenarios ===");
        for (String scenario : scenarios = new String[]{"&7[&6UniverseJobs&7] &a", "&a\u2588\u2588\u2588\u2588\u2588\u2588\u2588\u2588&7\u2588\u2588 &e80%", "&e+{xp} XP &8(&7{job}&8)", "&6&l*** &eLEVEL UP! &6&l***", "&cUsage: &e/job join <jobname>", "&6&lRewards &8- &e{job}", "&aOnline &8| &7{count} players", "&cError: &7{message}", "&7Balance: &a${balance} &8| &7Level: &e{level}"}) {
            String converted = LegacyToMiniMessageConverter.convert(scenario);
            System.out.printf("Original:  %s%n", scenario);
            System.out.printf("Converted: %s%n", converted);
            System.out.println();
        }
    }
}

