/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.action;

import fr.ax_dev.universejobs.action.ActionLimitManager;
import fr.ax_dev.universejobs.condition.ConditionGroup;
import fr.ax_dev.universejobs.config.MessageConfig;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;

public class JobAction {
    private static final String PROFESSION_KEY = "profession";
    private static final String COLOR_KEY = "color";
    private static final String POTION_TYPE_KEY = "potion-type";
    private final String target;
    private final double xp;
    private final double money;
    private final ConditionGroup requirements;
    private final String name;
    private final String description;
    private final String displayName;
    private final String displayMaterial;
    private final List<String> lore;
    private final MessageConfig message;
    private final List<String> commands;
    private final String interactType;
    private final ActionLimitManager.ActionLimit actionLimit;
    private final String enchantLevel;
    private final List<String> professions;
    private final List<String> colors;
    private final List<String> nbtTags;
    private final List<String> potionTypes;
    private final List<String> blacklistedFurnaces;
    private final String age;

    public JobAction(ConfigurationSection config) {
        this.target = config.getString("target", "");
        this.xp = config.getDouble("xp", 0.0);
        this.money = config.getDouble("money", 0.0);
        this.name = config.getString("name", "");
        this.description = config.getString("description", "");
        this.displayName = this.applyDefaultFormatting(config.getString("display-name", ""));
        this.displayMaterial = config.getString("display-material", null);
        this.lore = this.applyDefaultFormattingToList(config.getStringList("lore"));
        this.interactType = config.getString("interact-type", "RIGHT_CLICK").toUpperCase();
        this.enchantLevel = config.getString("enchant-level", null);
        this.professions = this.loadProfessions(config);
        this.colors = this.loadColors(config);
        this.nbtTags = this.loadNbtTags(config);
        this.potionTypes = this.loadPotionTypes(config);
        this.blacklistedFurnaces = config.getStringList("blacklisted-furnaces");
        this.age = config.getString("age", null);
        ConfigurationSection messageSection = config.getConfigurationSection("message");
        this.message = messageSection != null ? new MessageConfig(messageSection) : null;
        this.commands = MessageConfig.parseCommands(config, "commands");
        ConfigurationSection requirementsSection = config.getConfigurationSection("requirements");
        this.requirements = requirementsSection != null ? new ConditionGroup(requirementsSection) : null;
        ConfigurationSection limitsSection = config.getConfigurationSection("limits");
        if (limitsSection != null) {
            int maxActionsPerPeriod = limitsSection.getInt("max-action-per-period", 0);
            int cooldownMinutes = limitsSection.getInt("cooldown-minutes", 60);
            boolean blockExp = limitsSection.getBoolean("block-exp", false);
            boolean blockMoney = limitsSection.getBoolean("block-money", false);
            this.actionLimit = maxActionsPerPeriod > 0 ? new ActionLimitManager.ActionLimit(maxActionsPerPeriod, cooldownMinutes, blockExp, blockMoney) : null;
        } else {
            this.actionLimit = null;
        }
    }

    private List<String> loadProfessions(ConfigurationSection config) {
        String prof;
        ArrayList<String> result = new ArrayList<String>();
        if (config.isList(PROFESSION_KEY)) {
            for (String prof2 : config.getStringList(PROFESSION_KEY)) {
                if (prof2 == null || prof2.trim().isEmpty()) continue;
                result.add(prof2.trim().toUpperCase());
            }
        } else if (config.isString(PROFESSION_KEY) && (prof = config.getString(PROFESSION_KEY)) != null && !prof.trim().isEmpty()) {
            result.add(prof.trim().toUpperCase());
        }
        return result;
    }

    private List<String> loadColors(ConfigurationSection config) {
        String color;
        ArrayList<String> result = new ArrayList<String>();
        if (config.isList(COLOR_KEY)) {
            for (String color2 : config.getStringList(COLOR_KEY)) {
                if (color2 == null || color2.trim().isEmpty()) continue;
                result.add(color2.trim().toUpperCase());
            }
        } else if (config.isString(COLOR_KEY) && (color = config.getString(COLOR_KEY)) != null && !color.trim().isEmpty()) {
            result.add(color.trim().toUpperCase());
        }
        return result;
    }

    private List<String> loadNbtTags(ConfigurationSection config) {
        String nbt;
        ArrayList<String> result = new ArrayList<String>();
        if (config.isList("nbt")) {
            for (String nbt2 : config.getStringList("nbt")) {
                if (nbt2 == null || nbt2.trim().isEmpty()) continue;
                result.add(nbt2.trim());
            }
        } else if (config.isString("nbt") && (nbt = config.getString("nbt")) != null && !nbt.trim().isEmpty()) {
            result.add(nbt.trim());
        }
        return result;
    }

    private List<String> loadPotionTypes(ConfigurationSection config) {
        String potionType;
        ArrayList<String> result = new ArrayList<String>();
        if (config.isList(POTION_TYPE_KEY)) {
            for (String potionType2 : config.getStringList(POTION_TYPE_KEY)) {
                if (potionType2 == null || potionType2.trim().isEmpty()) continue;
                result.add(potionType2.trim().toUpperCase());
            }
        } else if (config.isString(POTION_TYPE_KEY) && (potionType = config.getString(POTION_TYPE_KEY)) != null && !potionType.trim().isEmpty()) {
            result.add(potionType.trim().toUpperCase());
        }
        return result;
    }

    public String getTarget() {
        return this.target;
    }

    public double getXp() {
        return this.xp;
    }

    public double getMoney() {
        return this.money;
    }

    public ConditionGroup getRequirements() {
        return this.requirements;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDisplayMaterial() {
        return this.displayMaterial;
    }

    public boolean hasDisplayName() {
        return this.displayName != null && !this.displayName.trim().isEmpty();
    }

    public List<String> getLore() {
        return new ArrayList<String>(this.lore);
    }

    public boolean hasLore() {
        return this.lore != null && !this.lore.isEmpty();
    }

    public boolean hasRequirements() {
        return this.requirements != null;
    }

    public MessageConfig getMessage() {
        return this.message;
    }

    public List<String> getCommands() {
        return this.commands;
    }

    public boolean hasMessage() {
        return this.message != null && this.message.hasContent();
    }

    public boolean hasCommands() {
        return this.commands != null && !this.commands.isEmpty();
    }

    public String getInteractType() {
        return this.interactType;
    }

    public String getEnchantLevel() {
        return this.enchantLevel;
    }

    public boolean matchesTarget(String targetToCheck, String nexoBlockId) {
        if (this.target == null || targetToCheck == null) {
            return false;
        }
        if (this.target.startsWith("nexo:")) {
            String nexoTargetId = this.target.substring(5);
            return nexoBlockId != null && nexoTargetId.equalsIgnoreCase(nexoBlockId);
        }
        return this.matchesTarget(targetToCheck);
    }

    public boolean matchesEnchantTarget(String enchantmentKey, String enchantmentLevel) {
        if (this.target == null || enchantmentKey == null) {
            return false;
        }
        String targetNamespace = "minecraft";
        String targetKey = this.target;
        if (this.target.contains(":")) {
            String[] targetParts = this.target.split(":", 2);
            targetNamespace = targetParts[0];
            targetKey = targetParts[1];
        }
        String enchantNamespace = "minecraft";
        String enchantKey = enchantmentKey;
        if (enchantmentKey.contains(":")) {
            String[] enchantParts = enchantmentKey.split(":", 2);
            enchantNamespace = enchantParts[0];
            enchantKey = enchantParts[1];
        }
        boolean enchantTypeMatches = false;
        if (targetNamespace.equalsIgnoreCase(enchantNamespace) && targetKey.equalsIgnoreCase(enchantKey)) {
            enchantTypeMatches = true;
        } else if (targetKey.equals("*")) {
            enchantTypeMatches = targetNamespace.equalsIgnoreCase(enchantNamespace);
        } else if (targetKey.endsWith("*")) {
            String prefix = targetKey.substring(0, targetKey.length() - 1);
            enchantTypeMatches = targetNamespace.equalsIgnoreCase(enchantNamespace) && enchantKey.toUpperCase().startsWith(prefix.toUpperCase());
        } else if (targetKey.startsWith("*")) {
            String suffix = targetKey.substring(1);
            boolean bl = enchantTypeMatches = targetNamespace.equalsIgnoreCase(enchantNamespace) && enchantKey.toUpperCase().endsWith(suffix.toUpperCase());
        }
        if (!enchantTypeMatches) {
            return false;
        }
        if (this.enchantLevel == null || this.enchantLevel.trim().isEmpty()) {
            return true;
        }
        return this.matchesEnchantLevel(enchantmentLevel);
    }

    private boolean matchesEnchantLevel(String currentLevelStr) {
        if (this.enchantLevel == null || currentLevelStr == null) {
            return true;
        }
        try {
            String[] parts;
            int currentLevel = Integer.parseInt(currentLevelStr.trim());
            String levelReq = this.enchantLevel.trim();
            if (levelReq.contains("-") && (parts = levelReq.split("-", 2)).length == 2) {
                int minLevel = Integer.parseInt(parts[0].trim());
                int maxLevel = Integer.parseInt(parts[1].trim());
                return currentLevel >= minLevel && currentLevel <= maxLevel;
            }
            int requiredLevel = Integer.parseInt(levelReq);
            return currentLevel == requiredLevel;
        }
        catch (NumberFormatException e) {
            return true;
        }
    }

    public boolean matchesEnchantTarget(String enchantmentKey) {
        return this.matchesEnchantTarget(enchantmentKey, null);
    }

    public boolean matchesTarget(String targetToCheck) {
        if (this.target == null || targetToCheck == null) {
            return false;
        }
        if (this.target.equalsIgnoreCase(targetToCheck)) {
            return true;
        }
        if (this.target.equals("*")) {
            return true;
        }
        if (this.target.endsWith("*")) {
            String prefix = this.target.substring(0, this.target.length() - 1);
            return targetToCheck.toUpperCase().startsWith(prefix.toUpperCase());
        }
        if (this.target.startsWith("*")) {
            String suffix = this.target.substring(1);
            return targetToCheck.toUpperCase().endsWith(suffix.toUpperCase());
        }
        return false;
    }

    public boolean isNexoTarget() {
        return this.target != null && this.target.startsWith("nexo:");
    }

    public ActionLimitManager.ActionLimit getActionLimit() {
        return this.actionLimit;
    }

    public boolean hasLimits() {
        return this.actionLimit != null;
    }

    public List<String> getProfessions() {
        return this.professions;
    }

    public boolean hasProfessionRequirements() {
        return this.professions != null && !this.professions.isEmpty();
    }

    public boolean matchesProfession(String villagerProfession) {
        if (!this.hasProfessionRequirements()) {
            return true;
        }
        if (villagerProfession != null) {
            String professionUpper = villagerProfession.toUpperCase();
            return this.professions.contains(professionUpper);
        }
        return false;
    }

    public List<String> getColors() {
        return this.colors;
    }

    public boolean hasColorRequirements() {
        return this.colors != null && !this.colors.isEmpty();
    }

    public boolean matchesColor(String sheepColor) {
        if (!this.hasColorRequirements()) {
            return true;
        }
        if (sheepColor != null) {
            String colorUpper = sheepColor.toUpperCase();
            return this.colors.contains(colorUpper);
        }
        return false;
    }

    public List<String> getNbtTags() {
        return this.nbtTags;
    }

    public boolean hasNbtRequirements() {
        return this.nbtTags != null && !this.nbtTags.isEmpty();
    }

    public boolean matchesNbt(String itemNbt) {
        if (!this.hasNbtRequirements()) {
            return true;
        }
        if (itemNbt != null) {
            return this.nbtTags.contains(itemNbt);
        }
        return false;
    }

    public List<String> getPotionTypes() {
        return this.potionTypes;
    }

    public boolean hasPotionTypeRequirements() {
        return this.potionTypes != null && !this.potionTypes.isEmpty();
    }

    public List<String> getBlacklistedFurnaces() {
        return this.blacklistedFurnaces;
    }

    public String getAge() {
        return this.age;
    }

    public boolean hasAgeRequirements() {
        return this.age != null && !this.age.trim().isEmpty();
    }

    public boolean matchesAge(int currentAge) {
        if (!this.hasAgeRequirements()) {
            return true;
        }
        try {
            String[] parts;
            String ageReq = this.age.trim();
            if (ageReq.contains("-") && (parts = ageReq.split("-", 2)).length == 2) {
                int minAge = Integer.parseInt(parts[0].trim());
                int maxAge = Integer.parseInt(parts[1].trim());
                return currentAge >= minAge && currentAge <= maxAge;
            }
            int requiredAge = Integer.parseInt(ageReq);
            return currentAge == requiredAge;
        }
        catch (NumberFormatException e) {
            return true;
        }
    }

    public boolean matchesPotionType(String potionType) {
        if (!this.hasPotionTypeRequirements()) {
            return true;
        }
        if (potionType != null) {
            String potionTypeUpper = potionType.toUpperCase();
            return this.potionTypes.contains(potionTypeUpper);
        }
        return false;
    }

    public String toString() {
        return "JobAction{target='" + this.target + "', xp=" + this.xp + ", money=" + this.money + ", hasRequirements=" + this.hasRequirements() + "}";
    }

    private String applyDefaultFormatting(String text) {
        if (text == null || text.trim().isEmpty()) {
            return text;
        }
        if (text.startsWith("<") || text.startsWith("&")) {
            return text;
        }
        return "<!italic><white>" + text;
    }

    private List<String> applyDefaultFormattingToList(List<String> textList) {
        if (textList == null || textList.isEmpty()) {
            return textList;
        }
        ArrayList<String> formattedList = new ArrayList<String>();
        for (String text : textList) {
            formattedList.add(this.applyDefaultFormatting(text));
        }
        return formattedList;
    }
}

