/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.cache;

import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.job.PlayerJobData;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.bukkit.entity.Player;

public class PlayerJobCache {
    private final UniverseJobs plugin;
    private final Map<UUID, Set<String>> playerJobsCache = new ConcurrentHashMap<UUID, Set<String>>();
    private final Map<UUID, Map<String, Integer>> playerLevelsCache = new ConcurrentHashMap<UUID, Map<String, Integer>>();
    private final Map<UUID, Map<String, Double>> playerXpCache = new ConcurrentHashMap<UUID, Map<String, Double>>();
    private final Map<UUID, Map<String, Boolean>> playerPermissionsCache = new ConcurrentHashMap<UUID, Map<String, Boolean>>();
    private final Map<UUID, Double> playerMultipliersCache = new ConcurrentHashMap<UUID, Double>();
    private final AtomicLong cacheHits = new AtomicLong(0L);
    private final AtomicLong cacheMisses = new AtomicLong(0L);

    public PlayerJobCache(UniverseJobs plugin) {
        this.plugin = plugin;
    }

    public void preloadOnlinePlayers() {
        for (Player player : this.plugin.getServer().getOnlinePlayers()) {
            this.preloadPlayer(player.getUniqueId());
        }
    }

    public CompletableFuture<Void> preloadPlayer(UUID playerUuid) {
        return CompletableFuture.runAsync(() -> {
            try {
                PlayerJobData data = this.plugin.getJobManager().getPlayerData(playerUuid);
                this.playerJobsCache.put(playerUuid, new HashSet<String>(data.getJobs()));
                ConcurrentHashMap<String, Integer> levels = new ConcurrentHashMap<String, Integer>();
                ConcurrentHashMap<String, Double> xp = new ConcurrentHashMap<String, Double>();
                for (String jobId : data.getJobs()) {
                    levels.put(jobId, data.getLevel(jobId));
                    xp.put(jobId, data.getXp(jobId));
                }
                this.playerLevelsCache.put(playerUuid, levels);
                this.playerXpCache.put(playerUuid, xp);
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Failed to preload player data for " + String.valueOf(playerUuid));
            }
        });
    }

    public Set<String> getPlayerJobs(UUID playerUuid) {
        Set<String> jobs = this.playerJobsCache.get(playerUuid);
        if (jobs != null) {
            this.cacheHits.incrementAndGet();
            return jobs;
        }
        this.cacheMisses.incrementAndGet();
        this.preloadPlayer(playerUuid);
        return Collections.emptySet();
    }

    public boolean hasPermissionCached(UUID playerUuid, String permission) {
        Map<String, Boolean> perms = this.playerPermissionsCache.get(playerUuid);
        if (perms != null && perms.containsKey(permission)) {
            this.cacheHits.incrementAndGet();
            return perms.get(permission);
        }
        this.cacheMisses.incrementAndGet();
        Player player = this.plugin.getServer().getPlayer(playerUuid);
        if (player != null) {
            boolean result = player.hasPermission(permission);
            this.playerPermissionsCache.computeIfAbsent(playerUuid, k -> new ConcurrentHashMap()).put(permission, result);
            return result;
        }
        return false;
    }

    public double getPlayerMultiplier(UUID playerUuid) {
        Double multiplier = this.playerMultipliersCache.get(playerUuid);
        if (multiplier != null) {
            this.cacheHits.incrementAndGet();
            return multiplier;
        }
        this.cacheMisses.incrementAndGet();
        Player player = this.plugin.getServer().getPlayer(playerUuid);
        if (player != null) {
            double result = this.calculateMultiplier(player);
            this.playerMultipliersCache.put(playerUuid, result);
            return result;
        }
        return 1.0;
    }

    public int getPlayerLevel(UUID playerUuid, String jobId) {
        Map<String, Integer> levels = this.playerLevelsCache.get(playerUuid);
        if (levels != null && levels.containsKey(jobId)) {
            this.cacheHits.incrementAndGet();
            return levels.get(jobId);
        }
        this.cacheMisses.incrementAndGet();
        return 0;
    }

    public double getPlayerXp(UUID playerUuid, String jobId) {
        Map<String, Double> xp = this.playerXpCache.get(playerUuid);
        if (xp != null && xp.containsKey(jobId)) {
            this.cacheHits.incrementAndGet();
            return xp.get(jobId);
        }
        this.cacheMisses.incrementAndGet();
        return 0.0;
    }

    public void updatePlayerXp(UUID playerUuid, String jobId, double newXp, int newLevel) {
        this.playerXpCache.computeIfAbsent(playerUuid, k -> new ConcurrentHashMap()).put(jobId, newXp);
        this.playerLevelsCache.computeIfAbsent(playerUuid, k -> new ConcurrentHashMap()).put(jobId, newLevel);
    }

    public void addPlayerJob(UUID playerUuid, String jobId) {
        this.playerJobsCache.computeIfAbsent(playerUuid, k -> ConcurrentHashMap.newKeySet()).add(jobId);
        this.preloadPlayer(playerUuid);
    }

    public void removePlayerJob(UUID playerUuid, String jobId) {
        Map<String, Double> xp;
        Map<String, Integer> levels;
        Set<String> jobs = this.playerJobsCache.get(playerUuid);
        if (jobs != null) {
            jobs.remove(jobId);
        }
        if ((levels = this.playerLevelsCache.get(playerUuid)) != null) {
            levels.remove(jobId);
        }
        if ((xp = this.playerXpCache.get(playerUuid)) != null) {
            xp.remove(jobId);
        }
    }

    public void cleanupPlayer(UUID playerUuid) {
        this.playerJobsCache.remove(playerUuid);
        this.playerLevelsCache.remove(playerUuid);
        this.playerXpCache.remove(playerUuid);
        this.playerPermissionsCache.remove(playerUuid);
        this.playerMultipliersCache.remove(playerUuid);
    }

    public void performCleanup() {
        this.playerPermissionsCache.entrySet().removeIf(entry -> {
            Player player = this.plugin.getServer().getPlayer((UUID)entry.getKey());
            return player == null || !player.isOnline();
        });
        this.playerMultipliersCache.entrySet().removeIf(entry -> {
            Player player = this.plugin.getServer().getPlayer((UUID)entry.getKey());
            return player == null || !player.isOnline();
        });
    }

    private double calculateMultiplier(Player player) {
        if (player.isOp() || player.hasPermission("*")) {
            return 1.0;
        }
        for (int i = 10; i >= 1; --i) {
            if (!player.hasPermission("universejobs.multiplier.money." + i) && !player.hasPermission("universejobs.multiplier.exp." + i)) continue;
            return i;
        }
        return 1.0;
    }

    public Map<String, Object> getStats() {
        HashMap<String, Object> stats = new HashMap<String, Object>();
        stats.put("cache_hits", this.cacheHits.get());
        stats.put("cache_misses", this.cacheMisses.get());
        stats.put("cached_players", this.playerJobsCache.size());
        stats.put("cached_levels", this.playerLevelsCache.size());
        stats.put("cached_permissions", this.playerPermissionsCache.size());
        long totalRequests = this.cacheHits.get() + this.cacheMisses.get();
        if (totalRequests > 0L) {
            stats.put("hit_rate", (double)this.cacheHits.get() / (double)totalRequests * 100.0);
        }
        return stats;
    }

    public void resetStats() {
        this.cacheHits.set(0L);
        this.cacheMisses.set(0L);
    }
}

