/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.compatibility;

import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.lib.folialib.FoliaLib;
import fr.ax_dev.universejobs.lib.folialib.wrapper.task.WrappedTask;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;

public class FoliaCompatibilityManager {
    private final FoliaLib foliaLib;

    public FoliaCompatibilityManager(UniverseJobs plugin) {
        this.foliaLib = new FoliaLib((Plugin)plugin);
    }

    public FoliaLib getFoliaLib() {
        return this.foliaLib;
    }

    public boolean isFolia() {
        return this.foliaLib.isFolia();
    }

    public boolean isPaper() {
        return this.foliaLib.isPaper();
    }

    public boolean isSpigot() {
        return this.foliaLib.isSpigot();
    }

    public void runNextTick(Runnable task) {
        this.foliaLib.getScheduler().runNextTick((WrappedTask wrappedTask) -> task.run());
    }

    public void runAsync(Runnable task) {
        this.foliaLib.getScheduler().runAsync((WrappedTask wrappedTask) -> task.run());
    }

    public void runLater(Runnable task, long delay) {
        this.foliaLib.getScheduler().runLater((WrappedTask wrappedTask) -> task.run(), delay);
    }

    public void runLater(Runnable task, long delay, TimeUnit unit) {
        this.foliaLib.getScheduler().runLater((WrappedTask wrappedTask) -> task.run(), delay, unit);
    }

    public void runTimer(Runnable task, long initialDelay, long period) {
        this.foliaLib.getScheduler().runTimer((WrappedTask wrappedTask) -> task.run(), initialDelay, period);
    }

    public void runTimerAsync(Runnable task, long initialDelay, long period) {
        this.foliaLib.getScheduler().runTimerAsync((WrappedTask wrappedTask) -> task.run(), initialDelay, period);
    }

    public void runTimerAsync(Runnable task, long initialDelay, long period, TimeUnit unit) {
        this.foliaLib.getScheduler().runTimerAsync((WrappedTask wrappedTask) -> task.run(), initialDelay, period, unit);
    }

    public void runAtLocation(Location location, Runnable task) {
        this.foliaLib.getScheduler().runAtLocation(location, (WrappedTask wrappedTask) -> task.run());
    }

    public void runAtEntity(Entity entity, Runnable task) {
        this.foliaLib.getScheduler().runAtEntity(entity, (WrappedTask wrappedTask) -> task.run());
    }

    public CompletableFuture<Boolean> teleportAsync(Entity entity, Location location) {
        return this.foliaLib.getScheduler().teleportAsync(entity, location);
    }

    public CompletableFuture<Boolean> teleportAsync(Entity entity, Location location, PlayerTeleportEvent.TeleportCause cause) {
        return this.foliaLib.getScheduler().teleportAsync(entity, location, cause);
    }

    public CompletableFuture<Boolean> teleportPlayerSafely(Player player, Location location) {
        return this.teleportAsync((Entity)player, location, PlayerTeleportEvent.TeleportCause.PLUGIN);
    }

    public void cancelAllTasks() {
        this.foliaLib.getScheduler().cancelAllTasks();
    }

    public String getPlatformInfo() {
        if (this.foliaLib.isFolia()) {
            return "Folia (Regionised Multithreading)";
        }
        if (this.foliaLib.isPaper()) {
            return "Paper (Single Thread with Folia Compatibility)";
        }
        return "Spigot/Bukkit (Single Thread with Folia Compatibility)";
    }

    public boolean isOwnedByCurrentRegion(Location location) {
        if (this.foliaLib.isFolia()) {
            try {
                return Bukkit.isOwnedByCurrentRegion((Location)location);
            }
            catch (Exception e) {
                return true;
            }
        }
        return true;
    }

    public boolean isOwnedByCurrentRegion(Entity entity) {
        if (this.foliaLib.isFolia()) {
            try {
                return Bukkit.isOwnedByCurrentRegion((Entity)entity);
            }
            catch (Exception e) {
                return true;
            }
        }
        return true;
    }
}

