/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.condition;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;

public class ConditionContext {
    private static final ConcurrentLinkedQueue<ConditionContext> CONTEXT_POOL = new ConcurrentLinkedQueue();
    private static final int MAX_POOL_SIZE = 500;
    private static final String MATERIAL_KEY = "material";
    private final Map<String, Object> data = new HashMap<String, Object>();

    public static ConditionContext obtain() {
        ConditionContext context = CONTEXT_POOL.poll();
        if (context == null) {
            context = new ConditionContext();
        } else {
            context.data.clear();
        }
        return context;
    }

    public void release() {
        if (CONTEXT_POOL.size() < 500) {
            this.data.clear();
            CONTEXT_POOL.offer(this);
        }
    }

    public ConditionContext set(String key, Object value) {
        this.data.put(key, value);
        return this;
    }

    public <T> T get(String key, T defaultValue) {
        Object value = this.data.get(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return (T)value;
        }
        catch (ClassCastException e) {
            return defaultValue;
        }
    }

    public <T> T get(String key) {
        return this.get(key, null);
    }

    public boolean has(String key) {
        return this.data.containsKey(key);
    }

    public ConditionContext setBlock(Block block) {
        this.set("block", block).set(MATERIAL_KEY, block.getType());
        String nexoBlockId = this.detectNexoBlockId(block);
        if (nexoBlockId != null) {
            this.set("nexo_block_id", nexoBlockId);
        }
        return this;
    }

    public ConditionContext setEntity(Entity entity) {
        return this.set("entity", entity).set("entityType", entity.getType());
    }

    public ConditionContext setItem(ItemStack item) {
        if (item != null) {
            this.set("item", item).set(MATERIAL_KEY, item.getType());
        }
        return this;
    }

    public ConditionContext setMaterial(Material material) {
        return this.set(MATERIAL_KEY, material);
    }

    public Block getBlock() {
        return (Block)this.get("block");
    }

    public Entity getEntity() {
        return (Entity)this.get("entity");
    }

    public ItemStack getItem() {
        return (ItemStack)this.get("item");
    }

    public Material getMaterial() {
        return (Material)this.get(MATERIAL_KEY);
    }

    public String getTarget() {
        String explicitTarget = this.get("target", null);
        if (explicitTarget != null && !explicitTarget.isEmpty()) {
            return explicitTarget;
        }
        Material material = this.getMaterial();
        if (material != null) {
            return material.name();
        }
        Entity entity = this.getEntity();
        if (entity != null) {
            return entity.getType().name();
        }
        return "";
    }

    public String getNexoBlockId() {
        return (String)this.get("nexo_block_id");
    }

    private String detectNexoBlockId(Block block) {
        try {
            if (!Bukkit.getPluginManager().isPluginEnabled("Nexo")) {
                return null;
            }
            Class<?> nexoBlocksClass = Class.forName("com.nexomc.nexo.api.NexoBlocks");
            Method customBlockMechanicMethod = nexoBlocksClass.getMethod("customBlockMechanic", Location.class);
            Object mechanic = customBlockMechanicMethod.invoke(null, block.getLocation());
            if (mechanic != null) {
                Method getItemIDMethod = mechanic.getClass().getMethod("getItemID", new Class[0]);
                return (String)getItemIDMethod.invoke(mechanic, new Object[0]);
            }
            return null;
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public String toString() {
        return "ConditionContext{data=" + String.valueOf(this.data) + "}";
    }

    public ConditionContext clear() {
        this.data.clear();
        return this;
    }
}

