/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.condition;

import fr.ax_dev.universejobs.condition.Condition;
import fr.ax_dev.universejobs.condition.ConditionContext;
import fr.ax_dev.universejobs.condition.ConditionResult;
import fr.ax_dev.universejobs.condition.ConditionType;
import fr.ax_dev.universejobs.condition.MultipleConditionWrapper;
import fr.ax_dev.universejobs.condition.impl.BiomeCondition;
import fr.ax_dev.universejobs.condition.impl.ItemCondition;
import fr.ax_dev.universejobs.condition.impl.PermissionCondition;
import fr.ax_dev.universejobs.condition.impl.PlaceholderCondition;
import fr.ax_dev.universejobs.condition.impl.TimeCondition;
import fr.ax_dev.universejobs.condition.impl.WeatherCondition;
import fr.ax_dev.universejobs.condition.impl.WorldCondition;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class ConditionGroup {
    private final Logic logic;
    private final List<Condition> conditions = new ArrayList<Condition>();
    private final List<ConditionGroup> subGroups = new ArrayList<ConditionGroup>();

    public ConditionGroup(ConfigurationSection config) {
        String logicStr = config.getString("logic", "AND");
        this.logic = Logic.valueOf(logicStr.toUpperCase());
        this.loadConditions(config);
        this.loadSubGroups(config);
    }

    public ConditionGroup(Logic logic) {
        this.logic = logic;
    }

    private void loadConditions(ConfigurationSection config) {
        for (String key : config.getKeys(false)) {
            ConfigurationSection conditionConfig;
            Condition condition;
            Object value;
            if (key.equals("logic") || key.equals("groups") || key.equals("multiple_condition") || !((value = config.get(key)) instanceof ConfigurationSection) || (condition = this.createCondition(key, conditionConfig = (ConfigurationSection)value)) == null) continue;
            this.conditions.add(condition);
        }
        ConfigurationSection multipleCondition = config.getConfigurationSection("multiple_condition");
        if (multipleCondition != null) {
            this.loadMultipleConditions(multipleCondition);
        }
    }

    private void loadMultipleConditions(ConfigurationSection multipleCondition) {
        for (String conditionName : multipleCondition.getKeys(false)) {
            ConfigurationSection conditionConfig;
            if (conditionName.equals("accept") || conditionName.equals("deny") || (conditionConfig = multipleCondition.getConfigurationSection(conditionName)) == null) continue;
            MultipleConditionWrapper wrapper = new MultipleConditionWrapper(conditionName, conditionConfig, multipleCondition.getConfigurationSection("accept"), multipleCondition.getConfigurationSection("deny"));
            this.conditions.add(wrapper);
        }
    }

    private void loadSubGroups(ConfigurationSection config) {
        ConfigurationSection groupsSection = config.getConfigurationSection("groups");
        if (groupsSection != null) {
            for (String groupKey : groupsSection.getKeys(false)) {
                ConfigurationSection groupConfig = groupsSection.getConfigurationSection(groupKey);
                if (groupConfig == null) continue;
                this.subGroups.add(new ConditionGroup(groupConfig));
            }
        }
    }

    private Condition createCondition(String type, ConfigurationSection config) {
        ConditionType conditionType = ConditionType.fromString(type);
        if (conditionType == null) {
            return null;
        }
        return switch (conditionType) {
            case ConditionType.PLACEHOLDER -> new PlaceholderCondition(config);
            case ConditionType.PERMISSION -> new PermissionCondition(config);
            case ConditionType.ITEM -> new ItemCondition(config);
            case ConditionType.WORLD -> new WorldCondition(config);
            case ConditionType.TIME -> new TimeCondition(config);
            case ConditionType.WEATHER -> new WeatherCondition(config);
            case ConditionType.BIOME -> new BiomeCondition(config);
            default -> null;
        };
    }

    public void addCondition(Condition condition) {
        this.conditions.add(condition);
    }

    public void addSubGroup(ConditionGroup group) {
        this.subGroups.add(group);
    }

    public ConditionResult evaluate(Player player, Event event, ConditionContext context) {
        if (this.conditions.isEmpty() && this.subGroups.isEmpty()) {
            return ConditionResult.allow();
        }
        boolean result = this.logic == Logic.AND;
        ConditionResult denyResult = null;
        ConditionResult acceptResult = null;
        for (Condition condition : this.conditions) {
            boolean conditionMet = condition.isMet(player, event, context);
            if (this.logic == Logic.AND) {
                if (!conditionMet) {
                    denyResult = condition.getDenyResult();
                    result = false;
                    break;
                }
                if (acceptResult != null) continue;
                acceptResult = condition.getAcceptResult();
                continue;
            }
            if (conditionMet) {
                acceptResult = condition.getAcceptResult();
                result = true;
                break;
            }
            if (denyResult != null) continue;
            denyResult = condition.getDenyResult();
        }
        if (this.logic == Logic.AND && result || this.logic == Logic.OR && !result) {
            for (ConditionGroup subGroup : this.subGroups) {
                ConditionResult subResult = subGroup.evaluate(player, event, context);
                if (this.logic == Logic.AND) {
                    if (!subResult.isAllowed()) {
                        return subResult;
                    }
                    if (acceptResult != null || !subResult.isAllowed()) continue;
                    acceptResult = subResult;
                    continue;
                }
                if (subResult.isAllowed()) {
                    acceptResult = subResult;
                    result = true;
                    break;
                }
                if (denyResult != null) continue;
                denyResult = subResult;
            }
        }
        if (result) {
            return acceptResult != null ? acceptResult : ConditionResult.allow();
        }
        return denyResult != null ? denyResult : ConditionResult.deny();
    }

    public boolean hasConditions() {
        return !this.conditions.isEmpty() || !this.subGroups.isEmpty();
    }

    public Logic getLogic() {
        return this.logic;
    }

    public String toString() {
        return "ConditionGroup{logic=" + String.valueOf((Object)this.logic) + ", conditions=" + this.conditions.size() + ", subGroups=" + this.subGroups.size() + "}";
    }

    public static enum Logic {
        AND,
        OR;

    }
}

