/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.condition.impl;

import fr.ax_dev.universejobs.condition.AbstractCondition;
import fr.ax_dev.universejobs.condition.ConditionContext;
import fr.ax_dev.universejobs.condition.ConditionType;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.block.Biome;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class BiomeCondition
extends AbstractCondition {
    private final Set<Biome> allowedBiomes;
    private final boolean blacklist;

    public BiomeCondition(ConfigurationSection config) {
        super(config);
        List biomeNames = config.getStringList("biomes");
        this.allowedBiomes = biomeNames.stream().map(name -> {
            try {
                NamespacedKey key = NamespacedKey.minecraft((String)name.toLowerCase());
                Biome biome = (Biome)Registry.BIOME.get(key);
                if (biome == null) {
                    biome = Biome.valueOf((String)name.toUpperCase());
                }
                return biome;
            }
            catch (Exception e) {
                return null;
            }
        }).filter(biome -> biome != null).collect(Collectors.toSet());
        this.blacklist = config.getBoolean("blacklist", false);
    }

    @Override
    public boolean isMet(Player player, Event event, ConditionContext context) {
        Biome playerBiome = player.getLocation().getBlock().getBiome();
        boolean inList = this.allowedBiomes.contains(playerBiome);
        return this.blacklist ? !inList : inList;
    }

    @Override
    public ConditionType getType() {
        return ConditionType.BIOME;
    }

    public String toString() {
        return "BiomeCondition{biomes=" + this.allowedBiomes.size() + ", blacklist=" + this.blacklist + "}";
    }
}

