/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.config;

import fr.ax_dev.universejobs.utils.EnumUtils;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarStyle;
import org.bukkit.configuration.ConfigurationSection;

public class MessageConfig {
    private final MessageType type;
    private final String text;
    private final int duration;
    private final BarStyle bossbarStyle;
    private final BarColor bossbarColor;

    public MessageConfig(ConfigurationSection config) {
        if (config == null) {
            this.type = MessageType.CHAT;
            this.text = "";
            this.duration = 60;
            this.bossbarStyle = BarStyle.SOLID;
            this.bossbarColor = BarColor.GREEN;
        } else {
            MessageType tempType;
            String typeStr = config.getString("type", "CHAT").toUpperCase();
            try {
                tempType = MessageType.valueOf(typeStr);
            }
            catch (IllegalArgumentException e) {
                tempType = MessageType.CHAT;
            }
            this.type = tempType;
            this.text = config.getString("text", config.getString("message", ""));
            this.duration = config.getInt("duration", 60);
            String styleStr = config.getString("style", "SOLID").toUpperCase();
            if (styleStr.startsWith("SEGMENT_") && (styleStr = styleStr.replace("SEGMENT_", "SEGMENTED_")).equals("SEGMENTED_0")) {
                styleStr = "SEGMENTED_6";
            }
            this.bossbarStyle = EnumUtils.parseBarStyle(styleStr, BarStyle.SOLID);
            String colorStr = config.getString("color", "GREEN").toUpperCase();
            this.bossbarColor = EnumUtils.parseBarColor(colorStr, BarColor.GREEN);
        }
    }

    public MessageConfig(String message) {
        this.type = MessageType.CHAT;
        this.text = message != null ? message : "";
        this.duration = 60;
        this.bossbarStyle = BarStyle.SOLID;
        this.bossbarColor = BarColor.GREEN;
    }

    public MessageType getType() {
        return this.type;
    }

    public String getText() {
        return this.text;
    }

    public int getDuration() {
        return this.duration;
    }

    public BarStyle getBossbarStyle() {
        return this.bossbarStyle;
    }

    public BarColor getBossbarColor() {
        return this.bossbarColor;
    }

    public boolean hasContent() {
        return this.text != null && !this.text.isEmpty();
    }

    public static List<String> parseCommands(ConfigurationSection config, String key) {
        if (config == null || !config.contains(key)) {
            return new ArrayList<String>();
        }
        Object value = config.get(key);
        if (value instanceof List) {
            ArrayList<String> commands = new ArrayList<String>();
            for (Object item : (List)value) {
                if (item == null) continue;
                commands.add(item.toString());
            }
            return commands;
        }
        if (value instanceof String) {
            ArrayList<String> commands = new ArrayList<String>();
            commands.add((String)value);
            return commands;
        }
        return new ArrayList<String>();
    }

    public static enum MessageType {
        CHAT,
        ACTIONBAR,
        BOSSBAR;

    }
}

