/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.integration;

import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.condition.ConditionContext;
import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.mobs.MythicMob;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.bukkit.events.MythicMobDeathEvent;
import io.lumine.mythic.bukkit.events.MythicMobSpawnEvent;
import io.lumine.mythic.core.mobs.ActiveMob;
import java.util.Optional;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class MythicMobsHandler
implements Listener {
    private final UniverseJobs plugin;
    private final boolean isAvailable;

    public MythicMobsHandler(UniverseJobs plugin) {
        this.plugin = plugin;
        this.isAvailable = this.checkMythicMobsAvailability();
        if (this.isAvailable) {
            plugin.getLogger().info("MythicMobs integration initialized successfully");
        } else {
            plugin.getLogger().info("MythicMobs not available or incompatible version");
        }
    }

    private boolean checkMythicMobsAvailability() {
        try {
            Plugin mythicPlugin = this.plugin.getServer().getPluginManager().getPlugin("MythicMobs");
            if (mythicPlugin == null || !mythicPlugin.isEnabled()) {
                return false;
            }
            if (MythicBukkit.inst().getMobManager() == null) {
                return false;
            }
            this.plugin.getLogger().info("MythicMobs detected - Version: " + mythicPlugin.getDescription().getVersion());
            return true;
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to initialize MythicMobs integration: " + e.getMessage());
            return false;
        }
    }

    public boolean isAvailable() {
        return this.isAvailable;
    }

    public boolean populateMythicMobContext(Entity entity, ConditionContext context) {
        block6: {
            if (!this.isAvailable || entity == null || context == null) {
                return false;
            }
            try {
                Optional optionalActiveMob = MythicBukkit.inst().getMobManager().getActiveMob(entity.getUniqueId());
                if (optionalActiveMob.isPresent()) {
                    ActiveMob activeMob = (ActiveMob)optionalActiveMob.get();
                    MythicMob mythicMob = activeMob.getType();
                    String internalName = mythicMob.getInternalName();
                    context.set("target", "MYTHICMOB:" + internalName);
                    context.set("mythicmob", true);
                    context.set("mythicmob_type", internalName);
                    context.set("mythicmob_display_name", mythicMob.getDisplayName().get());
                    context.set("mythicmob_level", activeMob.getLevel());
                    AbstractEntity abstractEntity = activeMob.getEntity();
                    if (abstractEntity instanceof LivingEntity) {
                        LivingEntity livingEntity = (LivingEntity)abstractEntity;
                        context.set("mythicmob_health", livingEntity.getHealth());
                        context.set("mythicmob_max_health", livingEntity.getMaxHealth());
                    }
                    if (this.plugin.getConfigManager().isDebugEnabled()) {
                        this.plugin.getLogger().info("MythicMob detected: " + internalName + " (Level " + activeMob.getLevel() + ")");
                    }
                    return true;
                }
            }
            catch (Exception e) {
                if (!this.plugin.getConfigManager().isDebugEnabled()) break block6;
                this.plugin.getLogger().warning("Failed to check MythicMob data for entity: " + e.getMessage());
            }
        }
        return false;
    }

    public String getMythicMobInternalName(Entity entity) {
        block4: {
            if (!this.isAvailable || entity == null) {
                return null;
            }
            try {
                Optional optionalActiveMob = MythicBukkit.inst().getMobManager().getActiveMob(entity.getUniqueId());
                if (optionalActiveMob.isPresent()) {
                    return ((ActiveMob)optionalActiveMob.get()).getType().getInternalName();
                }
            }
            catch (Exception e) {
                if (!this.plugin.getConfigManager().isDebugEnabled()) break block4;
                this.plugin.getLogger().warning("Failed to get MythicMob internal name: " + e.getMessage());
            }
        }
        return null;
    }

    public boolean isMythicMob(Entity entity) {
        if (!this.isAvailable || entity == null) {
            return false;
        }
        try {
            Optional optionalActiveMob = MythicBukkit.inst().getMobManager().getActiveMob(entity.getUniqueId());
            return optionalActiveMob.isPresent();
        }
        catch (Exception e) {
            return false;
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onMythicMobSpawn(MythicMobSpawnEvent event) {
        if (!this.isAvailable) {
            return;
        }
        try {
            ActiveMob activeMob = event.getMob();
            if (activeMob != null) {
                String internalName = activeMob.getType().getInternalName();
                if (this.plugin.getConfigManager().isDebugEnabled()) {
                    this.plugin.getLogger().info("MythicMob spawned: " + internalName + " at " + String.valueOf(activeMob.getEntity().getLocation()));
                }
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error handling MythicMob spawn event: " + e.getMessage());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onMythicMobDeath(MythicMobDeathEvent event) {
        if (!this.isAvailable) {
            return;
        }
        try {
            ActiveMob activeMob = event.getMob();
            Player killer = null;
            AbstractEntity abstractEntity = activeMob.getEntity();
            if (abstractEntity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)abstractEntity;
                killer = livingEntity.getKiller();
            }
            if (killer != null && activeMob != null) {
                String internalName = activeMob.getType().getInternalName();
                if (this.plugin.getConfigManager().isDebugEnabled()) {
                    this.plugin.getLogger().info("MythicMob killed: " + internalName + " by " + killer.getName() + " (Level " + activeMob.getLevel() + ")");
                }
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error handling MythicMob death event: " + e.getMessage());
        }
    }

    public String getStatusInfo() {
        if (!this.isAvailable) {
            return "MythicMobs: Not available";
        }
        try {
            int activeMobs = MythicBukkit.inst().getMobManager().getActiveMobs().size();
            return String.format("MythicMobs: Active (%d mobs)", activeMobs);
        }
        catch (Exception e) {
            return "MythicMobs: Error - " + e.getMessage();
        }
    }
}

