/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.menu.config;

import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.job.Job;
import fr.ax_dev.universejobs.menu.MenuConfig;
import fr.ax_dev.universejobs.menu.config.SingleMenuConfig;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;

public class JobSlotManager {
    private final UniverseJobs plugin;
    private MenuConfig menuConfig;
    private final Map<String, Integer> jobSlots = new ConcurrentHashMap<String, Integer>();
    private final Map<Integer, String> slotJobs = new ConcurrentHashMap<Integer, String>();
    private final Set<Integer> availableSlots = ConcurrentHashMap.newKeySet();
    private final Set<Integer> reservedSlots = ConcurrentHashMap.newKeySet();

    public JobSlotManager(UniverseJobs plugin) {
        this.plugin = plugin;
        new File(plugin.getDataFolder(), "menus/job-slots.yml");
        this.initializeDefaultSlots();
    }

    public void initialize(MenuConfig menuConfig) {
        this.menuConfig = menuConfig;
        this.loadConfiguration();
    }

    private void initializeDefaultSlots() {
        int i;
        for (i = 0; i < 54; ++i) {
            if (this.isBorderSlot(i)) {
                this.reservedSlots.add(i);
                continue;
            }
            this.availableSlots.add(i);
        }
        for (i = 45; i < 54; ++i) {
            this.reservedSlots.add(i);
            this.availableSlots.remove(i);
        }
    }

    private boolean isBorderSlot(int slot) {
        int row = slot / 9;
        int col = slot % 9;
        if (row == 0 || row == 5) {
            return true;
        }
        return col == 0 || col == 8;
    }

    public void loadConfiguration() {
        try {
            this.jobSlots.clear();
            this.slotJobs.clear();
            if (this.menuConfig == null) {
                this.plugin.getLogger().warning("MenuConfig not initialized in JobSlotManager");
                return;
            }
            SingleMenuConfig mainMenuConfig = this.menuConfig.getMainMenuConfig();
            Map<String, Integer> configuredSlots = mainMenuConfig.getJobSlots();
            for (Map.Entry<String, Integer> entry : configuredSlots.entrySet()) {
                String jobId = entry.getKey();
                int slot = entry.getValue();
                if (!this.isValidSlot(slot) || this.reservedSlots.contains(slot)) continue;
                this.setJobSlot(jobId, slot);
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to load job slot configuration", e);
        }
    }

    public boolean setJobSlot(String jobId, int slot) {
        if (!this.isValidSlot(slot)) {
            return false;
        }
        if (this.reservedSlots.contains(slot)) {
            return false;
        }
        String existingJob = this.slotJobs.get(slot);
        if (existingJob != null && !existingJob.equals(jobId)) {
            return false;
        }
        Integer oldSlot = this.jobSlots.get(jobId);
        if (oldSlot != null) {
            this.slotJobs.remove(oldSlot);
            this.availableSlots.add(oldSlot);
        }
        this.jobSlots.put(jobId, slot);
        this.slotJobs.put(slot, jobId);
        this.availableSlots.remove(slot);
        return true;
    }

    public void removeJobSlot(String jobId) {
        Integer slot = this.jobSlots.remove(jobId);
        if (slot != null) {
            this.slotJobs.remove(slot);
            this.availableSlots.add(slot);
        }
    }

    public OptionalInt getJobSlot(String jobId) {
        Integer slot = this.jobSlots.get(jobId);
        return slot != null ? OptionalInt.of(slot) : OptionalInt.empty();
    }

    public Optional<String> getSlotJob(int slot) {
        return Optional.ofNullable(this.slotJobs.get(slot));
    }

    public Map<String, Integer> calculateJobSlots(Collection<Job> jobs) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        HashSet<Integer> usedSlots = new HashSet<Integer>(this.reservedSlots);
        for (Job job : jobs) {
            int slot;
            OptionalInt configuredSlot = this.getJobSlot(job.getId());
            if (!configuredSlot.isPresent() || usedSlots.contains(slot = configuredSlot.getAsInt())) continue;
            result.put(job.getId(), slot);
            usedSlots.add(slot);
        }
        ArrayList<Integer> availableSlotsList = new ArrayList<Integer>();
        for (int i = 0; i < 54; ++i) {
            if (usedSlots.contains(i)) continue;
            availableSlotsList.add(i);
        }
        Collections.sort(availableSlotsList);
        int slotIndex = 0;
        for (Job job : jobs) {
            if (result.containsKey(job.getId()) || slotIndex >= availableSlotsList.size()) continue;
            result.put(job.getId(), (Integer)availableSlotsList.get(slotIndex));
            ++slotIndex;
        }
        return result;
    }

    public void saveConfiguration() {
        this.plugin.getLogger().warning("Job slots configuration should be saved directly in main-menu.yml file");
        this.plugin.getLogger().info("Current slot configuration: " + String.valueOf(this.jobSlots));
    }

    private boolean isValidSlot(int slot) {
        return slot >= 0 && slot < 54;
    }

    public void addReservedSlot(int slot) {
        if (this.isValidSlot(slot)) {
            this.reservedSlots.add(slot);
            this.availableSlots.remove(slot);
            String jobId = this.slotJobs.remove(slot);
            if (jobId != null) {
                this.jobSlots.remove(jobId);
            }
        }
    }

    public void removeReservedSlot(int slot) {
        if (this.reservedSlots.remove(slot)) {
            this.availableSlots.add(slot);
        }
    }

    public Map<String, Integer> getAllJobSlots() {
        return new HashMap<String, Integer>(this.jobSlots);
    }

    public Set<Integer> getReservedSlots() {
        return new HashSet<Integer>(this.reservedSlots);
    }

    public Map<String, Object> getStats() {
        HashMap<String, Object> stats = new HashMap<String, Object>();
        stats.put("configured_jobs", this.jobSlots.size());
        stats.put("reserved_slots", this.reservedSlots.size());
        stats.put("available_slots", this.availableSlots.size());
        stats.put("total_slots", 54);
        return stats;
    }

    public void reload() {
        this.initializeDefaultSlots();
        this.loadConfiguration();
    }
}

