/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.storage;

import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.storage.pool.ConnectionPool;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public class DatabaseInitializer {
    private final UniverseJobs plugin;
    private final ConnectionPool connectionPool;

    public DatabaseInitializer(UniverseJobs plugin, ConnectionPool connectionPool) {
        this.plugin = plugin;
        this.connectionPool = connectionPool;
    }

    public boolean initializeDatabase() {
        if (!this.connectionPool.isEnabled()) {
            this.plugin.getLogger().info("Database is disabled, skipping initialization");
            return true;
        }
        try {
            this.plugin.getLogger().info("Initializing database schema...");
            String initScript = this.readInitScript();
            if (initScript == null) {
                this.plugin.getLogger().severe("Failed to read database initialization script");
                return false;
            }
            this.executeScript(initScript);
            this.insertInitialMigrationRecord();
            if (this.verifyTables()) {
                this.plugin.getLogger().info("Database initialization completed successfully");
                return true;
            }
            this.plugin.getLogger().severe("Database table verification failed");
            return false;
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to initialize database", e);
            return false;
        }
    }

    private String readInitScript() {
        try {
            InputStream inputStream = this.plugin.getResource("database/init.sql");
            if (inputStream == null) {
                this.plugin.getLogger().severe("Database init script not found in resources");
                return null;
            }
            StringBuilder script = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
                String line;
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).isEmpty() || line.startsWith("--") || line.startsWith("/*")) continue;
                    script.append(line).append("\n");
                }
            }
            return script.toString();
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to read database init script", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeScript(String trustedSchemaScript) throws Exception {
        Connection connection = this.connectionPool.getConnection();
        try {
            String[] schemaStatements = this.splitSqlScript(trustedSchemaScript);
            try (Statement stmt = connection.createStatement();){
                for (String schemaStatement : schemaStatements) {
                    if ((schemaStatement = schemaStatement.trim()).isEmpty()) continue;
                    if (this.isValidSchemaStatement(schemaStatement)) {
                        try {
                            stmt.execute(schemaStatement);
                            this.plugin.getLogger().fine("Executed database initialization statement successfully");
                        }
                        catch (Exception e) {
                            this.plugin.getLogger().log(Level.WARNING, "Failed to execute database initialization statement", e);
                        }
                        continue;
                    }
                    this.plugin.getLogger().warning("Skipped invalid schema statement during initialization");
                }
            }
        }
        finally {
            this.connectionPool.returnConnection(connection);
        }
    }

    private boolean isValidSchemaStatement(String statement) {
        if (statement == null || statement.isEmpty()) {
            return false;
        }
        String upperStatement = statement.toUpperCase().trim();
        return upperStatement.startsWith("CREATE TABLE") || upperStatement.startsWith("CREATE INDEX") || upperStatement.startsWith("ALTER TABLE") || upperStatement.startsWith("DROP INDEX") || upperStatement.startsWith("INSERT INTO") && upperStatement.contains("schema_migrations");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertInitialMigrationRecord() {
        block23: {
            try {
                Connection connection = this.connectionPool.getConnection();
                try (PreparedStatement checkStmt = connection.prepareStatement("SELECT COUNT(*) FROM schema_migrations WHERE version = ?");){
                    checkStmt.setString(1, "1.0.0");
                    try (ResultSet rs = checkStmt.executeQuery();){
                        if (!rs.next() || rs.getInt(1) != 0) break block23;
                        try (PreparedStatement insertStmt = connection.prepareStatement("INSERT INTO schema_migrations (version, description) VALUES (?, ?)");){
                            insertStmt.setString(1, "1.0.0");
                            insertStmt.setString(2, "Initial database schema");
                            insertStmt.executeUpdate();
                            this.plugin.getLogger().info("Inserted initial migration record");
                        }
                    }
                }
                finally {
                    this.connectionPool.returnConnection(connection);
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().log(Level.WARNING, "Failed to insert initial migration record", e);
            }
        }
    }

    private String[] splitSqlScript(String script) {
        ArrayList<String> statements = new ArrayList<String>();
        String[] parts = script.split(";");
        StringBuilder currentStatement = new StringBuilder();
        boolean inStoredProcedure = false;
        for (String part : parts) {
            if ((part = part.trim()).isEmpty()) continue;
            currentStatement.append(part);
            if (part.toUpperCase().contains("DELIMITER") || part.toUpperCase().contains("CREATE PROCEDURE") || part.toUpperCase().contains("CREATE FUNCTION")) {
                inStoredProcedure = true;
                currentStatement.append(";");
                continue;
            }
            if (inStoredProcedure && (part.toUpperCase().contains("END$$") || part.toUpperCase().contains("DELIMITER ;"))) {
                inStoredProcedure = false;
                statements.add(currentStatement.toString());
                currentStatement = new StringBuilder();
                continue;
            }
            if (!inStoredProcedure) {
                statements.add(currentStatement.toString());
                currentStatement = new StringBuilder();
                continue;
            }
            currentStatement.append(";");
        }
        if (currentStatement.length() > 0) {
            statements.add(currentStatement.toString());
        }
        return statements.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean verifyTables() {
        String[] requiredTables = new String[]{"player_job_data", "player_reward_claims", "performance_stats", "server_config", "schema_migrations"};
        try {
            Connection connection = this.connectionPool.getConnection();
            try {
                for (String tableName : requiredTables) {
                    if (this.tableExists(connection, tableName)) continue;
                    this.plugin.getLogger().severe("Required table '" + tableName + "' does not exist");
                    boolean bl = false;
                    return bl;
                }
                this.plugin.getLogger().info("All required database tables verified");
                boolean bl = true;
                return bl;
            }
            finally {
                this.connectionPool.returnConnection(connection);
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to verify database tables", e);
            return false;
        }
    }

    private boolean tableExists(Connection connection, String tableName) {
        boolean bl;
        block8: {
            DatabaseMetaData metaData = connection.getMetaData();
            ResultSet rs = metaData.getTables(null, null, tableName, new String[]{"TABLE"});
            try {
                bl = rs.next();
                if (rs == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    this.plugin.getLogger().log(Level.WARNING, "Failed to check if table '" + tableName + "' exists", e);
                    return false;
                }
            }
            rs.close();
        }
        return bl;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean createPerformanceIndexes() {
        if (!this.connectionPool.isEnabled()) {
            return true;
        }
        String[] indexStatements = new String[]{"CREATE INDEX IF NOT EXISTS idx_player_job_data_last_updated ON player_job_data (last_updated)", "CREATE INDEX IF NOT EXISTS idx_player_reward_claims_player_uuid ON player_reward_claims (player_uuid)", "CREATE INDEX IF NOT EXISTS idx_player_reward_claims_job_id ON player_reward_claims (job_id)", "CREATE INDEX IF NOT EXISTS idx_player_reward_claims_claim_time ON player_reward_claims (claim_time)", "CREATE INDEX IF NOT EXISTS idx_performance_stats_metric_name ON performance_stats (metric_name)", "CREATE INDEX IF NOT EXISTS idx_performance_stats_timestamp ON performance_stats (timestamp)"};
        try {
            Connection connection = this.connectionPool.getConnection();
            try {
                boolean bl;
                block15: {
                    Statement stmt = connection.createStatement();
                    try {
                        for (String indexSql : indexStatements) {
                            try {
                                stmt.execute(indexSql);
                                this.plugin.getLogger().fine("Created database index successfully");
                            }
                            catch (Exception e) {
                                this.plugin.getLogger().log(Level.WARNING, "Failed to create database index", e);
                            }
                        }
                        this.plugin.getLogger().info("Performance indexes creation completed");
                        bl = true;
                        if (stmt == null) break block15;
                    }
                    catch (Throwable throwable) {
                        if (stmt != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    stmt.close();
                }
                return bl;
            }
            finally {
                this.connectionPool.returnConnection(connection);
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to create performance indexes", e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getDatabaseInfo() {
        HashMap<String, Object> info = new HashMap<String, Object>();
        if (!this.connectionPool.isEnabled()) {
            info.put("enabled", false);
            return info;
        }
        try {
            Connection connection = this.connectionPool.getConnection();
            try {
                DatabaseMetaData metaData = connection.getMetaData();
                info.put("enabled", true);
                info.put("database_product", metaData.getDatabaseProductName());
                info.put("database_version", metaData.getDatabaseProductVersion());
                info.put("driver_name", metaData.getDriverName());
                info.put("driver_version", metaData.getDriverVersion());
                info.put("url", metaData.getURL());
                info.put("username", metaData.getUserName());
                try (Statement stmt = connection.createStatement();){
                    try (ResultSet rs = stmt.executeQuery("SELECT COUNT(*) FROM player_job_data");){
                        if (rs.next()) {
                            info.put("player_job_data_count", rs.getInt(1));
                        }
                    }
                    rs = stmt.executeQuery("SELECT COUNT(*) FROM player_reward_claims");
                    try {
                        if (rs.next()) {
                            info.put("player_reward_claims_count", rs.getInt(1));
                        }
                    }
                    finally {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                }
                catch (Exception e) {
                    info.put("table_counts_error", e.getMessage());
                }
            }
            finally {
                this.connectionPool.returnConnection(connection);
            }
        }
        catch (Exception e) {
            info.put("error", e.getMessage());
        }
        return info;
    }
}

