/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.utils;

import fr.ax_dev.universejobs.utils.LegacyToMiniMessageConverter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class LanguageFileMigrator {
    private final Logger logger;
    private final File languagesDirectory;
    private final List<String> conversionReport;

    public LanguageFileMigrator(File languagesDirectory, Logger logger) {
        this.languagesDirectory = languagesDirectory;
        this.logger = logger;
        this.conversionReport = new ArrayList<String>();
    }

    public boolean migrateAllFiles(boolean createBackup) {
        this.conversionReport.clear();
        if (!this.languagesDirectory.exists() || !this.languagesDirectory.isDirectory()) {
            this.logger.severe("Languages directory not found: " + this.languagesDirectory.getPath());
            return false;
        }
        File[] yamlFiles = this.languagesDirectory.listFiles((dir, name) -> name.endsWith(".yml"));
        if (yamlFiles == null || yamlFiles.length == 0) {
            this.logger.info("No YAML language files found to migrate.");
            return true;
        }
        this.logger.info("Starting migration of " + yamlFiles.length + " language file(s)...");
        boolean allSuccessful = true;
        int convertedFiles = 0;
        int totalConversions = 0;
        for (File file : yamlFiles) {
            try {
                MigrationResult result = this.migrateFile(file, createBackup);
                if (result.isSuccessful()) {
                    ++convertedFiles;
                    totalConversions += result.getConversionCount();
                    this.logger.info("Successfully migrated " + file.getName() + " (" + result.getConversionCount() + " messages converted)");
                } else {
                    allSuccessful = false;
                    this.logger.warning("Failed to migrate " + file.getName() + ": " + result.getErrorMessage());
                }
                this.conversionReport.addAll(result.getDetails());
            }
            catch (Exception e) {
                allSuccessful = false;
                this.logger.severe("Error migrating " + file.getName() + ": " + e.getMessage());
                this.conversionReport.add("ERROR: " + file.getName() + " - " + e.getMessage());
            }
        }
        this.logger.info("Migration complete. Files converted: " + convertedFiles + "/" + yamlFiles.length + ", Total message conversions: " + totalConversions);
        return allSuccessful;
    }

    public MigrationResult migrateFile(File file, boolean createBackup) {
        try {
            if (createBackup) {
                File backupFile = new File(file.getParent(), file.getName() + ".backup");
                Files.copy(file.toPath(), backupFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
            int conversions = this.convertConfigurationSection((ConfigurationSection)config, "");
            config.save(file);
            return new MigrationResult(true, conversions, "Migration successful", new ArrayList<String>());
        }
        catch (Exception e) {
            return new MigrationResult(false, 0, e.getMessage(), new ArrayList<String>());
        }
    }

    private int convertConfigurationSection(ConfigurationSection section, String path) {
        int conversions = 0;
        Set keys = section.getKeys(false);
        for (String key : keys) {
            String originalValue;
            String fullPath;
            String string = fullPath = path.isEmpty() ? key : path + "." + key;
            if (section.isConfigurationSection(key)) {
                conversions += this.convertConfigurationSection(section.getConfigurationSection(key), fullPath);
                continue;
            }
            if (!section.isString(key) || (originalValue = section.getString(key)) == null || !LegacyToMiniMessageConverter.containsLegacyCodes(originalValue)) continue;
            String convertedValue = LegacyToMiniMessageConverter.convert(originalValue);
            section.set(key, (Object)convertedValue);
            ++conversions;
            this.conversionReport.add("CONVERTED: " + fullPath + " | " + originalValue + " -> " + convertedValue);
        }
        return conversions;
    }

    public boolean createBackups() {
        if (!this.languagesDirectory.exists() || !this.languagesDirectory.isDirectory()) {
            this.logger.severe("Languages directory not found: " + this.languagesDirectory.getPath());
            return false;
        }
        File[] yamlFiles = this.languagesDirectory.listFiles((dir, name) -> name.endsWith(".yml"));
        if (yamlFiles == null || yamlFiles.length == 0) {
            this.logger.info("No YAML language files found to backup.");
            return true;
        }
        boolean allSuccessful = true;
        for (File file : yamlFiles) {
            try {
                File backupFile = new File(file.getParent(), file.getName() + ".backup");
                Files.copy(file.toPath(), backupFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                this.logger.info("Created backup: " + backupFile.getName());
            }
            catch (IOException e) {
                allSuccessful = false;
                this.logger.warning("Failed to create backup for " + file.getName() + ": " + e.getMessage());
            }
        }
        return allSuccessful;
    }

    public boolean restoreFromBackups() {
        if (!this.languagesDirectory.exists() || !this.languagesDirectory.isDirectory()) {
            this.logger.severe("Languages directory not found: " + this.languagesDirectory.getPath());
            return false;
        }
        File[] backupFiles = this.languagesDirectory.listFiles((dir, name) -> name.endsWith(".yml.backup"));
        if (backupFiles == null || backupFiles.length == 0) {
            this.logger.info("No backup files found to restore.");
            return true;
        }
        boolean allSuccessful = true;
        for (File backupFile : backupFiles) {
            try {
                String originalName = backupFile.getName().replace(".backup", "");
                File originalFile = new File(backupFile.getParent(), originalName);
                Files.copy(backupFile.toPath(), originalFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                this.logger.info("Restored from backup: " + originalName);
            }
            catch (IOException e) {
                allSuccessful = false;
                this.logger.warning("Failed to restore " + backupFile.getName() + ": " + e.getMessage());
            }
        }
        return allSuccessful;
    }

    public ValidationResult validateFiles() {
        if (!this.languagesDirectory.exists() || !this.languagesDirectory.isDirectory()) {
            return new ValidationResult(false, "Languages directory not found: " + this.languagesDirectory.getPath());
        }
        File[] yamlFiles = this.languagesDirectory.listFiles((dir, name) -> name.endsWith(".yml"));
        if (yamlFiles == null || yamlFiles.length == 0) {
            return new ValidationResult(true, "No YAML language files found.");
        }
        ArrayList<String> issues = new ArrayList<String>();
        int filesChecked = 0;
        int totalMessages = 0;
        int legacyMessages = 0;
        for (File file : yamlFiles) {
            try {
                YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
                ValidationFileResult fileResult = this.validateConfigurationSection((ConfigurationSection)config, "", file.getName());
                ++filesChecked;
                totalMessages += fileResult.totalMessages;
                legacyMessages += fileResult.legacyMessages;
                issues.addAll(fileResult.issues);
            }
            catch (Exception e) {
                issues.add("ERROR reading " + file.getName() + ": " + e.getMessage());
            }
        }
        String summary = String.format("Validation complete: %d files, %d messages, %d still using legacy codes", filesChecked, totalMessages, legacyMessages);
        return new ValidationResult(legacyMessages == 0, summary, issues);
    }

    private ValidationFileResult validateConfigurationSection(ConfigurationSection section, String path, String fileName) {
        ValidationFileResult result = new ValidationFileResult();
        Set keys = section.getKeys(false);
        for (String key : keys) {
            String fullPath;
            String string = fullPath = path.isEmpty() ? key : path + "." + key;
            if (section.isConfigurationSection(key)) {
                ValidationFileResult nestedResult = this.validateConfigurationSection(section.getConfigurationSection(key), fullPath, fileName);
                result.totalMessages += nestedResult.totalMessages;
                result.legacyMessages += nestedResult.legacyMessages;
                result.issues.addAll(nestedResult.issues);
                continue;
            }
            if (!section.isString(key)) continue;
            ++result.totalMessages;
            String value = section.getString(key);
            if (value == null || !LegacyToMiniMessageConverter.containsLegacyCodes(value)) continue;
            ++result.legacyMessages;
            result.issues.add("LEGACY CODE in " + fileName + " at " + fullPath + ": " + value);
        }
        return result;
    }

    public List<String> getConversionReport() {
        return new ArrayList<String>(this.conversionReport);
    }

    public static class MigrationResult {
        private final boolean successful;
        private final int conversionCount;
        private final String errorMessage;
        private final List<String> details;

        public MigrationResult(boolean successful, int conversionCount, String errorMessage, List<String> details) {
            this.successful = successful;
            this.conversionCount = conversionCount;
            this.errorMessage = errorMessage;
            this.details = details;
        }

        public boolean isSuccessful() {
            return this.successful;
        }

        public int getConversionCount() {
            return this.conversionCount;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public List<String> getDetails() {
            return this.details;
        }
    }

    public static class ValidationResult {
        private final boolean valid;
        private final String summary;
        private final List<String> issues;

        public ValidationResult(boolean valid, String summary) {
            this(valid, summary, new ArrayList<String>());
        }

        public ValidationResult(boolean valid, String summary, List<String> issues) {
            this.valid = valid;
            this.summary = summary;
            this.issues = issues;
        }

        public boolean isValid() {
            return this.valid;
        }

        public String getSummary() {
            return this.summary;
        }

        public List<String> getIssues() {
            return this.issues;
        }
    }

    private static class ValidationFileResult {
        int totalMessages = 0;
        int legacyMessages = 0;
        List<String> issues = new ArrayList<String>();

        private ValidationFileResult() {
        }
    }
}

