/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.utils;

import fr.ax_dev.universejobs.utils.CumulativeGainTracker;
import fr.ax_dev.universejobs.utils.MessageUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.title.Title;
import org.bukkit.Bukkit;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Player;

public class PacketUtils {
    private static final ScheduledExecutorService ASYNC_EXECUTOR = Executors.newScheduledThreadPool(2, r -> {
        Thread thread = new Thread(r, "UniverseJobs-PacketSender");
        thread.setDaemon(true);
        return thread;
    });
    private static final Map<UUID, BossBar> ACTIVE_BOSSBARS = new ConcurrentHashMap<UUID, BossBar>();
    private static final Map<UUID, CompletableFuture<Void>> BOSSBAR_CLEANUPS = new ConcurrentHashMap<UUID, CompletableFuture<Void>>();
    private static final Map<UUID, UUID> PACKET_BOSSBAR_IDS = new ConcurrentHashMap<UUID, UUID>();
    private static final Map<UUID, Long> BOSSBAR_CREATION_TIMES = new ConcurrentHashMap<UUID, Long>();
    private static final Object BOSSBAR_LOCK = new Object();
    private static final Map<UUID, CompletableFuture<Void>> ACTIONBAR_CLEANUPS = new ConcurrentHashMap<UUID, CompletableFuture<Void>>();
    private static final Map<UUID, Long> ACTIONBAR_CREATION_TIMES = new ConcurrentHashMap<UUID, Long>();
    private static Class<?> CLIENTBOUND_BOSS_EVENT_PACKET_CLASS;
    private static Method SEND_PACKET_METHOD;
    private static Method GET_HANDLE_METHOD;
    private static Field CONNECTION_FIELD;
    private static Object ADD_ACTION;
    private static Object REMOVE_ACTION;
    private static Object UPDATE_HEALTH_ACTION;
    private static Object UPDATE_TITLE_ACTION;
    private static Object UPDATE_STYLE_ACTION;
    private static boolean PACKET_REFLECTION_AVAILABLE;
    private static final Set<String> ALLOWED_CLASSES;
    private static final Set<String> ALLOWED_FIELDS;

    private static Class<?> secureClassForName(String className) throws ClassNotFoundException {
        if (!ALLOWED_CLASSES.contains(className)) {
            throw new SecurityException("Class not in whitelist: " + className);
        }
        return Class.forName(className);
    }

    private static Field secureGetDeclaredField(Class<?> clazz, String fieldName) throws NoSuchFieldException {
        if (!ALLOWED_FIELDS.contains(fieldName)) {
            throw new SecurityException("Field not in whitelist: " + fieldName);
        }
        Field field = clazz.getDeclaredField(fieldName);
        field.setAccessible(true);
        return field;
    }

    public static void sendActionBarAsync(Player player, String message, int durationTicks) {
        PacketUtils.sendActionBarAsync(player, message, durationTicks, 20);
    }

    public static void sendActionBarAsync(Player player, String message, int durationTicks, int tickUpdateInterval) {
        if (!player.isOnline()) {
            return;
        }
        UUID playerId = player.getUniqueId();
        CompletableFuture<Void> existingCleanup = ACTIONBAR_CLEANUPS.get(playerId);
        if (existingCleanup != null) {
            PacketUtils.cancelOldActionBarCleanupSafely(playerId);
        }
        player.sendActionBar(MessageUtils.parseMessage(message));
        if (durationTicks > 0) {
            long delayMs = (long)durationTicks * 50L;
            long tickIntervalMs = (long)tickUpdateInterval * 50L;
            long creationTime = System.currentTimeMillis();
            ACTIONBAR_CREATION_TIMES.put(playerId, creationTime);
            CompletableFuture<Void> cleanup = tickUpdateInterval != 20 && tickIntervalMs < delayMs ? CompletableFuture.runAsync(() -> {
                try {
                    Long currentCreationTime;
                    long endTime = System.currentTimeMillis() + delayMs;
                    while (System.currentTimeMillis() < endTime && player.isOnline()) {
                        Thread.sleep(tickIntervalMs);
                        currentCreationTime = ACTIONBAR_CREATION_TIMES.get(playerId);
                        if (currentCreationTime == null || !currentCreationTime.equals(creationTime)) {
                            return;
                        }
                        if (!player.isOnline()) break;
                        player.sendActionBar(MessageUtils.parseMessage(message));
                    }
                    if (player.isOnline() && (currentCreationTime = ACTIONBAR_CREATION_TIMES.get(playerId)) != null && currentCreationTime.equals(creationTime)) {
                        player.sendActionBar(MessageUtils.parseMessage(""));
                        ACTIONBAR_CLEANUPS.remove(playerId);
                        ACTIONBAR_CREATION_TIMES.remove(playerId);
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }, ASYNC_EXECUTOR) : CompletableFuture.runAsync(() -> {
                try {
                    Thread.sleep(delayMs);
                    Long currentCreationTime = ACTIONBAR_CREATION_TIMES.get(playerId);
                    if (currentCreationTime != null && currentCreationTime.equals(creationTime)) {
                        if (player.isOnline()) {
                            player.sendActionBar(MessageUtils.parseMessage(""));
                        }
                        ACTIONBAR_CLEANUPS.remove(playerId);
                        ACTIONBAR_CREATION_TIMES.remove(playerId);
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }, ASYNC_EXECUTOR);
            ACTIONBAR_CLEANUPS.put(playerId, cleanup);
        }
    }

    public static void sendBossBarAsync(Player player, String message, BarColor color, BarStyle style, double progress, int durationTicks) {
        if (PACKET_REFLECTION_AVAILABLE) {
            PacketUtils.sendBossBarPacketAsync(player, message, color, style, progress, durationTicks);
        } else {
            PacketUtils.sendBossBarAsyncInternal(player, message, color, style, progress, durationTicks);
        }
    }

    private static void sendBossBarPacketAsync(Player player, String message, BarColor color, BarStyle style, double progress, int durationTicks) {
        boolean isNewBossBar;
        if (!player.isOnline()) {
            return;
        }
        UUID playerId = player.getUniqueId();
        UUID bossBarId = PACKET_BOSSBAR_IDS.get(playerId);
        boolean bl = isNewBossBar = bossBarId == null;
        if (isNewBossBar) {
            bossBarId = UUID.randomUUID();
            PACKET_BOSSBAR_IDS.put(playerId, bossBarId);
        }
        try {
            if (isNewBossBar) {
                PacketUtils.sendAddBossBarPacket(player, bossBarId, message, color, style, progress);
            } else {
                PacketUtils.sendUpdateBossBarTitlePacket(player, bossBarId, message);
                PacketUtils.sendUpdateBossBarHealthPacket(player, bossBarId, progress);
                PacketUtils.sendUpdateBossBarStylePacket(player, bossBarId, color, style);
                PacketUtils.cancelOldCleanupSafely(playerId);
            }
            if (durationTicks > 0) {
                long delayMs = (long)durationTicks * 50L;
                UUID finalBossBarId = bossBarId;
                long creationTime = System.currentTimeMillis();
                BOSSBAR_CREATION_TIMES.put(playerId, creationTime);
                CompletableFuture<Void> cleanup = CompletableFuture.runAsync(() -> {
                    try {
                        Thread.sleep(delayMs);
                        Long currentCreationTime = BOSSBAR_CREATION_TIMES.get(playerId);
                        if (currentCreationTime != null && currentCreationTime.equals(creationTime)) {
                            if (Objects.equals(PACKET_BOSSBAR_IDS.get(playerId), finalBossBarId)) {
                                PacketUtils.sendRemoveBossBarPacket(player, finalBossBarId);
                                PACKET_BOSSBAR_IDS.remove(playerId);
                                CumulativeGainTracker.clearGains(player);
                            }
                            BOSSBAR_CLEANUPS.remove(playerId);
                            BOSSBAR_CREATION_TIMES.remove(playerId);
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }, ASYNC_EXECUTOR);
                BOSSBAR_CLEANUPS.put(playerId, cleanup);
            }
        }
        catch (Exception e) {
            PacketUtils.sendBossBarAsyncInternal(player, message, color, style, progress, durationTicks);
        }
    }

    private static void sendAddBossBarPacket(Player player, UUID bossBarId, String message, BarColor color, BarStyle style, double progress) throws Exception {
        if (ADD_ACTION == null || CLIENTBOUND_BOSS_EVENT_PACKET_CLASS == null) {
            return;
        }
        Object titleComponent = PacketUtils.createChatComponent(message);
        Object bossBarColor = PacketUtils.convertBukkitColorToNms(color);
        Object bossBarStyle = PacketUtils.convertBukkitStyleToNms(style);
        Constructor<?>[] constructors = CLIENTBOUND_BOSS_EVENT_PACKET_CLASS.getConstructors();
        Object packet = null;
        for (Constructor<?> constructor : constructors) {
            try {
                Class<?>[] paramTypes = constructor.getParameterTypes();
                if (paramTypes.length < 3 || paramTypes[0] != UUID.class) continue;
                packet = constructor.newInstance(bossBarId, ADD_ACTION, titleComponent, Float.valueOf((float)progress), bossBarColor, bossBarStyle, false, false, false);
                break;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (packet != null) {
            PacketUtils.sendPacketToPlayer(player, packet);
        }
    }

    private static void sendRemoveBossBarPacket(Player player, UUID bossBarId) {
        try {
            if (REMOVE_ACTION == null || CLIENTBOUND_BOSS_EVENT_PACKET_CLASS == null) {
                return;
            }
            Constructor<?>[] constructors = CLIENTBOUND_BOSS_EVENT_PACKET_CLASS.getConstructors();
            Object packet = null;
            for (Constructor<?> constructor : constructors) {
                try {
                    Class<?>[] paramTypes = constructor.getParameterTypes();
                    if (paramTypes.length < 2 || paramTypes[0] != UUID.class) continue;
                    packet = constructor.newInstance(bossBarId, REMOVE_ACTION);
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (packet != null) {
                PacketUtils.sendPacketToPlayer(player, packet);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void sendUpdateBossBarTitlePacket(Player player, UUID bossBarId, String message) {
        try {
            if (UPDATE_TITLE_ACTION == null) {
                return;
            }
            Object titleComponent = PacketUtils.createChatComponent(message);
            Constructor<?>[] constructors = CLIENTBOUND_BOSS_EVENT_PACKET_CLASS.getConstructors();
            Object packet = null;
            for (Constructor<?> constructor : constructors) {
                try {
                    Class<?>[] paramTypes = constructor.getParameterTypes();
                    if (paramTypes.length < 3 || paramTypes[0] != UUID.class) continue;
                    packet = constructor.newInstance(bossBarId, UPDATE_TITLE_ACTION, titleComponent);
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (packet != null) {
                PacketUtils.sendPacketToPlayer(player, packet);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void sendUpdateBossBarHealthPacket(Player player, UUID bossBarId, double progress) {
        try {
            if (UPDATE_HEALTH_ACTION == null) {
                return;
            }
            Constructor<?>[] constructors = CLIENTBOUND_BOSS_EVENT_PACKET_CLASS.getConstructors();
            Object packet = null;
            for (Constructor<?> constructor : constructors) {
                try {
                    Class<?>[] paramTypes = constructor.getParameterTypes();
                    if (paramTypes.length < 3 || paramTypes[0] != UUID.class) continue;
                    packet = constructor.newInstance(bossBarId, UPDATE_HEALTH_ACTION, Float.valueOf((float)progress));
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (packet != null) {
                PacketUtils.sendPacketToPlayer(player, packet);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void sendUpdateBossBarStylePacket(Player player, UUID bossBarId, BarColor color, BarStyle style) {
        try {
            if (UPDATE_STYLE_ACTION == null) {
                return;
            }
            Object bossBarColor = PacketUtils.convertBukkitColorToNms(color);
            Object bossBarStyle = PacketUtils.convertBukkitStyleToNms(style);
            Constructor<?>[] constructors = CLIENTBOUND_BOSS_EVENT_PACKET_CLASS.getConstructors();
            Object packet = null;
            for (Constructor<?> constructor : constructors) {
                try {
                    Class<?>[] paramTypes = constructor.getParameterTypes();
                    if (paramTypes.length < 4 || paramTypes[0] != UUID.class) continue;
                    packet = constructor.newInstance(bossBarId, UPDATE_STYLE_ACTION, bossBarColor, bossBarStyle);
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (packet != null) {
                PacketUtils.sendPacketToPlayer(player, packet);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void sendPacketToPlayer(Player player, Object packet) throws Exception {
        Object connection;
        Object nmsPlayer;
        if (GET_HANDLE_METHOD == null || SEND_PACKET_METHOD == null) {
            nmsPlayer = GET_HANDLE_METHOD.invoke((Object)player, new Object[0]);
            if (CONNECTION_FIELD == null) {
                String[] connectionFieldNames;
                for (String fieldName : connectionFieldNames = new String[]{"connection", "playerConnection", "b"}) {
                    try {
                        CONNECTION_FIELD = PacketUtils.secureGetDeclaredField(nmsPlayer.getClass(), fieldName);
                        break;
                    }
                    catch (Exception exception) {
                    }
                }
            }
            if (SEND_PACKET_METHOD == null && CONNECTION_FIELD != null) {
                String[] methodNames;
                connection = CONNECTION_FIELD.get(nmsPlayer);
                for (String methodName : methodNames = new String[]{"sendPacket", "send", "a"}) {
                    try {
                        Method method;
                        SEND_PACKET_METHOD = method = connection.getClass().getMethod(methodName, packet.getClass().getSuperclass());
                        break;
                    }
                    catch (Exception exception) {
                    }
                }
            }
        }
        if (GET_HANDLE_METHOD != null && CONNECTION_FIELD != null && SEND_PACKET_METHOD != null) {
            nmsPlayer = GET_HANDLE_METHOD.invoke((Object)player, new Object[0]);
            connection = CONNECTION_FIELD.get(nmsPlayer);
            SEND_PACKET_METHOD.invoke(connection, packet);
        }
    }

    private static void cancelOldCleanupSafely(UUID playerId) {
        CompletableFuture<Void> oldCleanup = BOSSBAR_CLEANUPS.remove(playerId);
        if (oldCleanup != null && !oldCleanup.isDone()) {
            try {
                oldCleanup.cancel(false);
            }
            catch (Exception ignored) {
                BOSSBAR_CREATION_TIMES.put(playerId, System.currentTimeMillis());
            }
        }
    }

    private static void cancelOldActionBarCleanupSafely(UUID playerId) {
        CompletableFuture<Void> oldCleanup = ACTIONBAR_CLEANUPS.remove(playerId);
        if (oldCleanup != null && !oldCleanup.isDone()) {
            try {
                oldCleanup.cancel(false);
            }
            catch (Exception ignored) {
                ACTIONBAR_CREATION_TIMES.put(playerId, System.currentTimeMillis());
            }
        }
    }

    private static Object createChatComponent(String message) throws Exception {
        try {
            return MessageUtils.parseMessage(message);
        }
        catch (Exception e) {
            try {
                Class<?> componentClass = Class.forName("net.minecraft.network.chat.Component");
                Method literalMethod = componentClass.getMethod("literal", String.class);
                return literalMethod.invoke(null, MessageUtils.colorize(message));
            }
            catch (Exception fallback) {
                return MessageUtils.colorize(message);
            }
        }
    }

    private static Object convertBukkitColorToNms(BarColor bukkitColor) {
        try {
            ?[] colors;
            Class<?> colorClass = Class.forName("net.minecraft.world.BossEvent$BossBarColor");
            for (Object color : colors = colorClass.getEnumConstants()) {
                if (!color.toString().equalsIgnoreCase(bukkitColor.name())) continue;
                return color;
            }
            for (Object color : colors) {
                if (!color.toString().equalsIgnoreCase("YELLOW")) continue;
                return color;
            }
            return colors[0];
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Object convertBukkitStyleToNms(BarStyle bukkitStyle) {
        try {
            Class<?> styleClass = Class.forName("net.minecraft.world.BossEvent$BossBarOverlay");
            ?[] styles = styleClass.getEnumConstants();
            String styleName = bukkitStyle.name();
            if (styleName.equals("SOLID")) {
                styleName = "PROGRESS";
            }
            for (Object style : styles) {
                if (!style.toString().equalsIgnoreCase(styleName)) continue;
                return style;
            }
            return styles[0];
        }
        catch (Exception e) {
            return null;
        }
    }

    private static void sendBossBarAsyncInternal(Player player, String message, BarColor color, BarStyle style, double progress, int durationTicks) {
        if (!player.isOnline()) {
            return;
        }
        UUID playerId = player.getUniqueId();
        if (PacketUtils.isPacketBossBarAvailable()) {
            UUID bossBarId = PACKET_BOSSBAR_IDS.get(playerId);
            if (bossBarId != null) {
                try {
                    PacketUtils.sendUpdateBossBarTitlePacket(player, bossBarId, message);
                    PacketUtils.sendUpdateBossBarHealthPacket(player, bossBarId, (float)Math.max(0.0, Math.min(1.0, progress)));
                    PacketUtils.sendUpdateBossBarStylePacket(player, bossBarId, color, style);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                PacketUtils.cancelOldCleanupSafely(playerId);
            } else {
                bossBarId = UUID.randomUUID();
                try {
                    PacketUtils.sendAddBossBarPacket(player, bossBarId, message, color, style, (float)Math.max(0.0, Math.min(1.0, progress)));
                    PACKET_BOSSBAR_IDS.put(playerId, bossBarId);
                }
                catch (Exception ignored) {
                    BossBar bossBar = Bukkit.createBossBar((String)MessageUtils.colorize(message), (BarColor)color, (BarStyle)style, (BarFlag[])new BarFlag[0]);
                    bossBar.setProgress(Math.max(0.0, Math.min(1.0, progress)));
                    bossBar.addPlayer(player);
                    ACTIVE_BOSSBARS.put(playerId, bossBar);
                }
            }
        } else {
            BossBar bossBar = ACTIVE_BOSSBARS.get(playerId);
            if (bossBar != null) {
                bossBar.setTitle(MessageUtils.colorize(message));
                bossBar.setColor(color);
                bossBar.setStyle(style);
                bossBar.setProgress(Math.max(0.0, Math.min(1.0, progress)));
                PacketUtils.cancelOldCleanupSafely(playerId);
            } else {
                bossBar = Bukkit.createBossBar((String)MessageUtils.colorize(message), (BarColor)color, (BarStyle)style, (BarFlag[])new BarFlag[0]);
                bossBar.setProgress(Math.max(0.0, Math.min(1.0, progress)));
                bossBar.addPlayer(player);
                ACTIVE_BOSSBARS.put(playerId, bossBar);
            }
        }
        if (durationTicks > 0) {
            long delayMs = (long)durationTicks * 50L;
            long creationTime = System.currentTimeMillis();
            BOSSBAR_CREATION_TIMES.put(playerId, creationTime);
            CompletableFuture<Void> cleanup = CompletableFuture.runAsync(() -> {
                try {
                    BossBar currentBossBar;
                    Thread.sleep(delayMs);
                    Long currentCreationTime = BOSSBAR_CREATION_TIMES.get(playerId);
                    if (currentCreationTime == null || !currentCreationTime.equals(creationTime)) {
                        return;
                    }
                    UUID currentBossBarId = PACKET_BOSSBAR_IDS.get(playerId);
                    if (currentBossBarId != null) {
                        PacketUtils.sendRemoveBossBarPacket(player, currentBossBarId);
                        PACKET_BOSSBAR_IDS.remove(playerId);
                    }
                    if ((currentBossBar = ACTIVE_BOSSBARS.get(playerId)) != null) {
                        try {
                            currentBossBar.removePlayer(player);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ACTIVE_BOSSBARS.remove(playerId);
                    }
                    CumulativeGainTracker.clearGains(player);
                    BOSSBAR_CLEANUPS.remove(playerId);
                    BOSSBAR_CREATION_TIMES.remove(playerId);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }, ASYNC_EXECUTOR);
            BOSSBAR_CLEANUPS.put(playerId, cleanup);
        }
    }

    public static void sendTitleAsync(Player player, String message, int fadeIn, int stay, int fadeOut) {
        PacketUtils.sendTitleAsync(player, message, fadeIn, stay, fadeOut, 20);
    }

    public static void sendTitleAsync(Player player, String message, int fadeIn, int stay, int fadeOut, int tickUpdateInterval) {
        long stayMs;
        long tickIntervalMs;
        if (!player.isOnline()) {
            return;
        }
        Component titleComponent = MessageUtils.parseMessage(message);
        TextComponent subtitleComponent = Component.empty();
        player.showTitle(Title.title((Component)titleComponent, (Component)subtitleComponent, (Title.Times)Title.Times.times((Duration)Duration.ofMillis((long)fadeIn * 50L), (Duration)Duration.ofMillis((long)stay * 50L), (Duration)Duration.ofMillis((long)fadeOut * 50L))));
        if (tickUpdateInterval != 20 && stay > 0 && (tickIntervalMs = (long)tickUpdateInterval * 50L) < (stayMs = (long)stay * 50L)) {
            ASYNC_EXECUTOR.schedule(() -> {
                try {
                    long endTime = System.currentTimeMillis() + stayMs;
                    while (System.currentTimeMillis() < endTime && player.isOnline()) {
                        Thread.sleep(tickIntervalMs);
                        if (player.isOnline()) {
                            Component refreshedTitle = MessageUtils.parseMessage(message);
                            int remainingStay = Math.min(stay, (int)(tickIntervalMs / 50L));
                            player.showTitle(Title.title((Component)refreshedTitle, (Component)Component.empty(), (Title.Times)Title.Times.times((Duration)Duration.ofMillis(0L), (Duration)Duration.ofMillis((long)remainingStay * 50L), (Duration)Duration.ofMillis(0L))));
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }, 0L, TimeUnit.MILLISECONDS);
        }
    }

    public static void sendChatAsync(Player player, String message) {
        if (!player.isOnline()) {
            return;
        }
        CompletableFuture.runAsync(() -> {
            if (player.isOnline()) {
                MessageUtils.sendMessage(player, message);
            }
        }, ASYNC_EXECUTOR);
    }

    public static void cleanupPlayer(UUID playerId) {
        Player player;
        BossBar bossBar;
        Player player2;
        PacketUtils.cancelOldCleanupSafely(playerId);
        PacketUtils.cancelOldActionBarCleanupSafely(playerId);
        UUID packetBossBarId = PACKET_BOSSBAR_IDS.remove(playerId);
        if (packetBossBarId != null && (player2 = Bukkit.getPlayer((UUID)playerId)) != null && player2.isOnline()) {
            PacketUtils.sendRemoveBossBarPacket(player2, packetBossBarId);
        }
        if ((bossBar = ACTIVE_BOSSBARS.remove(playerId)) != null) {
            try {
                bossBar.removeAll();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((player = Bukkit.getPlayer((UUID)playerId)) != null && player.isOnline()) {
            try {
                player.sendActionBar(MessageUtils.parseMessage(""));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        CumulativeGainTracker.clearGains(player);
        BOSSBAR_CREATION_TIMES.remove(playerId);
        ACTIONBAR_CREATION_TIMES.remove(playerId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void forceCleanupPlayerBossbars(Player player) {
        if (player == null || !player.isOnline()) {
            return;
        }
        UUID playerId = player.getUniqueId();
        Object object = BOSSBAR_LOCK;
        synchronized (object) {
            BossBar bossBar;
            PacketUtils.cancelOldCleanupSafely(playerId);
            UUID packetBossBarId = PACKET_BOSSBAR_IDS.remove(playerId);
            if (packetBossBarId != null) {
                PacketUtils.sendRemoveBossBarPacket(player, packetBossBarId);
            }
            if ((bossBar = ACTIVE_BOSSBARS.remove(playerId)) != null) {
                try {
                    bossBar.removePlayer(player);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                BossBar clearBar = Bukkit.createBossBar((String)"", (BarColor)BarColor.WHITE, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]);
                clearBar.addPlayer(player);
                clearBar.removePlayer(player);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void shutdown() {
        BOSSBAR_CLEANUPS.clear();
        BOSSBAR_CREATION_TIMES.clear();
        ACTIONBAR_CLEANUPS.clear();
        ACTIONBAR_CREATION_TIMES.clear();
        PACKET_BOSSBAR_IDS.entrySet().forEach(entry -> {
            Player player = Bukkit.getPlayer((UUID)((UUID)entry.getKey()));
            if (player != null && player.isOnline()) {
                PacketUtils.sendRemoveBossBarPacket(player, (UUID)entry.getValue());
            }
        });
        PACKET_BOSSBAR_IDS.clear();
        ACTIVE_BOSSBARS.values().forEach(bar -> {
            try {
                bar.removeAll();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        ACTIVE_BOSSBARS.clear();
        ACTIONBAR_CREATION_TIMES.keySet().forEach(playerId -> {
            Player player = Bukkit.getPlayer((UUID)playerId);
            if (player != null && player.isOnline()) {
                try {
                    player.sendActionBar(MessageUtils.parseMessage(""));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        CumulativeGainTracker.clearAllGains();
        ASYNC_EXECUTOR.shutdown();
        try {
            if (!ASYNC_EXECUTOR.awaitTermination(2L, TimeUnit.SECONDS)) {
                ASYNC_EXECUTOR.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            ASYNC_EXECUTOR.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    private static void initializeReflection() {
        try {
            boolean isModern;
            String version = Bukkit.getServer().getClass().getPackage().getName().replace(".", ",").split(",")[3];
            boolean bl = isModern = version.contains("1_20") || version.contains("1_21") || version.contains("1_19");
            if (isModern) {
                PacketUtils.initializeModernReflection();
            } else {
                PacketUtils.initializeLegacyReflection(version);
            }
        }
        catch (Exception e) {
            PACKET_REFLECTION_AVAILABLE = false;
        }
    }

    private static void initializeModernReflection() {
        try {
            String[] packetNames;
            Class<?> craftPlayerClass = PacketUtils.secureClassForName("org.bukkit.craftbukkit." + PacketUtils.getServerVersion() + ".entity.CraftPlayer");
            GET_HANDLE_METHOD = craftPlayerClass.getMethod("getHandle", new Class[0]);
            for (String packetName : packetNames = new String[]{"net.minecraft.network.protocol.game.ClientboundBossEventPacket", "net.minecraft.server." + PacketUtils.getServerVersion() + ".PacketPlayOutBoss", "net.minecraft.server.network.protocol.game.PacketPlayOutBoss"}) {
                try {
                    CLIENTBOUND_BOSS_EVENT_PACKET_CLASS = PacketUtils.secureClassForName(packetName);
                    break;
                }
                catch (Exception exception) {
                }
            }
            if (CLIENTBOUND_BOSS_EVENT_PACKET_CLASS != null) {
                PacketUtils.initializePacketActions();
                PACKET_REFLECTION_AVAILABLE = true;
            }
        }
        catch (Exception e) {
            PACKET_REFLECTION_AVAILABLE = false;
        }
    }

    private static void initializeLegacyReflection(String version) {
        try {
            Class<?> craftPlayerClass = PacketUtils.secureClassForName("org.bukkit.craftbukkit." + version + ".entity.CraftPlayer");
            GET_HANDLE_METHOD = craftPlayerClass.getMethod("getHandle", new Class[0]);
            CLIENTBOUND_BOSS_EVENT_PACKET_CLASS = PacketUtils.secureClassForName("net.minecraft.server." + version + ".PacketPlayOutBoss");
            if (CLIENTBOUND_BOSS_EVENT_PACKET_CLASS != null) {
                PacketUtils.initializePacketActions();
                PACKET_REFLECTION_AVAILABLE = true;
            }
        }
        catch (Exception e) {
            PACKET_REFLECTION_AVAILABLE = false;
        }
    }

    private static void initializePacketActions() throws Exception {
        Class<?>[] innerClasses = CLIENTBOUND_BOSS_EVENT_PACKET_CLASS.getDeclaredClasses();
        Class<?> actionClass = null;
        for (Class<?> innerClass : innerClasses) {
            if (!innerClass.isEnum() || !innerClass.getSimpleName().contains("Action")) continue;
            actionClass = innerClass;
            break;
        }
        if (actionClass != null) {
            T[] actions;
            block18: for (Object action : actions = actionClass.getEnumConstants()) {
                String name;
                switch (name = action.toString()) {
                    case "ADD": {
                        ADD_ACTION = action;
                        continue block18;
                    }
                    case "REMOVE": {
                        REMOVE_ACTION = action;
                        continue block18;
                    }
                    case "UPDATE_HEALTH": 
                    case "UPDATE_PCT": {
                        UPDATE_HEALTH_ACTION = action;
                        continue block18;
                    }
                    case "UPDATE_TITLE": 
                    case "UPDATE_NAME": {
                        UPDATE_TITLE_ACTION = action;
                        continue block18;
                    }
                    case "UPDATE_STYLE": 
                    case "UPDATE_PROPERTIES": {
                        UPDATE_STYLE_ACTION = action;
                    }
                }
            }
        }
    }

    private static String getServerVersion() {
        return Bukkit.getServer().getClass().getPackage().getName().replace(".", ",").split(",")[3];
    }

    public static ScheduledExecutorService getAsyncExecutor() {
        return ASYNC_EXECUTOR;
    }

    public static CompletableFuture<Void> runDelayed(Runnable task, long delayMs) {
        return CompletableFuture.runAsync(() -> {
            try {
                Thread.sleep(delayMs);
                task.run();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }, ASYNC_EXECUTOR);
    }

    public static boolean isPacketBossBarAvailable() {
        return PACKET_REFLECTION_AVAILABLE && ADD_ACTION != null && REMOVE_ACTION != null && CLIENTBOUND_BOSS_EVENT_PACKET_CLASS != null;
    }

    public static String getBossBarImplementationStatus() {
        StringBuilder status = new StringBuilder();
        status.append("BossBar Implementation Status:\n");
        status.append("- Packet Reflection Available: ").append(PACKET_REFLECTION_AVAILABLE).append("\n");
        status.append("- Server Version: ").append(PacketUtils.getServerVersion()).append("\n");
        status.append("- ClientboundBossEventPacket: ").append(CLIENTBOUND_BOSS_EVENT_PACKET_CLASS != null ? "Found" : "Not Found").append("\n");
        status.append("- ADD Action: ").append(ADD_ACTION != null ? "Found" : "Not Found").append("\n");
        status.append("- REMOVE Action: ").append(REMOVE_ACTION != null ? "Found" : "Not Found").append("\n");
        status.append("- UPDATE_HEALTH Action: ").append(UPDATE_HEALTH_ACTION != null ? "Found" : "Not Found").append("\n");
        status.append("- UPDATE_TITLE Action: ").append(UPDATE_TITLE_ACTION != null ? "Found" : "Not Found").append("\n");
        status.append("- Active Packet BossBars: ").append(PACKET_BOSSBAR_IDS.size()).append("\n");
        status.append("- Active Bukkit BossBars: ").append(ACTIVE_BOSSBARS.size());
        return status.toString();
    }

    static {
        PACKET_REFLECTION_AVAILABLE = false;
        ALLOWED_CLASSES = new HashSet<String>();
        ALLOWED_FIELDS = new HashSet<String>();
        ALLOWED_CLASSES.add("org.bukkit.craftbukkit.v1_17_R1.entity.CraftPlayer");
        ALLOWED_CLASSES.add("org.bukkit.craftbukkit.v1_18_R1.entity.CraftPlayer");
        ALLOWED_CLASSES.add("org.bukkit.craftbukkit.v1_18_R2.entity.CraftPlayer");
        ALLOWED_CLASSES.add("org.bukkit.craftbukkit.v1_19_R1.entity.CraftPlayer");
        ALLOWED_CLASSES.add("org.bukkit.craftbukkit.v1_19_R2.entity.CraftPlayer");
        ALLOWED_CLASSES.add("org.bukkit.craftbukkit.v1_19_R3.entity.CraftPlayer");
        ALLOWED_CLASSES.add("org.bukkit.craftbukkit.v1_20_R1.entity.CraftPlayer");
        ALLOWED_CLASSES.add("org.bukkit.craftbukkit.v1_20_R2.entity.CraftPlayer");
        ALLOWED_CLASSES.add("org.bukkit.craftbukkit.v1_20_R3.entity.CraftPlayer");
        ALLOWED_CLASSES.add("org.bukkit.craftbukkit.v1_21_R1.entity.CraftPlayer");
        ALLOWED_CLASSES.add("net.minecraft.network.protocol.game.ClientboundBossEventPacket");
        ALLOWED_CLASSES.add("net.minecraft.server.v1_17_R1.PacketPlayOutBoss");
        ALLOWED_CLASSES.add("net.minecraft.server.v1_18_R1.PacketPlayOutBoss");
        ALLOWED_CLASSES.add("net.minecraft.server.v1_18_R2.PacketPlayOutBoss");
        ALLOWED_CLASSES.add("net.minecraft.server.v1_19_R1.PacketPlayOutBoss");
        ALLOWED_CLASSES.add("net.minecraft.server.v1_19_R2.PacketPlayOutBoss");
        ALLOWED_CLASSES.add("net.minecraft.server.v1_19_R3.PacketPlayOutBoss");
        ALLOWED_CLASSES.add("net.minecraft.server.v1_20_R1.PacketPlayOutBoss");
        ALLOWED_CLASSES.add("net.minecraft.server.v1_20_R2.PacketPlayOutBoss");
        ALLOWED_CLASSES.add("net.minecraft.server.v1_20_R3.PacketPlayOutBoss");
        ALLOWED_CLASSES.add("net.minecraft.server.v1_21_R1.PacketPlayOutBoss");
        ALLOWED_CLASSES.add("net.minecraft.server.network.protocol.game.PacketPlayOutBoss");
        ALLOWED_FIELDS.add("connection");
        ALLOWED_FIELDS.add("playerConnection");
        ALLOWED_FIELDS.add("b");
        PacketUtils.initializeReflection();
    }
}

