/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.menu;

import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.menu.MenuUtils;
import fr.ax_dev.universejobs.menu.config.MenuItemConfig;
import fr.ax_dev.universejobs.menu.config.SingleMenuConfig;
import fr.ax_dev.universejobs.utils.MessageUtils;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public abstract class BaseMenu
implements InventoryHolder {
    protected final UniverseJobs plugin;
    protected final Player player;
    protected final SingleMenuConfig config;
    protected Inventory inventory;
    protected int currentPage = 0;

    public BaseMenu(UniverseJobs plugin, Player player, SingleMenuConfig config) {
        this.plugin = plugin;
        this.player = player;
        this.config = config;
    }

    protected final void initialize() {
        this.createInventory();
        this.populateInventory();
    }

    protected void createInventory() {
        String title = this.processPlaceholders(this.config.getTitle());
        Component titleComponent = MessageUtils.parseMessage(title);
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)this.config.getSize(), (Component)titleComponent);
    }

    protected abstract void populateInventory();

    public abstract void handleClick(int var1, InventoryClickEvent var2);

    public void open() {
        this.player.openInventory(this.inventory);
    }

    public void close() {
        this.player.closeInventory();
    }

    public void onClose() {
    }

    public boolean isInventory(Inventory inventory) {
        return this.inventory.equals((Object)inventory);
    }

    public void refresh() {
        this.inventory.clear();
        this.populateInventory();
    }

    protected ItemStack createMenuItem(MenuItemConfig itemConfig) {
        return MenuUtils.createMenuItem(this.plugin, this.player, itemConfig);
    }

    protected ItemStack createMenuItem(MenuItemConfig itemConfig, Map<String, String> customPlaceholders) {
        return MenuUtils.createMenuItem(this.plugin, this.player, itemConfig, customPlaceholders);
    }

    protected void addFillItems() {
        MenuItemConfig fillConfig = this.config.getFillItem();
        if (fillConfig == null || !fillConfig.isEnabled()) {
            return;
        }
        ItemStack fillItem = this.createMenuItem(fillConfig);
        List<Integer> slotsToFill = fillConfig.getSlots();
        if (slotsToFill.isEmpty()) {
            slotsToFill = this.config.getFillSlots();
        }
        for (int slot : slotsToFill) {
            if (slot < 0 || slot >= this.inventory.getSize() || this.inventory.getItem(slot) != null) continue;
            this.inventory.setItem(slot, fillItem);
        }
    }

    protected String processPlaceholders(String text) {
        return MenuUtils.processPlaceholders(this.player, text);
    }

    protected String replacePlaceholders(String text, Map<String, String> placeholders) {
        return MenuUtils.replacePlaceholders(text, placeholders);
    }

    protected boolean handleNavigationClick(int slot) {
        for (MenuItemConfig navItem : this.config.getNavigationItems().values()) {
            if (!navItem.getSlots().contains(slot)) continue;
            String action = navItem.getAction();
            return this.handleActionClick(action);
        }
        return false;
    }

    protected boolean handleActionClick(String action) {
        switch (action) {
            case "previous_page": {
                if (this.currentPage <= 0) break;
                --this.currentPage;
                this.refresh();
                return true;
            }
            case "next_page": {
                if (!this.hasNextPage()) break;
                ++this.currentPage;
                this.refresh();
                return true;
            }
            case "close": {
                this.close();
                return true;
            }
            case "back": {
                this.handleBackButton();
                return true;
            }
            case "none": {
                return true;
            }
        }
        return false;
    }

    protected boolean handleNavigationClickWithSound(int slot) {
        for (MenuItemConfig navItem : this.config.getNavigationItems().values()) {
            if (!navItem.getSlots().contains(slot)) continue;
            String action = navItem.getAction();
            String sound = navItem.getSound();
            if (sound != null && !sound.isEmpty()) {
                this.playSound(sound);
            }
            if (navItem.getCommands() != null && !navItem.getCommands().isEmpty()) {
                this.executeCommands(navItem.getCommands());
            }
            return this.handleActionClick(action);
        }
        return false;
    }

    protected void executeCommands(List<String> commands) {
        if (commands == null || commands.isEmpty()) {
            return;
        }
        for (String command : commands) {
            String processedCommand = command.replace("{player}", this.player.getName());
            if (processedCommand.startsWith("[console] ")) {
                String consoleCommand = processedCommand.substring(10);
                this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getServer().getConsoleSender(), consoleCommand);
                continue;
            }
            if (processedCommand.startsWith("[player] ")) {
                String playerCommand = processedCommand.substring(9);
                this.plugin.getServer().dispatchCommand((CommandSender)this.player, playerCommand);
                continue;
            }
            this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getServer().getConsoleSender(), processedCommand);
        }
    }

    protected void playSound(String soundName) {
        if (soundName == null || soundName.isEmpty()) {
            return;
        }
        try {
            Sound sound = Sound.valueOf((String)soundName.toUpperCase().replace(".", "_"));
            this.player.playSound(this.player.getLocation(), sound, 1.0f, 1.0f);
        }
        catch (IllegalArgumentException e) {
            try {
                this.player.playSound(this.player.getLocation(), soundName, 1.0f, 1.0f);
            }
            catch (Exception ex) {
                this.plugin.getLogger().warning("Invalid sound: " + soundName);
            }
        }
    }

    protected abstract boolean hasNextPage();

    protected void handleBackButton() {
        this.close();
    }

    public Inventory getInventory() {
        return this.inventory;
    }
}

