/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.menu;

import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.menu.config.BoostMenuConfig;
import fr.ax_dev.universejobs.menu.config.SingleMenuConfig;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class MenuConfig {
    private final UniverseJobs plugin;
    private final File menusFolder;
    private SingleMenuConfig mainMenuConfig;
    private SingleMenuConfig jobMenuConfig;
    private SingleMenuConfig actionsMenuConfig;
    private SingleMenuConfig rankingsMenuConfig;
    private BoostMenuConfig boostMenuConfig;

    public MenuConfig(UniverseJobs plugin) {
        this.plugin = plugin;
        this.menusFolder = new File(plugin.getDataFolder(), "menus");
        this.createMenusFolder();
    }

    private void createMenusFolder() {
        String[] defaultConfigs;
        if (!this.menusFolder.exists()) {
            this.menusFolder.mkdirs();
        }
        for (String configName : defaultConfigs = new String[]{"main-menu.yml", "job-menu.yml", "actions-menu.yml", "rankings-menu.yml", "boost-manager.yml"}) {
            File configFile = new File(this.menusFolder, configName);
            if (configFile.exists()) continue;
            this.copyDefaultConfig(configName, configFile);
        }
    }

    private void copyDefaultConfig(String resourceName, File target) {
        try (InputStream inputStream = this.plugin.getResource("menus/" + resourceName);){
            if (inputStream != null) {
                Files.copy(inputStream, target.toPath(), new CopyOption[0]);
                this.plugin.getLogger().info("Created default menu configuration: " + resourceName);
            }
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to copy default menu configuration '" + resourceName + "': " + e.getMessage());
        }
    }

    public void loadConfigurations() {
        try {
            File mainMenuFile = new File(this.menusFolder, "main-menu.yml");
            if (mainMenuFile.exists()) {
                YamlConfiguration mainConfig = YamlConfiguration.loadConfiguration((File)mainMenuFile);
                this.mainMenuConfig = new SingleMenuConfig((ConfigurationSection)mainConfig);
            } else {
                this.plugin.getLogger().warning("Main menu configuration not found, using defaults");
                this.mainMenuConfig = SingleMenuConfig.getDefaultMainMenu();
            }
            File jobMenuFile = new File(this.menusFolder, "job-menu.yml");
            if (jobMenuFile.exists()) {
                YamlConfiguration jobConfig = YamlConfiguration.loadConfiguration((File)jobMenuFile);
                this.jobMenuConfig = new SingleMenuConfig((ConfigurationSection)jobConfig);
            } else {
                this.plugin.getLogger().warning("Job menu configuration not found, using defaults");
                this.jobMenuConfig = SingleMenuConfig.getDefaultJobMenu();
            }
            File actionsMenuFile = new File(this.menusFolder, "actions-menu.yml");
            if (actionsMenuFile.exists()) {
                YamlConfiguration actionsConfig = YamlConfiguration.loadConfiguration((File)actionsMenuFile);
                this.actionsMenuConfig = new SingleMenuConfig((ConfigurationSection)actionsConfig);
            } else {
                this.plugin.getLogger().warning("Actions menu configuration not found, using defaults");
                this.actionsMenuConfig = SingleMenuConfig.getDefaultActionsMenu();
            }
            File rankingsMenuFile = new File(this.menusFolder, "rankings-menu.yml");
            if (rankingsMenuFile.exists()) {
                YamlConfiguration rankingsConfig = YamlConfiguration.loadConfiguration((File)rankingsMenuFile);
                this.rankingsMenuConfig = new SingleMenuConfig((ConfigurationSection)rankingsConfig);
            } else {
                this.plugin.getLogger().warning("Rankings menu configuration not found, using defaults");
                this.rankingsMenuConfig = SingleMenuConfig.getDefaultRankingsMenu();
            }
            this.boostMenuConfig = new BoostMenuConfig(this.plugin);
            this.boostMenuConfig.loadConfiguration();
            this.plugin.getLogger().info("Menu configurations loaded successfully");
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Failed to load menu configurations: " + e.getMessage());
            this.mainMenuConfig = SingleMenuConfig.getDefaultMainMenu();
            this.jobMenuConfig = SingleMenuConfig.getDefaultJobMenu();
            this.actionsMenuConfig = SingleMenuConfig.getDefaultActionsMenu();
            this.rankingsMenuConfig = SingleMenuConfig.getDefaultRankingsMenu();
            this.boostMenuConfig = new BoostMenuConfig(this.plugin);
            this.boostMenuConfig.loadConfiguration();
        }
    }

    public void saveConfiguration(String fileName, FileConfiguration config) {
        try {
            File configFile = new File(this.menusFolder, fileName);
            config.save(configFile);
            this.plugin.getLogger().info("Saved menu configuration: " + fileName);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to save menu configuration '" + fileName + "': " + e.getMessage());
        }
    }

    public SingleMenuConfig getMainMenuConfig() {
        return this.mainMenuConfig;
    }

    public SingleMenuConfig getJobMenuConfig() {
        return this.jobMenuConfig;
    }

    public SingleMenuConfig getActionsMenuConfig() {
        return this.actionsMenuConfig;
    }

    public SingleMenuConfig getRankingsMenuConfig() {
        return this.rankingsMenuConfig;
    }

    public BoostMenuConfig getBoostMenuConfig() {
        return this.boostMenuConfig;
    }

    public File getMenusFolder() {
        return this.menusFolder;
    }
}

