/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.menu;

import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.menu.config.MenuItemConfig;
import fr.ax_dev.universejobs.reward.gui.ItemBuilder;
import java.net.URL;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.profile.PlayerProfile;

public class MenuUtils {
    public static String processPlaceholders(Player player, String text) {
        if (text == null) {
            return "";
        }
        try {
            if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
                text = PlaceholderAPI.setPlaceholders((Player)player, (String)text);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return text;
    }

    public static String replacePlaceholders(String text, Map<String, String> placeholders) {
        if (text == null || placeholders == null) {
            return text;
        }
        String result = text;
        for (Map.Entry<String, String> entry : placeholders.entrySet()) {
            String key = entry.getKey();
            if (key.startsWith("{") && key.endsWith("}")) {
                result = result.replace(key, entry.getValue());
                continue;
            }
            result = result.replace("{" + key + "}", entry.getValue());
        }
        return result;
    }

    private static List<String> processLoreLineWithMultiLine(String loreLine, Map<String, String> customPlaceholders, Player player) {
        ArrayList<String> result = new ArrayList<String>();
        if (loreLine.contains("{job_description}") && customPlaceholders != null && customPlaceholders.containsKey("job_description_lines")) {
            String[] descriptionLines = customPlaceholders.get("job_description_lines").split("\n");
            String baseFormat = loreLine.replace("{job_description}", "");
            for (String descLine : descriptionLines) {
                if (descLine.trim().isEmpty()) {
                    result.add("");
                    continue;
                }
                Object processedLine = baseFormat + descLine;
                if (customPlaceholders != null) {
                    processedLine = MenuUtils.replacePlaceholders((String)processedLine, customPlaceholders);
                }
                processedLine = MenuUtils.processPlaceholders(player, (String)processedLine);
                result.add((String)processedLine);
            }
        } else {
            String processedLore = loreLine;
            if (customPlaceholders != null) {
                processedLore = MenuUtils.replacePlaceholders(processedLore, customPlaceholders);
            }
            processedLore = MenuUtils.processPlaceholders(player, processedLore);
            result.add(processedLore);
        }
        return result;
    }

    public static ItemStack createMenuItem(UniverseJobs plugin, Player player, MenuItemConfig itemConfig) {
        return MenuUtils.createMenuItem(plugin, player, itemConfig, null);
    }

    public static ItemStack createMenuItem(UniverseJobs plugin, Player player, MenuItemConfig itemConfig, Map<String, String> customPlaceholders) {
        ItemStack item;
        ItemMeta meta;
        ItemBuilder builder = ItemBuilder.fromMaterialName(plugin, itemConfig.getMaterial()).amount(itemConfig.getAmount());
        String displayName = itemConfig.getDisplayName();
        if (customPlaceholders != null) {
            displayName = MenuUtils.replacePlaceholders(displayName, customPlaceholders);
        }
        displayName = MenuUtils.processPlaceholders(player, displayName);
        builder.name(displayName);
        ArrayList<String> lore = new ArrayList<String>();
        for (String loreLine : itemConfig.getLore()) {
            List<String> processedLines = MenuUtils.processLoreLineWithMultiLine(loreLine, customPlaceholders, player);
            lore.addAll(processedLines);
        }
        builder.lore(lore);
        if (itemConfig.getCustomModelData() > 0) {
            builder.customModelData(itemConfig.getCustomModelData());
        }
        if (itemConfig.isHideAttributes() || itemConfig.isHideEnchants()) {
            builder.hideAttributes();
        }
        if ((meta = (item = builder.build()).getItemMeta()) != null) {
            block21: {
                if (item.getType() == Material.PLAYER_HEAD && meta instanceof SkullMeta) {
                    SkullMeta skullMeta = (SkullMeta)meta;
                    if (!itemConfig.getPlayerHead().isEmpty()) {
                        String playerHead = itemConfig.getPlayerHead();
                        if (customPlaceholders != null) {
                            playerHead = MenuUtils.replacePlaceholders(playerHead, customPlaceholders);
                        }
                        playerHead = MenuUtils.processPlaceholders(player, playerHead);
                        try {
                            if (playerHead.length() > 20 && MenuUtils.isValidBase64(playerHead)) {
                                MenuUtils.setSkullTexture(skullMeta, playerHead);
                                break block21;
                            }
                            skullMeta.setOwningPlayer(plugin.getServer().getOfflinePlayer(playerHead));
                        }
                        catch (Exception e) {
                            plugin.getLogger().warning("Failed to set player head: " + playerHead);
                        }
                    } else if (!itemConfig.getSkullOwner().isEmpty()) {
                        String skullOwner = itemConfig.getSkullOwner();
                        if (customPlaceholders != null) {
                            skullOwner = MenuUtils.replacePlaceholders(skullOwner, customPlaceholders);
                        }
                        skullOwner = MenuUtils.processPlaceholders(player, skullOwner);
                        try {
                            skullMeta.setOwningPlayer(plugin.getServer().getOfflinePlayer(skullOwner));
                        }
                        catch (Exception e) {
                            plugin.getLogger().warning("Failed to set skull owner: " + skullOwner);
                        }
                    }
                }
            }
            for (Map.Entry<String, Integer> entry : itemConfig.getEnchantments().entrySet()) {
                try {
                    Enchantment enchantment = Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)entry.getKey().toLowerCase()));
                    if (enchantment == null) continue;
                    meta.addEnchant(enchantment, entry.getValue().intValue(), true);
                }
                catch (Exception e) {
                    plugin.getLogger().warning("Invalid enchantment: " + entry.getKey());
                }
            }
            if (itemConfig.isGlow() && itemConfig.getEnchantments().isEmpty()) {
                meta.addEnchant(Enchantment.LURE, 1, true);
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            }
            if (itemConfig.isHideToolTip()) {
                meta.setHideTooltip(true);
            }
            item.setItemMeta(meta);
        }
        return item;
    }

    private static boolean isValidBase64(String str) {
        try {
            Base64.getDecoder().decode(str);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private static void setSkullTexture(SkullMeta skullMeta, String textureValue) {
        try {
            String decodedTexture = new String(Base64.getDecoder().decode(textureValue));
            if (decodedTexture.contains("\"url\":\"")) {
                String textureUrl = decodedTexture.split("\"url\":\"")[1].split("\"")[0];
                PlayerProfile profile = Bukkit.createPlayerProfile((UUID)UUID.randomUUID(), (String)"");
                profile.getTextures().setSkin(new URL(textureUrl));
                skullMeta.setOwnerProfile(profile);
            }
        }
        catch (Exception e) {
            try {
                PlayerProfile profile = Bukkit.createPlayerProfile((UUID)UUID.randomUUID(), (String)"");
                String textureUrl = "http://textures.minecraft.net/texture/" + textureValue;
                profile.getTextures().setSkin(new URL(textureUrl));
                skullMeta.setOwnerProfile(profile);
            }
            catch (Exception ex) {
                throw new RuntimeException("Failed to set skull texture", ex);
            }
        }
    }
}

