/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.reward.gui;

import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.config.LanguageManager;
import fr.ax_dev.universejobs.job.Job;
import fr.ax_dev.universejobs.menu.MenuUtils;
import fr.ax_dev.universejobs.reward.Reward;
import fr.ax_dev.universejobs.reward.RewardManager;
import fr.ax_dev.universejobs.reward.RewardStatus;
import fr.ax_dev.universejobs.reward.gui.CustomRewardGui;
import fr.ax_dev.universejobs.reward.gui.GuiConfig;
import fr.ax_dev.universejobs.reward.gui.ItemBuilder;
import fr.ax_dev.universejobs.utils.MessageUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class RewardGuiManager
implements Listener {
    private final UniverseJobs plugin;
    private final LanguageManager languageManager;
    private final RewardManager rewardManager;
    private final Map<UUID, Object> openGuis;

    public RewardGuiManager(UniverseJobs plugin, RewardManager rewardManager) {
        this.plugin = plugin;
        this.languageManager = plugin.getLanguageManager();
        this.rewardManager = rewardManager;
        this.openGuis = new ConcurrentHashMap<UUID, Object>();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public void openRewardsGui(Player player, String jobId) {
        Job job = this.plugin.getJobManager().getJob(jobId);
        if (job == null) {
            MessageUtils.sendMessage(player, this.languageManager.getMessage("rewards.gui.job-not-found", "job", jobId));
            return;
        }
        List<Reward> rewards = this.rewardManager.getJobRewards(jobId);
        if (rewards.isEmpty()) {
            MessageUtils.sendMessage(player, this.languageManager.getMessage("rewards.gui.no-rewards", "job", job.getName()));
            return;
        }
        ArrayList<Reward> availableRewards = new ArrayList<Reward>();
        for (Reward reward : rewards) {
            if (reward.getPermission() != null && !player.hasPermission(reward.getPermission())) continue;
            availableRewards.add(reward);
        }
        if (availableRewards.isEmpty()) {
            MessageUtils.sendMessage(player, this.languageManager.getMessage("rewards.gui.no-available-rewards", "job", job.getName()));
            return;
        }
        GuiConfig guiConfig = this.rewardManager.getGuiConfig(job.getId());
        if (guiConfig != null) {
            CustomRewardGui customGui = new CustomRewardGui(this.plugin, player, job, availableRewards, guiConfig, 0);
            this.openGuis.put(player.getUniqueId(), customGui);
            customGui.open();
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        RewardGui gui;
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        Object guiObj = this.openGuis.get(player.getUniqueId());
        if (guiObj == null) {
            return;
        }
        event.setCancelled(true);
        if (guiObj instanceof CustomRewardGui) {
            CustomRewardGui customGui = (CustomRewardGui)guiObj;
            if (customGui.isInventory(event.getInventory())) {
                customGui.handleClick(event.getSlot());
            }
        } else if (guiObj instanceof RewardGui && (gui = (RewardGui)guiObj).isInventory(event.getInventory())) {
            ItemStack clickedItem = event.getCurrentItem();
            if (clickedItem == null || clickedItem.getType() == Material.AIR) {
                return;
            }
            gui.handleClick(event.getSlot(), clickedItem);
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        HumanEntity humanEntity = event.getPlayer();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        Object guiObj = this.openGuis.get(player.getUniqueId());
        if (guiObj != null) {
            boolean shouldRemove = false;
            if (guiObj instanceof CustomRewardGui) {
                CustomRewardGui customGui = (CustomRewardGui)guiObj;
                shouldRemove = customGui.isInventory(event.getInventory());
            } else if (guiObj instanceof RewardGui) {
                RewardGui gui = (RewardGui)guiObj;
                shouldRemove = gui.isInventory(event.getInventory());
            }
            if (shouldRemove) {
                this.openGuis.remove(player.getUniqueId());
            }
        }
    }

    public void closeAllGuis() {
        for (Object guiObj : this.openGuis.values()) {
            if (guiObj instanceof RewardGui) {
                RewardGui gui = (RewardGui)guiObj;
                gui.close();
                continue;
            }
            if (!(guiObj instanceof CustomRewardGui)) continue;
            CustomRewardGui customRewardGui = (CustomRewardGui)guiObj;
        }
        this.openGuis.clear();
    }

    private class RewardGui
    implements InventoryHolder {
        private final Player player;
        private final Job job;
        private final List<Reward> rewards;
        private final int page;
        private final Inventory inventory;
        private final GuiConfig.DefaultGuiConfig config;
        private final int rewardsPerPage;
        private final int guiSize;

        public RewardGui(Player player, Job job, List<Reward> rewards, int page, GuiConfig.DefaultGuiConfig config) {
            this.player = player;
            this.job = job;
            this.rewards = rewards;
            this.page = page;
            this.config = config;
            this.rewardsPerPage = config.getRewardsPerPage();
            this.guiSize = config.getSize();
            String title = config.getTitleFormat().replace("{job}", job.getName());
            title = MenuUtils.processPlaceholders(player, title);
            this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)this.guiSize, (String)MessageUtils.colorize(title));
            this.setupGui();
        }

        private void setupGui() {
            this.inventory.clear();
            int startIndex = this.page * this.rewardsPerPage;
            int endIndex = Math.min(startIndex + this.rewardsPerPage, this.rewards.size());
            for (int i = startIndex; i < endIndex; ++i) {
                Reward reward = this.rewards.get(i);
                int slot = reward.getGuiSlot();
                if (slot == -1 || slot >= this.rewardsPerPage || this.inventory.getItem(slot) != null) {
                    slot = i - startIndex;
                }
                if (slot >= this.rewardsPerPage) continue;
                ItemStack rewardItem = this.createRewardItem(reward);
                this.inventory.setItem(slot, rewardItem);
            }
            this.setupNavigationItems();
            this.fillEmptySlots();
        }

        private ItemStack createRewardItem(Reward reward) {
            ItemBuilder builder;
            RewardStatus status = RewardGuiManager.this.rewardManager.getRewardStatus(this.player, reward);
            GuiConfig.RewardItemConfig rewardConfig = this.config.getRewardItemConfig();
            String statusKey = status.name().toLowerCase();
            String materialName = rewardConfig.getMaterial(statusKey);
            String statusIndicator = rewardConfig.getStatusIndicator(statusKey);
            if (!reward.getItems().isEmpty()) {
                Reward.RewardItem firstItem = reward.getItems().get(0);
                builder = ItemBuilder.fromRewardItem(RewardGuiManager.this.plugin, firstItem);
            } else {
                builder = ItemBuilder.fromMaterialName(RewardGuiManager.this.plugin, materialName);
                if (builder == null) {
                    builder = new ItemBuilder(RewardGuiManager.this.plugin, Material.CHEST);
                }
            }
            String displayName = rewardConfig.getNameFormat().replace("{status}", statusIndicator).replace("{name}", reward.getName());
            displayName = MenuUtils.processPlaceholders(this.player, displayName);
            builder.name(displayName);
            ArrayList<String> lore = new ArrayList<String>();
            for (String line : rewardConfig.getLoreFormat()) {
                if (line.contains("{description}")) {
                    String desc = MenuUtils.processPlaceholders(this.player, reward.getDescription());
                    lore.add(desc);
                    continue;
                }
                if (line.contains("{level}")) {
                    String levelLine = line.replace("{level}", String.valueOf(reward.getRequiredLevel()));
                    lore.add(MenuUtils.processPlaceholders(this.player, levelLine));
                    continue;
                }
                if (line.contains("{status_description}")) {
                    String statusLine = line.replace("{status_description}", status.getDescription());
                    lore.add(MenuUtils.processPlaceholders(this.player, statusLine));
                    continue;
                }
                if (line.contains("{repeatable_info}")) {
                    this.handleRepeatableInfo(reward, lore, rewardConfig);
                    continue;
                }
                if (line.contains("{click_instruction}")) {
                    if (status != RewardStatus.RETRIEVABLE) continue;
                    lore.add("");
                    String instruction = MenuUtils.processPlaceholders(this.player, rewardConfig.getClickInstruction());
                    lore.add(instruction);
                    continue;
                }
                if (line.contains("{reward_items}")) {
                    this.addRewardItemsLore(reward, lore);
                    continue;
                }
                if (line.contains("{economy_reward}")) {
                    String economyLine;
                    if (reward.hasEconomyReward()) {
                        economyLine = line.replace("{economy_reward}", String.valueOf(reward.getEconomyReward()));
                        lore.add(MenuUtils.processPlaceholders(this.player, economyLine));
                        continue;
                    }
                    economyLine = line.replace("{economy_reward}", "");
                    if (economyLine.trim().isEmpty()) continue;
                    lore.add(MenuUtils.processPlaceholders(this.player, economyLine));
                    continue;
                }
                if (line.contains("{commands}")) {
                    String commandLine;
                    if (reward.hasCommands()) {
                        commandLine = line.replace("{commands}", rewardConfig.getText("special_rewards"));
                        lore.add(MenuUtils.processPlaceholders(this.player, commandLine));
                        continue;
                    }
                    commandLine = line.replace("{commands}", "");
                    if (commandLine.trim().isEmpty()) continue;
                    lore.add(MenuUtils.processPlaceholders(this.player, commandLine));
                    continue;
                }
                if (line.contains("{cooldown}")) {
                    this.addCooldownLore(reward, status, lore, line, rewardConfig);
                    continue;
                }
                if (!line.isEmpty()) {
                    lore.add(MenuUtils.processPlaceholders(this.player, line));
                    continue;
                }
                lore.add("");
            }
            builder.lore(lore);
            return builder.build();
        }

        private void handleRepeatableInfo(Reward reward, List<String> lore, GuiConfig.RewardItemConfig rewardConfig) {
            if (reward.isRepeatable()) {
                lore.add(MenuUtils.processPlaceholders(this.player, rewardConfig.getText("repeatable_yes")));
            } else {
                lore.add(MenuUtils.processPlaceholders(this.player, rewardConfig.getText("repeatable_no")));
            }
        }

        private void addRewardItemsLore(Reward reward, List<String> lore) {
            if (!reward.getItems().isEmpty()) {
                GuiConfig.RewardItemConfig rewardConfig = this.config.getRewardItemConfig();
                lore.add("");
                lore.add(MenuUtils.processPlaceholders(this.player, rewardConfig.getText("rewards_title")));
                int itemsShown = 0;
                for (Reward.RewardItem rewardItem : reward.getItems()) {
                    if (itemsShown >= 3) {
                        String moreLine = rewardConfig.getText("more_items").replace("{count}", String.valueOf(reward.getItems().size() - 3));
                        lore.add(MenuUtils.processPlaceholders(this.player, moreLine));
                        break;
                    }
                    String itemName = rewardItem.getDisplayName() != null ? rewardItem.getDisplayName() : rewardItem.getMaterial();
                    String itemLine = rewardConfig.getText("item_format").replace("{amount}", String.valueOf(rewardItem.getAmount())).replace("{name}", itemName);
                    lore.add(MenuUtils.processPlaceholders(this.player, itemLine));
                    ++itemsShown;
                }
            }
        }

        private void addCooldownLore(Reward reward, RewardStatus status, List<String> lore, String line, GuiConfig.RewardItemConfig rewardConfig) {
            long lastClaim;
            long nextClaim;
            long timeLeft;
            if (reward.getCooldownHours() > 0L && status == RewardStatus.RETRIEVED && (timeLeft = (nextClaim = (lastClaim = RewardGuiManager.this.rewardManager.getLastClaimTime(this.player, reward)) + reward.getCooldownHours() * 3600000L) - System.currentTimeMillis()) > 0L) {
                String timeString = this.formatTime(timeLeft, rewardConfig.getTimeFormat());
                String cooldownLine = line.replace("{cooldown}", timeString);
                lore.add(MenuUtils.processPlaceholders(this.player, cooldownLine));
            }
        }

        private String formatTime(long timeMs, String format) {
            if (format.equals("{hours}h")) {
                return this.formatTimeSimple(timeMs);
            }
            long hours = timeMs / 3600000L;
            long days = hours / 24L;
            long weeks = days / 7L;
            return format.replace("{hours}", String.valueOf(hours % 24L)).replace("{days}", String.valueOf(days % 7L)).replace("{weeks}", String.valueOf(weeks));
        }

        private String formatTimeSimple(long timeMs) {
            long seconds = timeMs / 1000L;
            long minutes = seconds / 60L;
            long hours = minutes / 60L;
            long days = hours / 24L;
            if (days > 0L) {
                return days + "d " + hours % 24L + "h";
            }
            if (hours > 0L) {
                return hours + "h " + minutes % 60L + "m";
            }
            if (minutes > 0L) {
                return minutes + "m " + seconds % 60L + "s";
            }
            return seconds + "s";
        }

        private void setupNavigationItems() {
            int totalPages = (int)Math.ceil((double)this.rewards.size() / (double)this.rewardsPerPage);
            if (this.page > 0) {
                this.createNavigationItem("previous", totalPages, this.page);
            }
            this.createNavigationItem("info", totalPages, this.page);
            if (this.page < totalPages - 1) {
                this.createNavigationItem("next", totalPages, this.page + 2);
            }
            this.createNavigationItem("close", totalPages, this.page);
            this.createNavigationItem("refresh", totalPages, this.page);
        }

        private void createNavigationItem(String type, int totalPages, int targetPage) {
            int slot = this.config.getNavigationSlot(type);
            if (slot >= 0 && slot < this.inventory.getSize()) {
                String material = this.config.getNavigationMaterial(type);
                String name = this.config.getNavigationName(type);
                List<String> loreLines = this.config.getNavigationLore(type);
                name = name.replace("{current_page}", String.valueOf(this.page + 1)).replace("{total_pages}", String.valueOf(totalPages)).replace("{target_page}", String.valueOf(targetPage)).replace("{job}", this.job.getName());
                name = MenuUtils.processPlaceholders(this.player, name);
                ArrayList<String> processedLore = new ArrayList<String>();
                for (String loreLine : loreLines) {
                    String processed = loreLine.replace("{current_page}", String.valueOf(this.page + 1)).replace("{total_pages}", String.valueOf(totalPages)).replace("{target_page}", String.valueOf(targetPage)).replace("{job}", this.job.getName());
                    processedLore.add(MenuUtils.processPlaceholders(this.player, processed));
                }
                ItemBuilder builder = ItemBuilder.fromMaterialName(RewardGuiManager.this.plugin, material);
                if (builder == null) {
                    builder = new ItemBuilder(RewardGuiManager.this.plugin, Material.STONE);
                }
                ItemStack navItem = builder.name(name).lore(processedLore).build();
                this.inventory.setItem(slot, navItem);
            }
        }

        private void fillEmptySlots() {
            int navAreaStart;
            ItemBuilder fillerBuilder = ItemBuilder.fromMaterialName(RewardGuiManager.this.plugin, this.config.getFillerMaterial());
            if (fillerBuilder == null) {
                fillerBuilder = new ItemBuilder(RewardGuiManager.this.plugin, Material.GRAY_STAINED_GLASS_PANE);
            }
            ItemStack filler = fillerBuilder.name(this.config.getFillerName()).build();
            for (int i = navAreaStart = this.rewardsPerPage; i < this.inventory.getSize(); ++i) {
                if (this.inventory.getItem(i) != null) continue;
                this.inventory.setItem(i, filler);
            }
        }

        public void handleClick(int slot, ItemStack item) {
            if (slot >= this.rewardsPerPage) {
                this.handleNavigationClick(slot);
                return;
            }
            Reward clickedReward = this.getRewardAtSlot(slot);
            if (clickedReward != null) {
                this.handleRewardClick(clickedReward);
            }
        }

        private void handleNavigationClick(int slot) {
            int totalPages;
            if (slot == this.config.getNavigationSlot("previous") && this.page > 0) {
                RewardGui newGui = new RewardGui(this.player, this.job, this.rewards, this.page - 1, this.config);
                RewardGuiManager.this.openGuis.put(this.player.getUniqueId(), newGui);
                newGui.open();
            } else if (slot == this.config.getNavigationSlot("close")) {
                this.player.closeInventory();
            } else if (slot == this.config.getNavigationSlot("refresh")) {
                this.setupGui();
            } else if (slot == this.config.getNavigationSlot("next") && this.page < (totalPages = (int)Math.ceil((double)this.rewards.size() / (double)this.rewardsPerPage)) - 1) {
                RewardGui newGui = new RewardGui(this.player, this.job, this.rewards, this.page + 1, this.config);
                RewardGuiManager.this.openGuis.put(this.player.getUniqueId(), newGui);
                newGui.open();
            }
        }

        private void handleRewardClick(Reward reward) {
            RewardStatus status = RewardGuiManager.this.rewardManager.getRewardStatus(this.player, reward);
            if (status == RewardStatus.RETRIEVABLE) {
                if (RewardGuiManager.this.rewardManager.claimReward(this.player, reward)) {
                    MessageUtils.sendMessage(this.player, RewardGuiManager.this.languageManager.getMessage("rewards.claim.success", "reward", reward.getName()));
                    this.setupGui();
                } else {
                    MessageUtils.sendMessage(this.player, RewardGuiManager.this.languageManager.getMessage("rewards.claim.failed", "reward", reward.getName()));
                }
            } else if (status == RewardStatus.BLOCKED) {
                MessageUtils.sendMessage(this.player, RewardGuiManager.this.languageManager.getMessage("rewards.claim.requirements-not-met"));
            } else if (status == RewardStatus.RETRIEVED) {
                if (reward.isRepeatable() && reward.getCooldownHours() > 0L) {
                    long lastClaim = RewardGuiManager.this.rewardManager.getLastClaimTime(this.player, reward);
                    long nextClaim = lastClaim + reward.getCooldownHours() * 3600000L;
                    long timeLeft = nextClaim - System.currentTimeMillis();
                    if (timeLeft > 0L) {
                        String timeString = this.formatTimeSimple(timeLeft);
                        MessageUtils.sendMessage(this.player, RewardGuiManager.this.languageManager.getMessage("rewards.claim.cooldown", "time", timeString));
                    }
                } else {
                    MessageUtils.sendMessage(this.player, RewardGuiManager.this.languageManager.getMessage("rewards.claim.already-claimed"));
                }
            }
        }

        private Reward getRewardAtSlot(int slot) {
            int startIndex = this.page * this.rewardsPerPage;
            for (int i = 0; i < Math.min(this.rewardsPerPage, this.rewards.size() - startIndex); ++i) {
                Reward reward = this.rewards.get(startIndex + i);
                int rewardSlot = reward.getGuiSlot();
                if (rewardSlot == -1) {
                    rewardSlot = i;
                }
                if (rewardSlot != slot) continue;
                return reward;
            }
            return null;
        }

        public void open() {
            this.player.openInventory(this.inventory);
        }

        public void close() {
            this.player.closeInventory();
        }

        public boolean isInventory(Inventory inv) {
            return this.inventory.equals((Object)inv);
        }

        public Inventory getInventory() {
            return this.inventory;
        }
    }
}

