/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.xp;

import java.util.ArrayList;
import java.util.Stack;
import java.util.StringTokenizer;

public class ExpressionEvaluator {
    public static double evaluate(String expression, String variableName, double variableValue) {
        String expr = expression.replace(variableName, String.valueOf(variableValue));
        expr = ExpressionEvaluator.processMathFunctions(expr);
        return ExpressionEvaluator.evaluatePostfix(ExpressionEvaluator.infixToPostfix(expr));
    }

    private static String processMathFunctions(String expr) {
        double result;
        String arg;
        String args;
        String[] parts;
        int end;
        int start;
        while (((String)expr).contains("Math.pow") && (start = ((String)expr).indexOf("Math.pow(")) != -1 && (end = ExpressionEvaluator.findMatchingParen((String)expr, start + 8)) != -1 && (parts = ExpressionEvaluator.splitArguments(args = ((String)expr).substring(start + 9, end))).length == 2) {
            double base = ExpressionEvaluator.evaluateSimple(parts[0].trim());
            double exponent = ExpressionEvaluator.evaluateSimple(parts[1].trim());
            double result2 = Math.pow(base, exponent);
            expr = ((String)expr).substring(0, start) + result2 + ((String)expr).substring(end + 1);
        }
        while (((String)expr).contains("Math.sqrt") && (start = ((String)expr).indexOf("Math.sqrt(")) != -1 && (end = ExpressionEvaluator.findMatchingParen((String)expr, start + 9)) != -1) {
            arg = ((String)expr).substring(start + 10, end);
            double value = ExpressionEvaluator.evaluateSimple(arg.trim());
            result = Math.sqrt(value);
            expr = ((String)expr).substring(0, start) + result + ((String)expr).substring(end + 1);
        }
        while (((String)expr).contains("Math.floor") && (start = ((String)expr).indexOf("Math.floor(")) != -1 && (end = ExpressionEvaluator.findMatchingParen((String)expr, start + 10)) != -1) {
            arg = ((String)expr).substring(start + 11, end);
            double value = ExpressionEvaluator.evaluateSimple(arg.trim());
            result = Math.floor(value);
            expr = ((String)expr).substring(0, start) + result + ((String)expr).substring(end + 1);
        }
        while (((String)expr).contains("Math.ceil") && (start = ((String)expr).indexOf("Math.ceil(")) != -1 && (end = ExpressionEvaluator.findMatchingParen((String)expr, start + 9)) != -1) {
            arg = ((String)expr).substring(start + 10, end);
            double value = ExpressionEvaluator.evaluateSimple(arg.trim());
            result = Math.ceil(value);
            expr = ((String)expr).substring(0, start) + result + ((String)expr).substring(end + 1);
        }
        expr = ((String)expr).replace("^", " ^ ");
        return expr;
    }

    private static int findMatchingParen(String expr, int start) {
        int count = 1;
        for (int i = start + 1; i < expr.length(); ++i) {
            if (expr.charAt(i) == '(') {
                ++count;
                continue;
            }
            if (expr.charAt(i) != ')' || --count != 0) continue;
            return i;
        }
        return -1;
    }

    private static String[] splitArguments(String args) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        int parenCount = 0;
        for (char c : args.toCharArray()) {
            if (c == ',' && parenCount == 0) {
                result.add(current.toString());
                current = new StringBuilder();
                continue;
            }
            if (c == '(') {
                ++parenCount;
            } else if (c == ')') {
                --parenCount;
            }
            current.append(c);
        }
        if (current.length() > 0) {
            result.add(current.toString());
        }
        return result.toArray(new String[0]);
    }

    private static double evaluateSimple(String expr) {
        try {
            return Double.parseDouble(expr);
        }
        catch (NumberFormatException e) {
            return ExpressionEvaluator.evaluatePostfix(ExpressionEvaluator.infixToPostfix(expr));
        }
    }

    private static String infixToPostfix(String infix) {
        StringBuilder postfix = new StringBuilder();
        Stack<Character> stack = new Stack<Character>();
        StringTokenizer tokenizer = new StringTokenizer(infix, "+-*/^() ", true);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken().trim();
            if (token.isEmpty()) continue;
            if (ExpressionEvaluator.isNumber(token)) {
                postfix.append(token).append(" ");
                continue;
            }
            if (token.equals("(")) {
                stack.push(Character.valueOf('('));
                continue;
            }
            if (token.equals(")")) {
                while (!stack.isEmpty() && ((Character)stack.peek()).charValue() != '(') {
                    postfix.append(stack.pop()).append(" ");
                }
                if (stack.isEmpty()) continue;
                stack.pop();
                continue;
            }
            if (!ExpressionEvaluator.isOperator(token.charAt(0))) continue;
            while (!stack.isEmpty() && ExpressionEvaluator.precedence(((Character)stack.peek()).charValue()) >= ExpressionEvaluator.precedence(token.charAt(0))) {
                postfix.append(stack.pop()).append(" ");
            }
            stack.push(Character.valueOf(token.charAt(0)));
        }
        while (!stack.isEmpty()) {
            postfix.append(stack.pop()).append(" ");
        }
        return postfix.toString();
    }

    private static double evaluatePostfix(String postfix) {
        Stack<Double> stack = new Stack<Double>();
        StringTokenizer tokenizer = new StringTokenizer(postfix);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (ExpressionEvaluator.isNumber(token)) {
                stack.push(Double.parseDouble(token));
                continue;
            }
            if (!ExpressionEvaluator.isOperator(token.charAt(0))) continue;
            if (stack.size() < 2) {
                throw new IllegalArgumentException("Invalid expression");
            }
            double b = (Double)stack.pop();
            double a = (Double)stack.pop();
            switch (token.charAt(0)) {
                case '+': {
                    stack.push(a + b);
                    break;
                }
                case '-': {
                    stack.push(a - b);
                    break;
                }
                case '*': {
                    stack.push(a * b);
                    break;
                }
                case '/': {
                    if (b == 0.0) {
                        throw new ArithmeticException("Division by zero");
                    }
                    stack.push(a / b);
                    break;
                }
                case '^': {
                    stack.push(Math.pow(a, b));
                }
            }
        }
        if (stack.size() != 1) {
            throw new IllegalArgumentException("Invalid expression");
        }
        return (Double)stack.pop();
    }

    private static boolean isNumber(String str) {
        try {
            Double.parseDouble(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static boolean isOperator(char c) {
        return c == '+' || c == '-' || c == '*' || c == '/' || c == '^';
    }

    private static int precedence(char op) {
        return switch (op) {
            case '+', '-' -> 1;
            case '*', '/' -> 2;
            case '^' -> 3;
            default -> 0;
        };
    }
}

