/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.action;

import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.cache.ConfigurationCache;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.Player;

public class ActionLimitManager {
    private final UniverseJobs plugin;
    private final ConfigurationCache configCache;
    private final Map<UUID, Map<String, Map<String, ActionLimitData>>> playerLimits = new ConcurrentHashMap<UUID, Map<String, Map<String, ActionLimitData>>>();
    private final Map<String, Map<String, ActionLimit>> actionLimits = new ConcurrentHashMap<String, Map<String, ActionLimit>>();
    private final Map<String, AutoRestoreConfig> autoRestoreConfigs = new ConcurrentHashMap<String, AutoRestoreConfig>();

    public ActionLimitManager(UniverseJobs plugin, ConfigurationCache configCache) {
        this.plugin = plugin;
        this.configCache = configCache;
        this.startAutoRestoreTask();
    }

    public void setActionLimit(String jobId, String target, ActionLimit limit) {
        this.actionLimits.computeIfAbsent(jobId, k -> new ConcurrentHashMap()).put(target, limit);
    }

    public void setAutoRestoreConfig(String jobId, boolean enabled, String time) {
        if (enabled && time != null) {
            this.autoRestoreConfigs.put(jobId, new AutoRestoreConfig(enabled, time));
        } else {
            this.autoRestoreConfigs.remove(jobId);
        }
    }

    public ActionGains checkAndConsumeLimit(Player player, String jobId, String target, double xpGain, double moneyGain) {
        double finalMoney;
        ActionLimit limit = this.getActionLimit(jobId, target);
        if (limit == null) {
            return new ActionGains(xpGain, moneyGain);
        }
        UUID playerId = player.getUniqueId();
        ActionLimitData data = this.getOrCreateLimitData(playerId, jobId, target, limit);
        long currentTime = System.currentTimeMillis();
        if (currentTime < data.getCooldownEndTime()) {
            return new ActionGains(0.0, 0.0);
        }
        if (data.getCurrentActionsPerformed() >= limit.getMaxActionsPerPeriod()) {
            data.setCooldownEndTime(currentTime + (long)(limit.getCooldownMinutes() * 60) * 1000L);
            return new ActionGains(0.0, 0.0);
        }
        data.consumeAction();
        double finalXp = limit.isBlockExp() ? 0.0 : xpGain;
        double d = finalMoney = limit.isBlockMoney() ? 0.0 : moneyGain;
        if (data.getCurrentActionsPerformed() >= limit.getMaxActionsPerPeriod()) {
            data.setCooldownEndTime(currentTime + (long)(limit.getCooldownMinutes() * 60) * 1000L);
        }
        return new ActionGains(finalXp, finalMoney);
    }

    private ActionLimit getActionLimit(String jobId, String target) {
        Map<String, ActionLimit> jobLimits = this.actionLimits.get(jobId);
        if (jobLimits == null) {
            return null;
        }
        ActionLimit limit = jobLimits.get(target);
        if (limit != null) {
            return limit;
        }
        for (Map.Entry<String, ActionLimit> entry : jobLimits.entrySet()) {
            String pattern = entry.getKey();
            if (!this.matchesPattern(target, pattern)) continue;
            return entry.getValue();
        }
        return null;
    }

    private boolean matchesPattern(String target, String pattern) {
        if (pattern.equals("*")) {
            return true;
        }
        if (pattern.endsWith("*")) {
            String prefix = pattern.substring(0, pattern.length() - 1);
            return target.toUpperCase().startsWith(prefix.toUpperCase());
        }
        if (pattern.startsWith("*")) {
            String suffix = pattern.substring(1);
            return target.toUpperCase().endsWith(suffix.toUpperCase());
        }
        return target.equalsIgnoreCase(pattern);
    }

    private ActionLimitData getOrCreateLimitData(UUID playerId, String jobId, String target, ActionLimit limit) {
        return this.playerLimits.computeIfAbsent(playerId, k -> new ConcurrentHashMap()).computeIfAbsent(jobId, k -> new ConcurrentHashMap()).computeIfAbsent(target, k -> new ActionLimitData(limit));
    }

    public int restorePlayerLimit(Player player, String jobId, String target) {
        UUID playerId = player.getUniqueId();
        Map<String, Map<String, ActionLimitData>> playerJobLimits = this.playerLimits.get(playerId);
        if (playerJobLimits == null) {
            return 0;
        }
        int restored = 0;
        if ("*".equals(jobId)) {
            for (Map<String, ActionLimitData> jobLimits : playerJobLimits.values()) {
                restored += this.restoreJobLimits(jobLimits, target);
            }
        } else {
            Map<String, ActionLimitData> jobLimits = playerJobLimits.get(jobId);
            if (jobLimits != null) {
                restored = this.restoreJobLimits(jobLimits, target);
            }
        }
        return restored;
    }

    private int restoreJobLimits(Map<String, ActionLimitData> jobLimits, String target) {
        int restored = 0;
        if ("*".equals(target)) {
            for (ActionLimitData data : jobLimits.values()) {
                data.reset();
                ++restored;
            }
        } else {
            ActionLimitData data = jobLimits.get(target);
            if (data != null) {
                data.reset();
                restored = 1;
            }
        }
        return restored;
    }

    public ActionLimitStatus getPlayerLimitStatus(Player player, String jobId, String target) {
        ActionLimit limit = this.getActionLimit(jobId, target);
        if (limit == null) {
            return null;
        }
        UUID playerId = player.getUniqueId();
        ActionLimitData data = this.getOrCreateLimitData(playerId, jobId, target, limit);
        return new ActionLimitStatus(limit, data.getCurrentActionsPerformed(), data.getCooldownEndTime(), System.currentTimeMillis());
    }

    private void startAutoRestoreTask() {
        this.plugin.getFoliaManager().runTimerAsync(() -> this.checkScheduledRestore(), 1200L, 1200L);
    }

    public void checkAndResetLimits() {
        this.checkScheduledRestore();
    }

    private void checkScheduledRestore() {
        LocalDateTime now = LocalDateTime.now();
        for (Map.Entry<String, AutoRestoreConfig> entry : this.autoRestoreConfigs.entrySet()) {
            String jobId = entry.getKey();
            AutoRestoreConfig config = entry.getValue();
            if (!config.isEnabled()) continue;
            try {
                LocalDateTime scheduled = this.parseTime(config.getTime());
                if (Math.abs(now.getHour() - scheduled.getHour()) != 0 || Math.abs(now.getMinute() - scheduled.getMinute()) != 0) continue;
                this.executeAutoRestoreForJob(jobId);
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Invalid auto-restore time format for job " + jobId + ": " + config.getTime() + ". Supported formats: HH:mm (24h), h:mm AM/PM");
            }
        }
    }

    private LocalDateTime parseTime(String timeString) {
        DateTimeFormatter[] formatters;
        String normalizedTime = timeString.trim();
        LocalDateTime baseDate = LocalDateTime.now().withSecond(0).withNano(0);
        for (DateTimeFormatter formatter : formatters = new DateTimeFormatter[]{DateTimeFormatter.ofPattern("HH:mm"), DateTimeFormatter.ofPattern("H:mm"), DateTimeFormatter.ofPattern("h:mm a"), DateTimeFormatter.ofPattern("hh:mm a")}) {
            try {
                LocalTime time = LocalTime.parse(normalizedTime, formatter);
                return baseDate.with(time);
            }
            catch (Exception exception) {
            }
        }
        throw new IllegalArgumentException("Unable to parse time: " + timeString);
    }

    private void executeAutoRestoreForJob(String jobId) {
        int totalRestored = 0;
        for (Map<String, Map<String, ActionLimitData>> playerJobLimits : this.playerLimits.values()) {
            Map<String, ActionLimitData> jobLimits = playerJobLimits.get(jobId);
            if (jobLimits == null) continue;
            for (ActionLimitData data : jobLimits.values()) {
                data.reset();
                ++totalRestored;
            }
        }
        if (totalRestored > 0 && this.configCache.isDebugEnabled()) {
            this.plugin.getLogger().info("Auto-restored " + totalRestored + " action limits for job: " + jobId);
        }
    }

    public void clearAllLimits() {
        this.playerLimits.clear();
        this.actionLimits.clear();
        this.autoRestoreConfigs.clear();
    }

    private static class AutoRestoreConfig {
        private final boolean enabled;
        private final String time;

        public AutoRestoreConfig(boolean enabled, String time) {
            this.enabled = enabled;
            this.time = time;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public String getTime() {
            return this.time;
        }
    }

    public static class ActionLimit {
        private final int maxActionsPerPeriod;
        private final int cooldownMinutes;
        private final boolean blockExp;
        private final boolean blockMoney;

        public ActionLimit(int maxActionsPerPeriod, int cooldownMinutes, boolean blockExp, boolean blockMoney) {
            this.maxActionsPerPeriod = maxActionsPerPeriod;
            this.cooldownMinutes = cooldownMinutes;
            this.blockExp = blockExp;
            this.blockMoney = blockMoney;
        }

        public int getMaxActionsPerPeriod() {
            return this.maxActionsPerPeriod;
        }

        public int getCooldownMinutes() {
            return this.cooldownMinutes;
        }

        public boolean isBlockExp() {
            return this.blockExp;
        }

        public boolean isBlockMoney() {
            return this.blockMoney;
        }
    }

    public static class ActionGains {
        private final double xp;
        private final double money;

        public ActionGains(double xp, double money) {
            this.xp = xp;
            this.money = money;
        }

        public double getXp() {
            return this.xp;
        }

        public double getMoney() {
            return this.money;
        }

        public boolean hasGains() {
            return this.xp > 0.0 || this.money > 0.0;
        }
    }

    private static class ActionLimitData {
        private int currentActionsPerformed = 0;
        private long cooldownEndTime = 0L;

        public ActionLimitData(ActionLimit limit) {
        }

        public void consumeAction() {
            ++this.currentActionsPerformed;
        }

        public void reset() {
            this.currentActionsPerformed = 0;
            this.cooldownEndTime = 0L;
        }

        public int getCurrentActionsPerformed() {
            return this.currentActionsPerformed;
        }

        public long getCooldownEndTime() {
            return this.cooldownEndTime;
        }

        public void setCooldownEndTime(long cooldownEndTime) {
            this.cooldownEndTime = cooldownEndTime;
        }
    }

    public static class ActionLimitStatus {
        private final ActionLimit limit;
        private final int currentActionsPerformed;
        private final long cooldownEndTime;
        private final long currentTime;

        public ActionLimitStatus(ActionLimit limit, int currentActionsPerformed, long cooldownEndTime, long currentTime) {
            this.limit = limit;
            this.currentActionsPerformed = currentActionsPerformed;
            this.cooldownEndTime = cooldownEndTime;
            this.currentTime = currentTime;
        }

        public boolean isOnCooldown() {
            return this.currentTime < this.cooldownEndTime;
        }

        public long getRemainingCooldownSeconds() {
            return Math.max(0L, (this.cooldownEndTime - this.currentTime) / 1000L);
        }

        public int getRemainingActions() {
            return Math.max(0, this.limit.getMaxActionsPerPeriod() - this.currentActionsPerformed);
        }

        public ActionLimit getLimit() {
            return this.limit;
        }

        public int getCurrentActionsPerformed() {
            return this.currentActionsPerformed;
        }
    }
}

