/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.command.handler;

import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.storage.database.DatabaseDataStorage;
import fr.ax_dev.universejobs.storage.migration.JobsRebornConverter;
import fr.ax_dev.universejobs.storage.migration.JobsRebornDataMigrator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import org.bukkit.command.CommandSender;

public class JobsRebornMigrationHandler {
    private final UniverseJobs plugin;

    public JobsRebornMigrationHandler(UniverseJobs plugin) {
        this.plugin = plugin;
    }

    public boolean handleMigrationCommand(CommandSender sender, String[] args) {
        String subCommand;
        if (args.length < 2) {
            sender.sendMessage("\u00a7cUsage:");
            sender.sendMessage("\u00a7c/jobs migrate jobs [job-name] - Convert job configurations from JobsReborn");
            sender.sendMessage("\u00a7c/jobs migrate data - Migrate player data from JobsReborn");
            sender.sendMessage("\u00a7c/jobs migrate all - Convert jobs and migrate data");
            return true;
        }
        switch (subCommand = args[1].toLowerCase()) {
            case "jobs": {
                String specificJob = args.length > 2 ? args[2] : null;
                return this.handleJobsMigration(sender, specificJob);
            }
            case "data": {
                return this.handleDataMigration(sender);
            }
            case "all": {
                return this.handleFullMigration(sender);
            }
        }
        sender.sendMessage("\u00a7cUnknown migration command: " + subCommand);
        sender.sendMessage("\u00a7cAvailable commands: jobs, data, all");
        return true;
    }

    private boolean handleJobsMigration(CommandSender sender, String specificJob) {
        if (specificJob != null) {
            sender.sendMessage("\u00a7aStarting JobsReborn job conversion for: " + specificJob);
        } else {
            sender.sendMessage("\u00a7aStarting JobsReborn jobs conversion...");
        }
        this.plugin.getFoliaManager().runAsync(() -> {
            try {
                JobsRebornConverter converter = new JobsRebornConverter(this.plugin);
                JobsRebornConverter.ConversionResult result = converter.convertJobs(specificJob);
                this.plugin.getFoliaManager().runNextTick(() -> {
                    if (result.isSuccessful()) {
                        if (specificJob != null) {
                            sender.sendMessage("\u00a7aJob conversion completed successfully!");
                        } else {
                            sender.sendMessage("\u00a7aJobs conversion completed successfully!");
                        }
                        sender.sendMessage("\u00a7aConverted jobs: " + result.jobsConverted);
                        if (!result.convertedJobs.isEmpty()) {
                            sender.sendMessage("\u00a7aConverted jobs: \u00a7f" + String.join((CharSequence)"\u00a7a, \u00a7f", result.convertedJobs));
                        }
                        if (!result.failedJobs.isEmpty()) {
                            sender.sendMessage("\u00a7cFailed to convert some jobs:");
                            for (String failed : result.failedJobs) {
                                sender.sendMessage("\u00a7c- " + failed);
                            }
                        }
                        sender.sendMessage("\u00a7e/jobs admin reload to load the new job configurations.");
                    } else {
                        sender.sendMessage("\u00a7cJobs conversion failed: " + result.error);
                    }
                });
            }
            catch (Exception e) {
                this.plugin.getFoliaManager().runNextTick(() -> sender.sendMessage("\u00a7cJobs conversion failed: " + e.getMessage()));
                this.plugin.getLogger().log(Level.SEVERE, "Jobs conversion failed", e);
            }
        });
        return true;
    }

    private boolean handleDataMigration(CommandSender sender) {
        if (!this.plugin.isDatabaseEnabled()) {
            sender.sendMessage("\u00a7cDatabase is not enabled. Data migration requires database storage.");
            return true;
        }
        DatabaseDataStorage storage = (DatabaseDataStorage)this.plugin.getDataStorage();
        JobsRebornDataMigrator migrator = new JobsRebornDataMigrator(this.plugin, storage);
        if (!migrator.shouldMigrate()) {
            sender.sendMessage("\u00a7cNo JobsReborn data found or migration already completed.");
            return true;
        }
        sender.sendMessage("\u00a7aStarting JobsReborn player data migration...");
        this.plugin.getFoliaManager().runAsync(() -> {
            try {
                JobsRebornDataMigrator.MigrationResult result = migrator.migrateAllData().join();
                this.plugin.getFoliaManager().runNextTick(() -> {
                    if (result.isSuccessful()) {
                        sender.sendMessage("\u00a7aData migration completed successfully!");
                        sender.sendMessage("\u00a7aPlayer data migrated: " + result.playerDataMigrated);
                        migrator.markMigrationComplete();
                    } else {
                        sender.sendMessage("\u00a7cData migration failed: " + result.error);
                    }
                });
            }
            catch (Exception e) {
                this.plugin.getFoliaManager().runNextTick(() -> sender.sendMessage("\u00a7cData migration failed: " + e.getMessage()));
                this.plugin.getLogger().log(Level.SEVERE, "Data migration failed", e);
            }
        });
        return true;
    }

    private boolean handleFullMigration(CommandSender sender) {
        sender.sendMessage("\u00a7aStarting full JobsReborn migration (jobs + data)...");
        this.plugin.getFoliaManager().runAsync(() -> {
            try {
                DatabaseDataStorage storage;
                JobsRebornDataMigrator migrator;
                JobsRebornConverter converter = new JobsRebornConverter(this.plugin);
                JobsRebornConverter.ConversionResult jobsResult = converter.convertJobs(null);
                CompletableFuture<Object> dataFuture = this.plugin.isDatabaseEnabled() ? ((migrator = new JobsRebornDataMigrator(this.plugin, storage = (DatabaseDataStorage)this.plugin.getDataStorage())).shouldMigrate() ? migrator.migrateAllData() : CompletableFuture.completedFuture(null)) : CompletableFuture.completedFuture(null);
                JobsRebornDataMigrator.MigrationResult dataResult = dataFuture.join();
                this.plugin.getFoliaManager().runNextTick(() -> {
                    sender.sendMessage("\u00a7a=== JobsReborn Migration Results ===");
                    if (jobsResult.isSuccessful()) {
                        sender.sendMessage("\u00a7aJobs conversion: \u00a72SUCCESS");
                        sender.sendMessage("\u00a7aConverted jobs: " + jobsResult.jobsConverted);
                        if (!jobsResult.convertedJobs.isEmpty()) {
                            sender.sendMessage("\u00a7aJob IDs: \u00a7f" + String.join((CharSequence)"\u00a7a, \u00a7f", jobsResult.convertedJobs));
                        }
                    } else {
                        sender.sendMessage("\u00a7cJobs conversion: \u00a74FAILED");
                        sender.sendMessage("\u00a7cError: " + jobsResult.error);
                    }
                    if (dataResult != null) {
                        if (dataResult.isSuccessful()) {
                            sender.sendMessage("\u00a7aData migration: \u00a72SUCCESS");
                            sender.sendMessage("\u00a7aPlayer data migrated: " + dataResult.playerDataMigrated);
                            DatabaseDataStorage storage = (DatabaseDataStorage)this.plugin.getDataStorage();
                            JobsRebornDataMigrator migrator = new JobsRebornDataMigrator(this.plugin, storage);
                            migrator.markMigrationComplete();
                        } else {
                            sender.sendMessage("\u00a7cData migration: \u00a74FAILED");
                            sender.sendMessage("\u00a7cError: " + dataResult.error);
                        }
                    } else {
                        sender.sendMessage("\u00a7eData migration: \u00a76SKIPPED");
                        sender.sendMessage("\u00a7e(Database not enabled or no data found)");
                    }
                    if (!jobsResult.failedJobs.isEmpty()) {
                        sender.sendMessage("\u00a7cSome jobs failed to convert:");
                        for (String failed : jobsResult.failedJobs) {
                            sender.sendMessage("\u00a7c- " + failed);
                        }
                    }
                    sender.sendMessage("\u00a7eRestart the server to load the new configurations.");
                });
            }
            catch (Exception e) {
                this.plugin.getFoliaManager().runNextTick(() -> sender.sendMessage("\u00a7cFull migration failed: " + e.getMessage()));
                this.plugin.getLogger().log(Level.SEVERE, "Full migration failed", e);
            }
        });
        return true;
    }

    public List<String> getTabComplete(String[] args) {
        if (args.length == 2) {
            return Arrays.asList("jobs", "data", "all");
        }
        return Collections.emptyList();
    }
}

