/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.listener;

import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.action.ActionProcessor;
import fr.ax_dev.universejobs.action.ActionType;
import fr.ax_dev.universejobs.condition.ConditionContext;
import fr.ax_dev.universejobs.protection.BlockProtectionManager;
import net.momirealms.craftengine.bukkit.api.CraftEngineBlocks;
import net.momirealms.craftengine.core.block.ImmutableBlockState;
import net.momirealms.craftengine.libraries.nbt.CompoundTag;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class CraftEngineEventListener
implements Listener {
    private static final String TARGET_PREFIX = "target";
    private static final String CRAFTENGINE_PREFIX = "craftengine:";
    private static final String CRAFTENGINE_BLOCK_ID = "craftengine_block_id";
    private final UniverseJobs plugin;
    private final ActionProcessor actionProcessor;
    private final BlockProtectionManager protectionManager;

    public CraftEngineEventListener(UniverseJobs plugin, ActionProcessor actionProcessor, BlockProtectionManager protectionManager) {
        this.plugin = plugin;
        this.actionProcessor = actionProcessor;
        this.protectionManager = protectionManager;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockPlace(BlockPlaceEvent event) {
        Player player = event.getPlayer();
        Block block = event.getBlock();
        if (!this.isCraftEngineBlock(block)) {
            return;
        }
        String craftEngineBlockId = this.getCraftEngineBlockId(block);
        if (craftEngineBlockId == null) {
            return;
        }
        this.protectionManager.recordBlockPlacement(player, block);
        ConditionContext context = new ConditionContext().setBlock(block).set(TARGET_PREFIX, CRAFTENGINE_PREFIX + craftEngineBlockId).set(CRAFTENGINE_BLOCK_ID, craftEngineBlockId);
        this.actionProcessor.processAction(player, ActionType.PLACE, (Event)event, context);
        if (this.plugin.getConfigManager().isDebugEnabled()) {
            this.plugin.getLogger().info("CraftEngine block placed: " + craftEngineBlockId + " by " + player.getName() + " at " + String.valueOf(block.getLocation()));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        Block block = event.getBlock();
        if (!this.isCraftEngineBlock(block)) {
            return;
        }
        String craftEngineBlockId = this.getCraftEngineBlockId(block);
        if (craftEngineBlockId == null) {
            return;
        }
        if (this.protectionManager.isPlayerPlacedBlock(block)) {
            this.protectionManager.removeTrackedBlock(block);
            if (this.plugin.getConfigManager().isDebugEnabled()) {
                this.plugin.getLogger().info("Player " + player.getName() + " mined a player-placed CraftEngine block (" + craftEngineBlockId + ") - no XP awarded");
            }
            return;
        }
        ConditionContext context = new ConditionContext().setBlock(block).set(TARGET_PREFIX, CRAFTENGINE_PREFIX + craftEngineBlockId).set(CRAFTENGINE_BLOCK_ID, craftEngineBlockId);
        this.actionProcessor.processAction(player, ActionType.BREAK, (Event)event, context);
        if (this.plugin.getConfigManager().isDebugEnabled()) {
            this.plugin.getLogger().info("CraftEngine block broken: " + craftEngineBlockId + " by " + player.getName() + " at " + String.valueOf(block.getLocation()));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        Block block = event.getClickedBlock();
        if (block == null || !this.isCraftEngineBlock(block)) {
            return;
        }
        String craftEngineBlockId = this.getCraftEngineBlockId(block);
        if (craftEngineBlockId == null) {
            return;
        }
        boolean isRightClick = event.getAction().name().contains("RIGHT_CLICK");
        String interactType = player.isSneaking() ? (isRightClick ? "RIGHT_SHIFT_CLICK" : "LEFT_SHIFT_CLICK") : (isRightClick ? "RIGHT_CLICK" : "LEFT_CLICK");
        ConditionContext context = new ConditionContext().setBlock(block).set(TARGET_PREFIX, CRAFTENGINE_PREFIX + craftEngineBlockId).set(CRAFTENGINE_BLOCK_ID, craftEngineBlockId).set("interact-type", interactType);
        this.actionProcessor.processAction(player, ActionType.BLOCK_INTERACT, (Event)event, context);
        if (this.plugin.getConfigManager().isDebugEnabled()) {
            this.plugin.getLogger().info("CraftEngine block interact: " + craftEngineBlockId + " by " + player.getName() + " - interact-type: " + interactType);
        }
    }

    private boolean isCraftEngineBlock(Block block) {
        try {
            return CraftEngineBlocks.isCustomBlock((Block)block);
        }
        catch (Exception e) {
            if (this.plugin.getConfigManager().isDebugEnabled()) {
                this.plugin.getLogger().warning("Error checking if block is CraftEngine block: " + e.getMessage());
            }
            return false;
        }
    }

    private String getCraftEngineBlockId(Block block) {
        try {
            CompoundTag nbtData;
            ImmutableBlockState blockState = CraftEngineBlocks.getCustomBlockState((Block)block);
            if (blockState != null && (nbtData = blockState.getNbtToSave()) != null && nbtData.containsKey("id")) {
                return nbtData.getString("id");
            }
            return null;
        }
        catch (Exception e) {
            if (this.plugin.getConfigManager().isDebugEnabled()) {
                this.plugin.getLogger().warning("Error getting CraftEngine block ID: " + e.getMessage());
            }
            return null;
        }
    }
}

