/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.listener;

import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.action.ActionProcessor;
import fr.ax_dev.universejobs.action.ActionType;
import fr.ax_dev.universejobs.condition.ConditionContext;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.momirealms.customfishing.api.event.FishingResultEvent;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;

public class CustomFishingEventListener
implements Listener {
    private final UniverseJobs plugin;
    private final ActionProcessor actionProcessor;
    private final Map<UUID, Long> lastFishingTime = new HashMap<UUID, Long>();
    private static final long FISHING_COOLDOWN_MS = 100L;

    public CustomFishingEventListener(UniverseJobs plugin, ActionProcessor actionProcessor) {
        this.plugin = plugin;
        this.actionProcessor = actionProcessor;
        plugin.getLogger().info("CustomFishingEventListener initialized successfully");
        if (plugin.getConfigManager().isDebugEnabled()) {
            plugin.getLogger().info("CustomFishing integration enabled with debug mode");
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onFishingResult(FishingResultEvent event) {
        Player player = event.getPlayer();
        if (this.plugin.getConfigManager().isDebugEnabled()) {
            this.plugin.getLogger().info("CustomFishing trigger onFishingResult");
        }
        if (event.getResult() != FishingResultEvent.Result.SUCCESS) {
            return;
        }
        UUID playerUUID = player.getUniqueId();
        long currentTime = System.currentTimeMillis();
        Long lastTime = this.lastFishingTime.get(playerUUID);
        if (lastTime != null && currentTime - lastTime < 100L) {
            if (this.plugin.getConfigManager().isDebugEnabled()) {
                this.plugin.getLogger().info("CustomFishing result blocked (double-action protection): " + player.getName() + " cooldown remaining: " + (100L - (currentTime - lastTime)) + "ms");
            }
            return;
        }
        this.lastFishingTime.put(playerUUID, currentTime);
        if (event.getLoot() == null) {
            return;
        }
        String fishId = event.getLoot().id();
        if (fishId == null || fishId.isEmpty()) {
            if (this.plugin.getConfigManager().isDebugEnabled()) {
                this.plugin.getLogger().info("CustomFishing: Unable to determine fish ID from loot");
            }
            return;
        }
        ConditionContext context = new ConditionContext().set("target", "customfishing:" + fishId).set("customfishing_fish_id", fishId).set("loot", event.getLoot());
        if (this.plugin.getConfigManager().isDebugEnabled()) {
            this.plugin.getLogger().info("CustomFishing caught: customfishing:" + fishId + " by " + player.getName());
            this.plugin.getLogger().info("Processing FISH action with target: customfishing:" + fishId + " by " + player.getName());
        }
        this.actionProcessor.processAction(player, ActionType.FISH, (Event)event, context);
        if (this.plugin.getConfigManager().isDebugEnabled()) {
            this.plugin.getLogger().info("CustomFishing result processed: " + fishId + " by " + player.getName() + " at " + String.valueOf(player.getLocation()));
        }
    }

    public void cleanupOldFishingTimes() {
        long currentTime = System.currentTimeMillis();
        long cleanupThreshold = 600000L;
        this.lastFishingTime.entrySet().removeIf(entry -> currentTime - (Long)entry.getValue() > cleanupThreshold);
    }
}

