/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.listener;

import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.action.ActionProcessor;
import fr.ax_dev.universejobs.action.ActionType;
import fr.ax_dev.universejobs.condition.ConditionContext;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Chunk;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;

public class ExploreEventListener
implements Listener {
    private final UniverseJobs plugin;
    private final ActionProcessor actionProcessor;
    private final Map<Long, Integer> chunkExplorationCount = new ConcurrentHashMap<Long, Integer>();
    private final Map<UUID, Long> lastChunkMove = new HashMap<UUID, Long>();
    private static final int MAX_EXPLORATIONS = 5;
    private static final long CHUNK_COOLDOWN_MS = 1000L;

    public ExploreEventListener(UniverseJobs plugin, ActionProcessor actionProcessor) {
        this.plugin = plugin;
        this.actionProcessor = actionProcessor;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerMove(PlayerMoveEvent event) {
        if (event.getFrom().getChunk().equals((Object)event.getTo().getChunk())) {
            return;
        }
        Player player = event.getPlayer();
        Chunk chunk = event.getTo().getChunk();
        long chunkKey = this.getChunkKey(chunk);
        long currentTime = System.currentTimeMillis();
        Long lastMove = this.lastChunkMove.get(player.getUniqueId());
        if (lastMove != null && currentTime - lastMove < 1000L) {
            return;
        }
        this.lastChunkMove.put(player.getUniqueId(), currentTime);
        int explorationCount = this.chunkExplorationCount.getOrDefault(chunkKey, 0);
        if (explorationCount >= 5) {
            return;
        }
        this.chunkExplorationCount.put(chunkKey, ++explorationCount);
        if (this.plugin.getConfigManager().isDebugEnabled()) {
            this.plugin.getLogger().info("ExploreEvent: " + player.getName() + " exploring chunk " + chunk.getX() + "," + chunk.getZ() + " (count: " + explorationCount + ")");
        }
        ConditionContext context = new ConditionContext().set("target", String.valueOf(explorationCount)).set("exploration_count", String.valueOf(explorationCount)).set("chunk_x", String.valueOf(chunk.getX())).set("chunk_z", String.valueOf(chunk.getZ())).set("world", chunk.getWorld().getName());
        this.actionProcessor.processAction(player, ActionType.EXPLORE, (Event)event, context);
    }

    private long getChunkKey(Chunk chunk) {
        return (long)chunk.getX() << 32 | (long)chunk.getZ() & 0xFFFFFFFFL;
    }

    public void clearExplorationData() {
        this.chunkExplorationCount.clear();
        if (this.plugin.getConfigManager().isDebugEnabled()) {
            this.plugin.getLogger().info("Cleared exploration data (server restart/reload)");
        }
    }
}

