/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.menu;

import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.menu.config.MenuItemConfig;
import fr.ax_dev.universejobs.reward.gui.ItemBuilder;
import fr.ax_dev.universejobs.utils.MessageUtils;
import fr.ax_dev.universejobs.utils.PlayerTextureCache;
import java.net.URL;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import me.clip.placeholderapi.PlaceholderAPI;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.profile.PlayerProfile;

public class MenuUtils {
    private static final Map<String, String> PLACEHOLDER_CACHE = new ConcurrentHashMap<String, String>();
    private static final Map<String, List<Component>> LORE_CACHE = new ConcurrentHashMap<String, List<Component>>();
    private static final int MAX_CACHE_SIZE = 1000;

    public static String processPlaceholders(Player player, String text) {
        if (text == null) {
            return "";
        }
        try {
            if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
                text = PlaceholderAPI.setPlaceholders((Player)player, (String)text);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return text;
    }

    public static String replacePlaceholders(String text, Map<String, String> placeholders) {
        if (text == null || placeholders == null) {
            return text;
        }
        String result = text;
        for (Map.Entry<String, String> entry : placeholders.entrySet()) {
            String key = entry.getKey();
            if (key.startsWith("{") && key.endsWith("}")) {
                result = result.replace(key, entry.getValue());
                continue;
            }
            result = result.replace("{" + key + "}", entry.getValue());
        }
        return result;
    }

    private static List<String> processLoreLineWithMultiLine(String loreLine, Map<String, String> customPlaceholders, Player player) {
        ArrayList<String> result = new ArrayList<String>();
        if (loreLine.contains("{job_description}") && customPlaceholders != null && customPlaceholders.containsKey("job_description_lines")) {
            String[] descriptionLines = customPlaceholders.get("job_description_lines").split("\n");
            String baseFormat = loreLine.replace("{job_description}", "");
            for (String descLine : descriptionLines) {
                if (descLine.trim().isEmpty()) {
                    result.add("");
                    continue;
                }
                Object processedLine = baseFormat + descLine;
                if (customPlaceholders != null) {
                    processedLine = MenuUtils.replacePlaceholders((String)processedLine, customPlaceholders);
                }
                processedLine = MenuUtils.processPlaceholders(player, (String)processedLine);
                result.add((String)processedLine);
            }
        } else {
            String processedLore = loreLine;
            if (customPlaceholders != null) {
                processedLore = MenuUtils.replacePlaceholders(processedLore, customPlaceholders);
            }
            processedLore = MenuUtils.processPlaceholders(player, processedLore);
            result.add(processedLore);
        }
        return result;
    }

    public static ItemStack createMenuItem(UniverseJobs plugin, Player player, MenuItemConfig itemConfig) {
        return MenuUtils.createMenuItem(plugin, player, itemConfig, null);
    }

    public static ItemStack createMenuItemAsync(UniverseJobs plugin, Player player, MenuItemConfig itemConfig, Map<String, String> customPlaceholders) {
        ItemBuilder builder = ItemBuilder.fromMaterialName(plugin, itemConfig.getMaterial());
        if (builder == null) {
            builder = new ItemBuilder(plugin, Material.STONE);
        }
        builder.amount(itemConfig.getAmount());
        String displayName = itemConfig.getDisplayName();
        if (customPlaceholders != null) {
            displayName = MenuUtils.replacePlaceholders(displayName, customPlaceholders);
        }
        builder.name(displayName);
        ArrayList<String> lore = new ArrayList<String>();
        for (String loreLine : itemConfig.getLore()) {
            if (loreLine.contains("{job_description}") && customPlaceholders != null && customPlaceholders.containsKey("job_description_lines")) {
                String[] descriptionLines = customPlaceholders.get("job_description_lines").split("\n");
                String baseFormat = loreLine.replace("{job_description}", "");
                for (String descLine : descriptionLines) {
                    if (descLine.trim().isEmpty()) {
                        lore.add("");
                        continue;
                    }
                    Object processedLine = baseFormat + descLine;
                    if (customPlaceholders != null) {
                        processedLine = MenuUtils.replacePlaceholders((String)processedLine, customPlaceholders);
                    }
                    lore.add((String)processedLine);
                }
                continue;
            }
            String processedLore = loreLine;
            if (customPlaceholders != null) {
                processedLore = MenuUtils.replacePlaceholders(processedLore, customPlaceholders);
            }
            lore.add(processedLore);
        }
        builder.lore(lore);
        if (itemConfig.getCustomModelData() > 0) {
            builder.customModelData(itemConfig.getCustomModelData());
        }
        if (itemConfig.isHideAttributes() || itemConfig.isHideEnchants()) {
            builder.hideAttributes();
        }
        return builder.build();
    }

    public static ItemStack createMenuItem(UniverseJobs plugin, Player player, MenuItemConfig itemConfig, Map<String, String> customPlaceholders) {
        if (itemConfig == null || !itemConfig.isEnabled()) {
            return null;
        }
        String cacheKey = MenuUtils.generateItemCacheKey(player.getUniqueId(), itemConfig, customPlaceholders);
        return plugin.getAccessor().getMenuManager().getComponentCache().getItem(cacheKey, () -> MenuUtils.createMenuItemUncached(plugin, player, itemConfig, customPlaceholders));
    }

    private static ItemStack createMenuItemUncached(UniverseJobs plugin, Player player, MenuItemConfig itemConfig, Map<String, String> customPlaceholders) {
        List<String> originalLore;
        ItemBuilder builder = ItemBuilder.fromMaterialName(plugin, itemConfig.getMaterial());
        if (builder == null) {
            return null;
        }
        builder.amount(itemConfig.getAmount());
        String displayName = itemConfig.getDisplayName();
        if (displayName != null && !displayName.isEmpty()) {
            if (customPlaceholders != null) {
                displayName = MenuUtils.replacePlaceholders(displayName, customPlaceholders);
            }
            displayName = MenuUtils.processPlaceholders(player, displayName);
            builder.name(displayName);
        }
        if ((originalLore = itemConfig.getLore()) != null && !originalLore.isEmpty()) {
            ArrayList<String> processedLore = new ArrayList<String>();
            for (String loreLine : originalLore) {
                processedLore.addAll(MenuUtils.processLoreLineWithMultiLine(loreLine, customPlaceholders, player));
            }
            builder.lore(processedLore);
        }
        if (itemConfig.getCustomModelData() > 0) {
            builder.customModelData(itemConfig.getCustomModelData());
        }
        if (itemConfig.isHideAttributes() || itemConfig.isHideEnchants()) {
            builder.hideAttributes();
        }
        ItemStack item = builder.build();
        MenuUtils.applyItemMetaOptimized(item, itemConfig, customPlaceholders, player, plugin);
        return item;
    }

    private static String generateItemCacheKey(UUID playerId, MenuItemConfig itemConfig, Map<String, String> customPlaceholders) {
        StringBuilder key = new StringBuilder(128);
        key.append(playerId.toString()).append(':').append(itemConfig.getMaterial()).append(':').append(itemConfig.getDisplayName() != null ? itemConfig.getDisplayName().hashCode() : 0).append(':').append(itemConfig.getLore() != null ? itemConfig.getLore().hashCode() : 0);
        if (customPlaceholders != null && !customPlaceholders.isEmpty()) {
            String jobId = customPlaceholders.get("{job_id}");
            if (jobId != null) {
                key.append(':').append(jobId);
            }
            key.append(':').append(customPlaceholders.hashCode());
        }
        return key.toString();
    }

    private static String processPlaceholdersOptimized(String text, Map<String, String> customPlaceholders, Player player) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        String cacheKey = text + ":" + (customPlaceholders != null ? customPlaceholders.hashCode() : 0) + ":" + String.valueOf(player.getUniqueId());
        String cached = PLACEHOLDER_CACHE.get(cacheKey);
        if (cached != null) {
            return cached;
        }
        String result = text;
        if (customPlaceholders != null && !customPlaceholders.isEmpty()) {
            for (Map.Entry<String, String> entry : customPlaceholders.entrySet()) {
                String key = entry.getKey();
                if (!result.contains(key)) continue;
                result = result.replace(key, entry.getValue());
            }
        }
        if (result.contains("%")) {
            result = MenuUtils.processPlaceholders(player, result);
        }
        if (PLACEHOLDER_CACHE.size() < 1000) {
            PLACEHOLDER_CACHE.put(cacheKey, result);
        }
        return result;
    }

    private static List<String> processLoreOptimized(List<String> lore, Map<String, String> customPlaceholders, Player player) {
        if (lore == null || lore.isEmpty()) {
            return new ArrayList<String>();
        }
        ArrayList<String> processedLore = new ArrayList<String>(lore.size() * 2);
        for (String loreLine : lore) {
            if (loreLine.contains("{job_description}") && customPlaceholders != null && customPlaceholders.containsKey("job_description_lines")) {
                MenuUtils.processMultiLineDescription(loreLine, customPlaceholders, player, processedLore);
                continue;
            }
            String processed = MenuUtils.processPlaceholdersOptimized(loreLine, customPlaceholders, player);
            processedLore.add(processed);
        }
        return processedLore;
    }

    private static void processMultiLineDescription(String loreLine, Map<String, String> customPlaceholders, Player player, List<String> output) {
        String[] descriptionLines = customPlaceholders.get("job_description_lines").split("\n");
        String baseFormat = loreLine.replace("{job_description}", "");
        for (String descLine : descriptionLines) {
            if (descLine.trim().isEmpty()) {
                output.add("");
                continue;
            }
            Object processedLine = baseFormat + descLine;
            if (customPlaceholders != null) {
                processedLine = MenuUtils.replacePlaceholders((String)processedLine, customPlaceholders);
            }
            processedLine = MenuUtils.processPlaceholders(player, (String)processedLine);
            output.add((String)processedLine);
        }
    }

    private static void applyItemMetaOptimized(ItemStack item, MenuItemConfig itemConfig, Map<String, String> customPlaceholders, Player player, UniverseJobs plugin) {
        Map<String, Integer> enchantments;
        boolean metaModified;
        ItemMeta meta;
        block28: {
            meta = item.getItemMeta();
            if (meta == null) {
                return;
            }
            metaModified = false;
            if (item.getType() == Material.PLAYER_HEAD && meta instanceof SkullMeta) {
                SkullMeta skullMeta = (SkullMeta)meta;
                if (!itemConfig.getPlayerHead().isEmpty()) {
                    String playerHead = itemConfig.getPlayerHead();
                    if (customPlaceholders != null) {
                        playerHead = MenuUtils.replacePlaceholders(playerHead, customPlaceholders);
                    }
                    playerHead = MenuUtils.processPlaceholders(player, playerHead);
                    String playerUuidStr = customPlaceholders != null ? customPlaceholders.get("{player_uuid}") : null;
                    try {
                        if (playerHead.length() > 20 && MenuUtils.isValidBase64(playerHead)) {
                            MenuUtils.setSkullTexture(skullMeta, playerHead);
                            metaModified = true;
                            break block28;
                        }
                        UUID targetUuid = null;
                        if (playerUuidStr != null && !playerUuidStr.isEmpty()) {
                            try {
                                targetUuid = UUID.fromString(playerUuidStr);
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                // empty catch block
                            }
                        }
                        if (targetUuid != null) {
                            PlayerProfile cachedProfile = PlayerTextureCache.getPlayerProfile(targetUuid, playerHead).getNow(null);
                            if (cachedProfile != null && cachedProfile.getTextures().getSkin() != null) {
                                skullMeta.setOwnerProfile(cachedProfile);
                                metaModified = true;
                            } else {
                                OfflinePlayer offlinePlayer = plugin.getServer().getOfflinePlayer(targetUuid);
                                skullMeta.setOwningPlayer(offlinePlayer);
                                metaModified = true;
                            }
                            break block28;
                        }
                        OfflinePlayer offlinePlayer = plugin.getServer().getOfflinePlayer(playerHead);
                        if (offlinePlayer.hasPlayedBefore() || offlinePlayer.isOnline()) {
                            skullMeta.setOwningPlayer(offlinePlayer);
                            metaModified = true;
                            break block28;
                        }
                        try {
                            UUID playerId = offlinePlayer.getUniqueId();
                            PlayerProfile profile = PlayerTextureCache.getPlayerProfile(playerId, playerHead).get(3L, TimeUnit.SECONDS);
                            skullMeta.setOwnerProfile(profile);
                            metaModified = true;
                        }
                        catch (Exception profileEx) {
                            skullMeta.setOwningPlayer(offlinePlayer);
                            metaModified = true;
                        }
                    }
                    catch (Exception targetUuid) {}
                } else if (!itemConfig.getSkullOwner().isEmpty()) {
                    String skullOwner = itemConfig.getSkullOwner();
                    if (customPlaceholders != null) {
                        skullOwner = MenuUtils.replacePlaceholders(skullOwner, customPlaceholders);
                    }
                    skullOwner = MenuUtils.processPlaceholders(player, skullOwner);
                    try {
                        skullMeta.setOwningPlayer(plugin.getServer().getOfflinePlayer(skullOwner));
                        metaModified = true;
                    }
                    catch (Exception playerUuidStr) {
                        // empty catch block
                    }
                }
            }
        }
        if ((enchantments = itemConfig.getEnchantments()) != null && !enchantments.isEmpty()) {
            for (Map.Entry<String, Integer> entry : enchantments.entrySet()) {
                try {
                    Enchantment enchantment = Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)entry.getKey().toLowerCase()));
                    if (enchantment == null) continue;
                    meta.addEnchant(enchantment, entry.getValue().intValue(), true);
                    metaModified = true;
                }
                catch (Exception exception) {}
            }
        }
        if (itemConfig.isGlow() && (enchantments == null || enchantments.isEmpty())) {
            meta.addEnchant(Enchantment.LURE, 1, true);
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            metaModified = true;
        }
        if (itemConfig.isHideToolTip()) {
            meta.setHideTooltip(true);
            metaModified = true;
        }
        if (metaModified) {
            item.setItemMeta(meta);
        }
    }

    public static void clearCaches() {
        PLACEHOLDER_CACHE.clear();
        LORE_CACHE.clear();
    }

    public static List<Component> processLoreLineWithMultiLine(String loreLine) {
        ArrayList<Component> result = new ArrayList<Component>();
        result.add(MenuUtils.parseMessage(loreLine));
        return result;
    }

    private static Component parseMessage(String message) {
        return MessageUtils.parseMessage(message);
    }

    private static boolean isValidBase64(String str) {
        try {
            Base64.getDecoder().decode(str);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private static void setSkullTexture(SkullMeta skullMeta, String textureValue) {
        try {
            String decodedTexture = new String(Base64.getDecoder().decode(textureValue));
            if (decodedTexture.contains("\"url\":\"")) {
                String textureUrl = decodedTexture.split("\"url\":\"")[1].split("\"")[0];
                UUID textureUuid = UUID.nameUUIDFromBytes(textureUrl.getBytes());
                PlayerProfile profile = Bukkit.createPlayerProfile((UUID)textureUuid);
                profile.getTextures().setSkin(new URL(textureUrl));
                skullMeta.setOwnerProfile(profile);
            }
        }
        catch (Exception e) {
            try {
                PlayerProfile profile = Bukkit.createPlayerProfile((UUID)UUID.nameUUIDFromBytes(textureValue.getBytes()));
                String textureUrl = "http://textures.minecraft.net/texture/" + textureValue;
                profile.getTextures().setSkin(new URL(textureUrl));
                skullMeta.setOwnerProfile(profile);
            }
            catch (Exception ex) {
                throw new RuntimeException("Failed to set skull texture", ex);
            }
        }
    }
}

