/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.menu;

import fr.ax_dev.universejobs.menu.BaseMenu;
import java.util.UUID;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;

public class OptimizedMenuHolder
implements InventoryHolder {
    private final UUID playerId;
    private final String menuType;
    private final String menuId;
    private final BaseMenu menu;
    private final long createdAt;
    private Inventory inventory;
    private final int holderHash;

    public OptimizedMenuHolder(UUID playerId, String menuType, String menuId, BaseMenu menu) {
        this.playerId = playerId;
        this.menuType = menuType;
        this.menuId = menuId;
        this.menu = menu;
        this.createdAt = System.currentTimeMillis();
        this.holderHash = this.computeHash();
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public void setInventory(Inventory inventory) {
        this.inventory = inventory;
    }

    public UUID getPlayerId() {
        return this.playerId;
    }

    public String getMenuType() {
        return this.menuType;
    }

    public String getMenuId() {
        return this.menuId;
    }

    public BaseMenu getMenu() {
        return this.menu;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public boolean isExpired(long maxAge) {
        return System.currentTimeMillis() - this.createdAt > maxAge;
    }

    private int computeHash() {
        int result = this.playerId.hashCode();
        result = 31 * result + this.menuType.hashCode();
        result = 31 * result + (this.menuId != null ? this.menuId.hashCode() : 0);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof OptimizedMenuHolder)) {
            return false;
        }
        OptimizedMenuHolder other = (OptimizedMenuHolder)obj;
        return this.holderHash == other.holderHash && this.playerId.equals(other.playerId) && this.menuType.equals(other.menuType) && (this.menuId != null ? this.menuId.equals(other.menuId) : other.menuId == null);
    }

    public int hashCode() {
        return this.holderHash;
    }

    public boolean isMenuType(String type) {
        return this.menuType.equals(type);
    }

    public boolean belongsTo(UUID playerId) {
        return this.playerId.equals(playerId);
    }
}

