/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.reward.gui;

import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.config.LanguageManager;
import fr.ax_dev.universejobs.job.Job;
import fr.ax_dev.universejobs.menu.MenuUtils;
import fr.ax_dev.universejobs.reward.Reward;
import fr.ax_dev.universejobs.reward.RewardManager;
import fr.ax_dev.universejobs.reward.RewardStatus;
import fr.ax_dev.universejobs.reward.gui.GuiConfig;
import fr.ax_dev.universejobs.reward.gui.ItemBuilder;
import fr.ax_dev.universejobs.utils.MessageUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class CustomRewardGui
implements InventoryHolder {
    private final UniverseJobs plugin;
    private final LanguageManager languageManager;
    private final Player player;
    private final Job job;
    private final List<Reward> rewards;
    private final GuiConfig config;
    private final RewardManager rewardManager;
    private Inventory inventory;
    private int currentPage;
    private final int rewardsPerPage;

    public CustomRewardGui(UniverseJobs plugin, Player player, Job job, List<Reward> rewards, GuiConfig config, int page) {
        this.plugin = plugin;
        this.languageManager = plugin.getLanguageManager();
        this.player = player;
        this.job = job;
        this.rewards = rewards;
        this.config = config;
        this.rewardManager = plugin.getRewardManager();
        this.currentPage = page;
        this.rewardsPerPage = config.getRewardSlots(page).size();
        this.createInventory();
        this.populateInventory();
    }

    private void createInventory() {
        String title = this.config.getTitle().replace("{job}", this.job.getName());
        title = MenuUtils.processPlaceholders(this.player, title);
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)this.config.getSize(), (String)MessageUtils.colorize(title));
    }

    private void populateInventory() {
        this.inventory.clear();
        this.addCustomItems();
        this.addNavigationItems();
        this.addRewardItems();
        this.addFillItems();
    }

    private void addFillItems() {
        block4: {
            Map<String, Object> fillConfig = this.config.getFillItems();
            if (!((Boolean)fillConfig.getOrDefault("enabled", false)).booleanValue()) break block4;
            String fillMaterialName = (String)fillConfig.getOrDefault("material", "GRAY_STAINED_GLASS_PANE");
            String fillName = (String)fillConfig.getOrDefault("name", " ");
            List fillSlots = fillConfig.getOrDefault("slots", new ArrayList());
            ItemStack fillItem = ItemBuilder.fromMaterialName(this.plugin, fillMaterialName).name(fillName).build();
            if (fillSlots.isEmpty()) {
                for (int i = 0; i < this.inventory.getSize(); ++i) {
                    if (this.inventory.getItem(i) != null) continue;
                    this.inventory.setItem(i, fillItem);
                }
            } else {
                Iterator iterator = fillSlots.iterator();
                while (iterator.hasNext()) {
                    int slot = (Integer)iterator.next();
                    if (slot < 0 || slot >= this.inventory.getSize()) continue;
                    this.inventory.setItem(slot, fillItem);
                }
            }
        }
    }

    private void addCustomItems() {
        for (GuiConfig.GuiItem guiItem : this.config.getItems().values()) {
            ItemStack item = this.createItemFromConfig(guiItem);
            for (int slot : guiItem.getSlots()) {
                if (slot < 0 || slot >= this.inventory.getSize()) continue;
                this.inventory.setItem(slot, item);
            }
        }
    }

    private void addNavigationItems() {
        ItemStack item;
        GuiConfig.NavigationConfig nav = this.config.getNavigation();
        if (nav.getPreviousPage() != null && this.currentPage > 0) {
            item = this.createItemFromConfig(nav.getPreviousPage());
            for (int slot : nav.getPreviousPage().getSlots()) {
                if (slot < 0 || slot >= this.inventory.getSize()) continue;
                this.inventory.setItem(slot, item);
            }
        }
        if (nav.getNextPage() != null && this.hasNextPage()) {
            item = this.createItemFromConfig(nav.getNextPage());
            for (int slot : nav.getNextPage().getSlots()) {
                if (slot < 0 || slot >= this.inventory.getSize()) continue;
                this.inventory.setItem(slot, item);
            }
        }
        if (nav.getClose() != null) {
            item = this.createItemFromConfig(nav.getClose());
            for (int slot : nav.getClose().getSlots()) {
                if (slot < 0 || slot >= this.inventory.getSize()) continue;
                this.inventory.setItem(slot, item);
            }
        }
        if (nav.getRefresh() != null) {
            item = this.createItemFromConfig(nav.getRefresh());
            for (int slot : nav.getRefresh().getSlots()) {
                if (slot < 0 || slot >= this.inventory.getSize()) continue;
                this.inventory.setItem(slot, item);
            }
        }
        if (nav.getInfo() != null) {
            item = this.createItemFromConfig(nav.getInfo());
            for (int slot : nav.getInfo().getSlots()) {
                if (slot < 0 || slot >= this.inventory.getSize()) continue;
                this.inventory.setItem(slot, item);
            }
        }
        if (nav.getBack() != null) {
            item = this.createItemFromConfig(nav.getBack());
            for (int slot : nav.getBack().getSlots()) {
                if (slot < 0 || slot >= this.inventory.getSize()) continue;
                this.inventory.setItem(slot, item);
            }
        }
    }

    private void addRewardItems() {
        int rewardIndex;
        List<Integer> rewardSlots = this.config.getRewardSlots(this.currentPage);
        int startIndex = this.currentPage * this.rewardsPerPage;
        for (int i = 0; i < this.rewardsPerPage && i < rewardSlots.size() && (rewardIndex = startIndex + i) < this.rewards.size(); ++i) {
            Reward reward = this.rewards.get(rewardIndex);
            ItemStack rewardItem = this.createRewardItem(reward);
            int slot = rewardSlots.get(i);
            if (slot < 0 || slot >= this.inventory.getSize()) continue;
            this.inventory.setItem(slot, rewardItem);
        }
    }

    private ItemStack createItemFromConfig(GuiConfig.GuiItem guiItem) {
        ItemBuilder builder = !guiItem.getPlayerHead().isEmpty() ? new ItemBuilder(this.plugin, Material.PLAYER_HEAD).playerHead(guiItem.getPlayerHead()).amount(guiItem.getAmount()) : ItemBuilder.fromMaterialName(this.plugin, guiItem.getMaterialName()).amount(guiItem.getAmount());
        if (!guiItem.getDisplayName().isEmpty()) {
            builder.name(guiItem.getDisplayName());
        }
        if (!guiItem.getLore().isEmpty()) {
            builder.lore(guiItem.getLore());
        }
        if (guiItem.getCustomModelData() > 0) {
            builder.customModelData(guiItem.getCustomModelData());
        }
        ItemStack item = builder.build();
        for (Map.Entry<Enchantment, Integer> entry : guiItem.getEnchantments().entrySet()) {
            item.addUnsafeEnchantment(entry.getKey(), entry.getValue().intValue());
        }
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            if (guiItem.isHideAttributes()) {
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
            }
            if (guiItem.isHideEnchants()) {
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            }
            if (guiItem.isGlowing() && guiItem.getEnchantments().isEmpty()) {
                item.addUnsafeEnchantment(Enchantment.LURE, 1);
                if (!guiItem.isHideEnchants()) {
                    meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                }
            }
            item.setItemMeta(meta);
        }
        return item;
    }

    private ItemStack createRewardItem(Reward reward) {
        String statusKey;
        RewardStatus status = this.rewardManager.getRewardStatus(this.player, reward);
        GuiConfig.RewardItemConfig rewardConfig = this.config.getRewardItemConfig();
        String materialName = rewardConfig.getMaterial(statusKey = status.name().toLowerCase());
        ItemBuilder builder = ItemBuilder.fromMaterialName(this.plugin, materialName);
        if (builder == null) {
            builder = new ItemBuilder(this.plugin, Material.CHEST);
        }
        String displayName = rewardConfig.getDisplayName(statusKey).replace("{reward_name}", reward.getName());
        displayName = MenuUtils.processPlaceholders(this.player, displayName);
        builder.name(displayName);
        ArrayList<String> lore = new ArrayList<String>();
        Iterator<String> iterator = rewardConfig.getLoreTemplate(statusKey).iterator();
        while (iterator.hasNext()) {
            String line;
            String processedLine = line = iterator.next();
            processedLine = processedLine.replace("{level}", String.valueOf(reward.getRequiredLevel()));
            processedLine = processedLine.replace("{reward_name}", reward.getName());
            processedLine = processedLine.replace("{description}", reward.getDescription());
            if ((processedLine = processedLine.replace("{reward_description}", reward.getDescription())).contains("{player_level}")) {
                int playerLevel = this.plugin.getJobManager().getLevel(this.player, reward.getJobId());
                processedLine = processedLine.replace("{player_level}", String.valueOf(playerLevel));
            }
            if (processedLine.contains("{claim_date}") && status == RewardStatus.RETRIEVED) {
                long claimTime = this.rewardManager.getLastClaimTime(this.player, reward);
                String claimDate = new SimpleDateFormat("dd/MM/yyyy").format(new Date(claimTime));
                processedLine = processedLine.replace("{claim_date}", claimDate);
            }
            processedLine = MenuUtils.processPlaceholders(this.player, processedLine);
            lore.add(processedLine);
        }
        builder.lore(lore);
        return builder.build();
    }

    private boolean hasNextPage() {
        return (this.currentPage + 1) * this.rewardsPerPage < this.rewards.size();
    }

    public void open() {
        this.player.openInventory(this.inventory);
    }

    public boolean isInventory(Inventory inventory) {
        return this.inventory.equals((Object)inventory);
    }

    public void handleClick(int slot) {
        int rewardIndex;
        List<Integer> rewardSlots = this.config.getRewardSlots(this.currentPage);
        int rewardSlotIndex = rewardSlots.indexOf(slot);
        if (rewardSlotIndex != -1 && (rewardIndex = this.currentPage * this.rewardsPerPage + rewardSlotIndex) < this.rewards.size()) {
            Reward reward = this.rewards.get(rewardIndex);
            this.handleRewardClick(reward);
            return;
        }
        GuiConfig.NavigationConfig nav = this.config.getNavigation();
        if (nav.getPreviousPage() != null && nav.getPreviousPage().getSlots().contains(slot)) {
            if (this.currentPage > 0) {
                CustomRewardGui newGui = new CustomRewardGui(this.plugin, this.player, this.job, this.rewards, this.config, this.currentPage - 1);
                this.plugin.getRewardGuiManager().updateOpenGui(this.player, newGui);
                newGui.open();
            }
        } else if (nav.getNextPage() != null && nav.getNextPage().getSlots().contains(slot)) {
            if (this.hasNextPage()) {
                CustomRewardGui newGui = new CustomRewardGui(this.plugin, this.player, this.job, this.rewards, this.config, this.currentPage + 1);
                this.plugin.getRewardGuiManager().updateOpenGui(this.player, newGui);
                newGui.open();
            }
        } else if (nav.getClose() != null && nav.getClose().getSlots().contains(slot)) {
            this.player.closeInventory();
        } else if (nav.getRefresh() != null && nav.getRefresh().getSlots().contains(slot)) {
            this.populateInventory();
        } else if (nav.getBack() != null && nav.getBack().getSlots().contains(slot)) {
            this.player.closeInventory();
            this.plugin.getMenuManager().openJobMenu(this.player, this.job.getId());
        }
    }

    private void handleRewardClick(Reward reward) {
        RewardStatus status = this.rewardManager.getRewardStatus(this.player, reward);
        if (status == RewardStatus.RETRIEVABLE) {
            if (this.rewardManager.claimReward(this.player, reward)) {
                MessageUtils.sendMessage(this.player, this.languageManager.getMessage("rewards.claim.success", "reward", reward.getName(), "level", String.valueOf(reward.getRequiredLevel())));
                this.populateInventory();
            } else {
                MessageUtils.sendMessage(this.player, this.languageManager.getMessage("rewards.claim.failed", "reward", reward.getName()));
            }
        } else if (status == RewardStatus.BLOCKED) {
            this.rewardManager.canClaimReward(this.player, reward, true);
        } else {
            MessageUtils.sendMessage(this.player, this.languageManager.getMessage("rewards.claim.already-claimed"));
        }
    }

    public Inventory getInventory() {
        return this.inventory;
    }
}

