/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.storage.dao;

import fr.ax_dev.universejobs.job.PlayerJobData;
import fr.ax_dev.universejobs.storage.SqlIdentifierValidator;
import fr.ax_dev.universejobs.storage.database.DatabaseConfig;
import fr.ax_dev.universejobs.storage.database.HikariConnectionPool;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;

public class PlayerDataDao {
    private final HikariConnectionPool connectionPool;
    private final String tableName;
    private final String insertSql;
    private final String updateSql;
    private final String selectByPlayerSql;
    private final String selectByPlayerAndJobSql;
    private final String deleteByPlayerAndJobSql;
    private final String deleteByPlayerSql;
    private final String selectAllByPlayersSql;

    public PlayerDataDao(HikariConnectionPool connectionPool, DatabaseConfig config) {
        this.connectionPool = connectionPool;
        this.tableName = SqlIdentifierValidator.buildSafeTableName(config.getPrefix(), "player_data");
        this.insertSql = "INSERT INTO " + this.tableName + " (player_uuid, job_id, xp, level, last_modified) VALUES (?, ?, ?, ?, ?)";
        this.updateSql = "UPDATE " + this.tableName + " SET xp = ?, level = ?, last_modified = ? WHERE player_uuid = ? AND job_id = ?";
        this.selectByPlayerSql = "SELECT job_id, xp, level, last_modified FROM " + this.tableName + " WHERE player_uuid = ?";
        this.selectByPlayerAndJobSql = "SELECT xp, level, last_modified FROM " + this.tableName + " WHERE player_uuid = ? AND job_id = ?";
        this.deleteByPlayerAndJobSql = "DELETE FROM " + this.tableName + " WHERE player_uuid = ? AND job_id = ?";
        this.deleteByPlayerSql = "DELETE FROM " + this.tableName + " WHERE player_uuid = ?";
        this.selectAllByPlayersSql = "SELECT player_uuid, job_id, xp, level, last_modified FROM " + this.tableName + " WHERE player_uuid IN ";
    }

    public CompletableFuture<Void> savePlayerData(UUID playerId, PlayerJobData data) {
        return CompletableFuture.runAsync(() -> {
            try (Connection conn = this.connectionPool.getConnection();){
                conn.setAutoCommit(false);
                try (PreparedStatement deleteStmt = conn.prepareStatement(this.deleteByPlayerSql);){
                    deleteStmt.setString(1, playerId.toString());
                    deleteStmt.executeUpdate();
                }
                try (PreparedStatement insertStmt = conn.prepareStatement(this.insertSql);){
                    for (String jobId : data.getJobs()) {
                        insertStmt.setString(1, playerId.toString());
                        insertStmt.setString(2, jobId);
                        insertStmt.setDouble(3, data.getXp(jobId));
                        insertStmt.setInt(4, data.getLevel(jobId));
                        insertStmt.setLong(5, data.getLastModified());
                        insertStmt.addBatch();
                    }
                    insertStmt.executeBatch();
                }
                conn.commit();
            }
            catch (SQLException e) {
                throw new RuntimeException("Failed to save player data for " + String.valueOf(playerId), e);
            }
        });
    }

    public CompletableFuture<PlayerJobData> loadPlayerData(UUID playerId) {
        return CompletableFuture.supplyAsync(() -> {
            PlayerJobData data = new PlayerJobData(playerId);
            try (Connection conn = this.connectionPool.getConnection();){
                PlayerJobData playerJobData;
                block22: {
                    PreparedStatement stmt = conn.prepareStatement(this.selectByPlayerSql);
                    try {
                        stmt.setString(1, playerId.toString());
                        try (ResultSet rs = stmt.executeQuery();){
                            while (rs.next()) {
                                String jobId = rs.getString("job_id");
                                double xp = rs.getDouble("xp");
                                int level = rs.getInt("level");
                                data.joinJob(jobId);
                                data.setXp(jobId, xp);
                                data.setLevel(jobId, level);
                            }
                        }
                        playerJobData = data;
                        if (stmt == null) break block22;
                    }
                    catch (Throwable throwable) {
                        if (stmt != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    stmt.close();
                }
                return playerJobData;
            }
            catch (SQLException e) {
                throw new RuntimeException("Failed to load player data for " + String.valueOf(playerId), e);
            }
        });
    }

    public CompletableFuture<Map<UUID, PlayerJobData>> loadPlayerDataBatch(Set<UUID> playerIds) {
        return CompletableFuture.supplyAsync(() -> {
            HashMap<UUID, PlayerJobData> result = new HashMap<UUID, PlayerJobData>();
            if (playerIds.isEmpty()) {
                return result;
            }
            StringBuilder inClause = new StringBuilder("(");
            for (int i = 0; i < playerIds.size(); ++i) {
                inClause.append("?");
                if (i >= playerIds.size() - 1) continue;
                inClause.append(",");
            }
            inClause.append(")");
            String sql = this.selectAllByPlayersSql + inClause.toString();
            try (Connection conn = this.connectionPool.getConnection();){
                HashMap<UUID, PlayerJobData> hashMap;
                block25: {
                    PreparedStatement stmt = conn.prepareStatement(sql);
                    try {
                        int index = 1;
                        for (UUID playerId : playerIds) {
                            stmt.setString(index++, playerId.toString());
                            result.put(playerId, new PlayerJobData(playerId));
                        }
                        try (ResultSet rs = stmt.executeQuery();){
                            while (rs.next()) {
                                UUID playerId;
                                playerId = UUID.fromString(rs.getString("player_uuid"));
                                String jobId = rs.getString("job_id");
                                double xp = rs.getDouble("xp");
                                int level = rs.getInt("level");
                                PlayerJobData data = (PlayerJobData)result.get(playerId);
                                if (data == null) continue;
                                data.joinJob(jobId);
                                data.setXp(jobId, xp);
                                data.setLevel(jobId, level);
                            }
                        }
                        hashMap = result;
                        if (stmt == null) break block25;
                    }
                    catch (Throwable throwable) {
                        if (stmt != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    stmt.close();
                }
                return hashMap;
            }
            catch (SQLException e) {
                throw new RuntimeException("Failed to load player data batch", e);
            }
        });
    }

    public CompletableFuture<Void> updateJobData(UUID playerId, String jobId, double xp, int level) {
        return CompletableFuture.runAsync(() -> {
            block34: {
                try (Connection conn = this.connectionPool.getConnection();){
                    boolean exists = false;
                    try (PreparedStatement checkStmt = conn.prepareStatement(this.selectByPlayerAndJobSql);){
                        checkStmt.setString(1, playerId.toString());
                        checkStmt.setString(2, jobId);
                        try (ResultSet rs = checkStmt.executeQuery();){
                            exists = rs.next();
                        }
                    }
                    if (exists) {
                        try (PreparedStatement updateStmt = conn.prepareStatement(this.updateSql);){
                            updateStmt.setDouble(1, xp);
                            updateStmt.setInt(2, level);
                            updateStmt.setLong(3, System.currentTimeMillis());
                            updateStmt.setString(4, playerId.toString());
                            updateStmt.setString(5, jobId);
                            updateStmt.executeUpdate();
                            break block34;
                        }
                    }
                    try (PreparedStatement insertStmt = conn.prepareStatement(this.insertSql);){
                        insertStmt.setString(1, playerId.toString());
                        insertStmt.setString(2, jobId);
                        insertStmt.setDouble(3, xp);
                        insertStmt.setInt(4, level);
                        insertStmt.setLong(5, System.currentTimeMillis());
                        insertStmt.executeUpdate();
                    }
                }
                catch (SQLException e) {
                    throw new RuntimeException("Failed to update job data for " + String.valueOf(playerId) + " job " + jobId, e);
                }
            }
        });
    }

    public CompletableFuture<Void> removeJobData(UUID playerId, String jobId) {
        return CompletableFuture.runAsync(() -> {
            try (Connection conn = this.connectionPool.getConnection();
                 PreparedStatement stmt = conn.prepareStatement(this.deleteByPlayerAndJobSql);){
                stmt.setString(1, playerId.toString());
                stmt.setString(2, jobId);
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                throw new RuntimeException("Failed to remove job data for " + String.valueOf(playerId) + " job " + jobId, e);
            }
        });
    }

    public CompletableFuture<Void> deletePlayerData(UUID playerId) {
        return CompletableFuture.runAsync(() -> {
            String sql = "DELETE FROM " + this.tableName + " WHERE player_uuid = ?";
            try (Connection conn = this.connectionPool.getConnection();
                 PreparedStatement stmt = conn.prepareStatement(sql);){
                stmt.setString(1, playerId.toString());
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                throw new RuntimeException("Failed to delete player data for " + String.valueOf(playerId), e);
            }
        });
    }

    public CompletableFuture<Double> getJobUserCount(String jobId) {
        return CompletableFuture.supplyAsync(() -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
    }
}

