/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.storage.database;

import fr.ax_dev.universejobs.storage.database.DatabaseType;
import org.bukkit.configuration.ConfigurationSection;

public class DatabaseConfig {
    private final boolean enabled;
    private final DatabaseType type;
    private final String host;
    private final int port;
    private final String database;
    private final String username;
    private final String password;
    private final String prefix;
    private final int minConnections;
    private final int maxConnections;
    private final long connectionTimeoutMs;
    private final long validationIntervalMs;

    public DatabaseConfig(ConfigurationSection config) {
        this.enabled = config.getBoolean("enabled", false);
        String typeString = config.getString("type", "sqlite");
        this.type = DatabaseType.fromString(typeString);
        this.host = config.getString("host", "localhost");
        this.port = config.getInt("port", this.type.getDefaultPort());
        this.database = config.getString("database", "universejobs");
        this.username = config.getString("username", "root");
        this.password = config.getString("password", "");
        this.prefix = config.getString("prefix", "universejobs_");
        ConfigurationSection poolConfig = config.getConfigurationSection("pool");
        if (poolConfig != null) {
            this.minConnections = poolConfig.getInt("min-connections", 2);
            this.maxConnections = poolConfig.getInt("max-connections", 10);
            this.connectionTimeoutMs = poolConfig.getLong("connection-timeout-ms", 30000L);
            this.validationIntervalMs = poolConfig.getLong("validation-interval-ms", 300000L);
        } else {
            this.minConnections = 2;
            this.maxConnections = 10;
            this.connectionTimeoutMs = 30000L;
            this.validationIntervalMs = 300000L;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public DatabaseType getType() {
        return this.type;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public int getMinConnections() {
        return this.minConnections;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public long getConnectionTimeoutMs() {
        return this.connectionTimeoutMs;
    }

    public long getValidationIntervalMs() {
        return this.validationIntervalMs;
    }

    public String buildJdbcUrl(String dataFolder) {
        switch (this.type) {
            case MYSQL: {
                return String.format("%s%s:%d/%s?useSSL=false&serverTimezone=UTC&allowPublicKeyRetrieval=true", this.type.getProtocol(), this.host, this.port, this.database);
            }
        }
        return this.type.getProtocol() + dataFolder + "/data.db";
    }
}

