/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.utils;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.profile.PlayerProfile;

public class PlayerTextureCache {
    private static final Map<UUID, PlayerProfile> PROFILE_CACHE = new ConcurrentHashMap<UUID, PlayerProfile>();
    private static final Map<UUID, Long> CACHE_TIMESTAMPS = new ConcurrentHashMap<UUID, Long>();
    private static final long CACHE_DURATION = TimeUnit.HOURS.toMillis(24L);
    private static final int MAX_CACHE_SIZE = 500;

    public static CompletableFuture<PlayerProfile> getPlayerProfile(UUID playerId, String playerName) {
        PlayerProfile cached;
        Long timestamp = CACHE_TIMESTAMPS.get(playerId);
        if (timestamp != null && System.currentTimeMillis() - timestamp < CACHE_DURATION && (cached = PROFILE_CACHE.get(playerId)) != null) {
            return CompletableFuture.completedFuture(cached);
        }
        return CompletableFuture.supplyAsync(() -> {
            try {
                PlayerProfile profile = Bukkit.createPlayerProfile((UUID)playerId, (String)playerName);
                profile.update().get(5L, TimeUnit.SECONDS);
                if (PROFILE_CACHE.size() >= 500) {
                    PlayerTextureCache.cleanOldestEntries();
                }
                PROFILE_CACHE.put(playerId, profile);
                CACHE_TIMESTAMPS.put(playerId, System.currentTimeMillis());
                return profile;
            }
            catch (Exception e) {
                PlayerProfile fallback = Bukkit.createPlayerProfile((UUID)playerId, (String)playerName);
                return fallback;
            }
        });
    }

    private static void cleanOldestEntries() {
        long oldestTime = System.currentTimeMillis();
        UUID oldestUuid = null;
        for (Map.Entry<UUID, Long> entry : CACHE_TIMESTAMPS.entrySet()) {
            if (entry.getValue() >= oldestTime) continue;
            oldestTime = entry.getValue();
            oldestUuid = entry.getKey();
        }
        if (oldestUuid != null) {
            PROFILE_CACHE.remove(oldestUuid);
            CACHE_TIMESTAMPS.remove(oldestUuid);
        }
    }

    public static void clearCache() {
        PROFILE_CACHE.clear();
        CACHE_TIMESTAMPS.clear();
    }

    public static void removeFromCache(UUID playerId) {
        PROFILE_CACHE.remove(playerId);
        CACHE_TIMESTAMPS.remove(playerId);
    }
}

