/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.command.handler;

import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.command.handler.BoostCommandHandler;
import fr.ax_dev.universejobs.command.handler.JobCommandHandler;
import fr.ax_dev.universejobs.job.Job;
import fr.ax_dev.universejobs.job.JobManager;
import fr.ax_dev.universejobs.job.PlayerJobData;
import fr.ax_dev.universejobs.storage.database.DatabaseDataStorage;
import fr.ax_dev.universejobs.storage.migration.DataMigrator;
import fr.ax_dev.universejobs.utils.MessageUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.stream.Collectors;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class AdminJobCommandHandler
extends JobCommandHandler {
    private final JobManager jobManager;
    private final BoostCommandHandler boostHandler;
    private final Map<String, Long> resetConfirmations = new ConcurrentHashMap<String, Long>();
    private static final long CONFIRMATION_TIMEOUT = 10000L;

    public AdminJobCommandHandler(UniverseJobs plugin, JobManager jobManager) {
        super(plugin);
        this.jobManager = jobManager;
        this.boostHandler = new BoostCommandHandler(plugin);
    }

    private void sendMessage(CommandSender sender, String messageKey, String ... replacements) {
        String message = this.languageManager.getMessage("commands.admin." + messageKey);
        for (int i = 0; i < replacements.length; i += 2) {
            if (i + 1 >= replacements.length) continue;
            String placeholder = "{" + replacements[i] + "}";
            message = message.replace(placeholder, replacements[i + 1]);
        }
        MessageUtils.sendMessage(sender, message);
    }

    @Override
    public boolean handleCommand(CommandSender sender, String[] args) {
        return false;
    }

    public boolean handleAdminCommand(CommandSender sender, String[] args) {
        String subCommand;
        if (args.length < 2) {
            this.sendAdminHelp(sender);
            return true;
        }
        return switch (subCommand = args[1].toLowerCase()) {
            case "give" -> this.handleGiveCommand(sender, args);
            case "forcejoin" -> this.handleForceJoin(sender, args);
            case "forceleave" -> this.handleForceLeave(sender, args);
            case "reset" -> this.handleReset(sender, args);
            case "info" -> this.handlePlayerInfo(sender, args);
            case "reload" -> this.handleReload(sender, args);
            case "boost" -> {
                this.boostHandler.handleCommand(sender, args);
                yield true;
            }
            case "migrate" -> this.handleMigrate(sender, args);
            default -> {
                this.sendAdminHelp(sender);
                yield true;
            }
        };
    }

    private boolean handleGiveCommand(CommandSender sender, String[] args) {
        String giveType;
        if (args.length < 3) {
            this.sendGiveHelp(sender);
            return true;
        }
        return switch (giveType = args[2].toLowerCase()) {
            case "xp" -> this.handleXpCommand(sender, args);
            case "level" -> this.handleLevelCommand(sender, args);
            case "custom" -> this.handleGiveCustom(sender, args);
            default -> {
                this.sendGiveHelp(sender);
                yield true;
            }
        };
    }

    private void sendGiveHelp(CommandSender sender) {
        this.sendMessage(sender, "give-help-header", new String[0]);
        this.sendMessage(sender, "give-help-xp", new String[0]);
        this.sendMessage(sender, "give-help-level", new String[0]);
        this.sendMessage(sender, "give-help-custom", new String[0]);
    }

    private boolean handleGiveCustom(CommandSender sender, String[] args) {
        Job job;
        double xp;
        boolean tempSilent;
        double tempMoney;
        String jobId;
        String playerName;
        String action;
        block12: {
            if (args.length < 7) {
                MessageUtils.sendMessage(sender, "&cUsage: /jobs admin give custom <action> <player> <job> <exp> [money] [silent]");
                return true;
            }
            if (!sender.hasPermission("universejobs.admin.givecustom")) {
                this.sendMessage(sender, "no-permission", new String[0]);
                return true;
            }
            action = args[3];
            playerName = args[4];
            jobId = args[5];
            tempMoney = 0.0;
            tempSilent = false;
            try {
                xp = Double.parseDouble(args[6]);
                if (args.length < 8) break block12;
                try {
                    tempMoney = Double.parseDouble(args[7]);
                    tempSilent = args.length >= 9 && "silent".equalsIgnoreCase(args[8]);
                }
                catch (NumberFormatException e) {
                    if ("silent".equalsIgnoreCase(args[7])) {
                        tempMoney = 0.0;
                        tempSilent = true;
                        break block12;
                    }
                    tempMoney = 0.0;
                    tempSilent = false;
                }
            }
            catch (NumberFormatException e) {
                MessageUtils.sendMessage(sender, "&cInvalid amounts. Use numbers.");
                return true;
            }
        }
        double money = tempMoney;
        boolean silent = tempSilent;
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)playerName);
        if (target == null) {
            if (!silent) {
                MessageUtils.sendMessage(sender, "&cPlayer " + playerName + " not found.");
            }
            return true;
        }
        if (this.plugin.getConfigManager().isDebugEnabled()) {
            this.plugin.getLogger().info("Give custom command - Player: " + playerName + ", Job: " + jobId + ", XP: " + xp + ", Money: " + money + ", Silent: " + silent);
            this.plugin.getLogger().info("Target player UUID: " + String.valueOf(target.getUniqueId()) + ", HasPlayedBefore: " + target.hasPlayedBefore());
        }
        if ((job = this.jobManager.getJob(jobId)) == null) {
            if (!silent) {
                this.sendMessage(sender, "job-not-found", "job", jobId);
            }
            return true;
        }
        this.plugin.getFoliaManager().runAsync(() -> {
            block21: {
                try {
                    PlayerJobData playerData = this.jobManager.getPlayerData(target.getUniqueId());
                    if (!playerData.hasJob(jobId)) {
                        if (!silent) {
                            this.plugin.getFoliaManager().runNextTick(() -> this.sendMessage(sender, "player-no-job", "player", playerName, "job", jobId));
                        }
                        return;
                    }
                    double[] finalValues = new double[]{xp, money};
                    if (target.isOnline() && target.getPlayer() != null) {
                        Player onlinePlayer = target.getPlayer();
                        finalValues[0] = this.applyXpMultipliers(onlinePlayer, job, xp);
                        finalValues[1] = this.applyMoneyMultipliers(onlinePlayer, job, money);
                        if (this.plugin.getConfigManager().isDebugEnabled()) {
                            this.plugin.getLogger().info("Applied multipliers - Original XP: " + xp + ", Final XP: " + finalValues[0] + ", Original Money: " + money + ", Final Money: " + finalValues[1]);
                        }
                    }
                    switch (action.toLowerCase()) {
                        case "give": {
                            if (finalValues[0] > 0.0) {
                                playerData.addXp(jobId, finalValues[0]);
                            }
                            if (!(finalValues[1] > 0.0)) break;
                            this.addPlayerMoney(target, finalValues[1]);
                            break;
                        }
                        case "set": {
                            if (xp > 0.0) {
                                playerData.setXp(jobId, xp);
                            }
                            finalValues[0] = xp;
                            finalValues[1] = 0.0;
                            break;
                        }
                        case "remove": {
                            if (xp > 0.0) {
                                double currentXp = playerData.getXp(jobId);
                                double newXp = Math.max(0.0, currentXp - xp);
                                playerData.setXp(jobId, newXp);
                            }
                            if (money > 0.0) {
                                this.removePlayerMoney(target, money);
                            }
                            finalValues[0] = xp;
                            finalValues[1] = money;
                            break;
                        }
                        default: {
                            if (!silent) {
                                this.plugin.getFoliaManager().runNextTick(() -> MessageUtils.sendMessage(sender, "&cInvalid action. Use: give, set, remove"));
                            }
                            return;
                        }
                    }
                    this.plugin.getFoliaManager().runNextTick(() -> {
                        if (!silent) {
                            this.sendMessage(sender, "givecustom-success", "player", target.getName(), "job", job.getName(), "xp", String.valueOf(finalValues[0]), "money", String.valueOf(finalValues[1]));
                        }
                        if (target.isOnline() && "give".equalsIgnoreCase(action)) {
                            Player onlinePlayer = target.getPlayer();
                            String messageText = job.getXpMessageSettings().processMessage(finalValues[0], finalValues[1]);
                            messageText = messageText.replace("{job}", job.getDisplayName());
                            this.plugin.getMessageSender().sendXpMessage(onlinePlayer, job, finalValues[0], finalValues[1], playerData);
                        }
                    });
                }
                catch (Exception e) {
                    this.plugin.getLogger().warning("Error during givecustom: " + e.getMessage());
                    if (silent) break block21;
                    this.plugin.getFoliaManager().runNextTick(() -> MessageUtils.sendMessage(sender, "&cError while giving rewards."));
                }
            }
        });
        return true;
    }

    private void addPlayerMoney(OfflinePlayer player, double amount) {
        if (this.plugin.getServer().getPluginManager().isPluginEnabled("Vault")) {
            try {
                Economy economy = this.getVaultEconomy();
                if (economy != null) {
                    economy.depositPlayer(player, amount);
                    return;
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Failed to use Vault for money reward: " + e.getMessage());
            }
        }
    }

    private void removePlayerMoney(OfflinePlayer player, double amount) {
        if (this.plugin.getServer().getPluginManager().isPluginEnabled("Vault")) {
            try {
                Economy economy = this.getVaultEconomy();
                if (economy != null) {
                    economy.withdrawPlayer(player, amount);
                    return;
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Failed to use Vault for money removal: " + e.getMessage());
            }
        }
    }

    private Economy getVaultEconomy() {
        try {
            if (this.plugin.getServer().getServicesManager().getRegistration(Economy.class) != null) {
                return (Economy)this.plugin.getServer().getServicesManager().getRegistration(Economy.class).getProvider();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private boolean handleForceJoin(CommandSender sender, String[] args) {
        return this.handleForceJobAction(sender, args, "forcejoin", true);
    }

    private boolean handleForceLeave(CommandSender sender, String[] args) {
        return this.handleForceJobAction(sender, args, "forceleave", false);
    }

    private boolean handleForceJobAction(CommandSender sender, String[] args, String action, boolean isJoin) {
        if (args.length < 4) {
            this.sendMessage(sender, "usage." + action, new String[0]);
            return true;
        }
        if (!sender.hasPermission("universejobs.admin." + action)) {
            this.sendMessage(sender, "no-permission", new String[0]);
            return true;
        }
        String playerName = args[2];
        String jobId = args[3];
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)playerName);
        if (target == null) {
            this.sendMessage(sender, "player-not-found", "player", playerName);
            return true;
        }
        Job job = this.jobManager.getJob(jobId);
        if (job == null) {
            this.sendMessage(sender, "job-not-found", "job", jobId);
            return true;
        }
        this.plugin.getFoliaManager().runAsync(() -> {
            try {
                if (isJoin && target.isOnline()) {
                    this.plugin.getPlayerCache().preloadPlayer(target.getUniqueId());
                }
                boolean success = isJoin ? this.jobManager.joinJob(target.getUniqueId(), jobId) : this.jobManager.leaveJob(target.getUniqueId(), jobId);
                this.plugin.getFoliaManager().runNextTick(() -> {
                    if (success) {
                        if (target.isOnline()) {
                            if (isJoin) {
                                this.plugin.getPlayerCache().addPlayerJob(target.getUniqueId(), jobId);
                            } else {
                                this.plugin.getPlayerCache().removePlayerJob(target.getUniqueId(), jobId);
                            }
                        }
                        this.sendMessage(sender, action + "-success", "player", target.getName(), "job", job.getName());
                        if (target.isOnline()) {
                            MessageUtils.sendMessage(target.getPlayer(), this.languageManager.getMessage("commands.admin." + action + "-notify", "job", job.getName()));
                        }
                    } else {
                        this.sendMessage(sender, action + "-failed", new String[0]);
                    }
                });
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Error during " + action + ": " + e.getMessage());
                this.plugin.getFoliaManager().runNextTick(() -> this.sendMessage(sender, action + "-failed", new String[0]));
            }
        });
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean handleReset(CommandSender sender, String[] args) {
        String finalJobId;
        OfflinePlayer target;
        block8: {
            this.cleanupExpiredConfirmations();
            if (args.length < 3) {
                this.sendMessage(sender, "usage.reset", new String[0]);
                return true;
            }
            if (!sender.hasPermission("universejobs.admin.reset")) {
                this.sendMessage(sender, "no-permission", new String[0]);
                return true;
            }
            String playerName = args[2];
            String jobId = args.length > 3 ? args[3] : null;
            target = Bukkit.getOfflinePlayer((String)playerName);
            if (target == null) {
                this.sendMessage(sender, "player-not-found", "player", playerName);
                return true;
            }
            if (jobId == null) {
                String confirmationKey = sender.getName() + ":" + playerName;
                long currentTime = System.currentTimeMillis();
                Long lastConfirmation = this.resetConfirmations.get(confirmationKey);
                if (lastConfirmation != null && currentTime - lastConfirmation <= 10000L) {
                    this.resetConfirmations.remove(confirmationKey);
                    finalJobId = "ALL";
                    break block8;
                } else {
                    this.resetConfirmations.put(confirmationKey, currentTime);
                    this.sendMessage(sender, "reset-confirmation", "player", playerName);
                    return true;
                }
            }
            finalJobId = jobId;
        }
        if ("ALL".equalsIgnoreCase(finalJobId)) {
            this.plugin.getFoliaManager().runAsync(() -> {
                try {
                    PlayerJobData playerData = this.jobManager.getPlayerData(target.getUniqueId());
                    Set<String> jobs = playerData.getJobs();
                    for (String jobToReset : jobs) {
                        playerData.setXp(jobToReset, 0.0);
                        playerData.setLevel(jobToReset, 0);
                        playerData.leaveJob(jobToReset);
                        if (this.plugin.getRewardManager() == null) continue;
                        this.plugin.getRewardManager().resetJobRewards(target.getUniqueId(), jobToReset);
                    }
                    this.jobManager.savePlayerData(target.getUniqueId());
                    if (target.isOnline()) {
                        this.plugin.getPlayerCache().cleanupPlayer(target.getUniqueId());
                        this.plugin.getPlayerCache().preloadPlayer(target.getUniqueId());
                    }
                    this.plugin.getFoliaManager().runNextTick(() -> {
                        this.sendMessage(sender, "reset-success", "player", target.getName(), "cleanedJobs", String.valueOf(jobs.size()), "totalJobs", String.valueOf(jobs.size()));
                        if (target.isOnline()) {
                            MessageUtils.sendMessage(target.getPlayer(), this.languageManager.getMessage("commands.admin.reset-notify"));
                        }
                    });
                }
                catch (Exception e) {
                    this.plugin.getLogger().warning("Erreur lors du reset: " + e.getMessage());
                    this.plugin.getFoliaManager().runNextTick(() -> this.sendMessage(sender, "reset-error", new String[0]));
                }
            });
            return true;
        }
        Job job = this.jobManager.getJob(finalJobId);
        if (job == null) {
            this.sendMessage(sender, "job-not-found", "job", finalJobId);
            return true;
        }
        this.plugin.getFoliaManager().runAsync(() -> {
            try {
                PlayerJobData playerData = this.jobManager.getPlayerData(target.getUniqueId());
                playerData.setXp(finalJobId, 0.0);
                playerData.setLevel(finalJobId, 0);
                if (this.plugin.getRewardManager() != null) {
                    this.plugin.getRewardManager().resetJobRewards(target.getUniqueId(), finalJobId);
                }
                this.jobManager.savePlayerData(target.getUniqueId());
                if (target.isOnline()) {
                    this.plugin.getPlayerCache().updatePlayerXp(target.getUniqueId(), finalJobId, 0.0, 0);
                }
                this.plugin.getFoliaManager().runNextTick(() -> {
                    this.sendMessage(sender, "reset-job-success", "job", job.getName(), "player", target.getName());
                    if (target.isOnline()) {
                        MessageUtils.sendMessage(target.getPlayer(), this.languageManager.getMessage("commands.admin.reset-job-notify", "job", job.getName()));
                    }
                });
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Erreur lors du reset du m\u00e9tier: " + e.getMessage());
                this.plugin.getFoliaManager().runNextTick(() -> this.sendMessage(sender, "reset-error", new String[0]));
            }
        });
        return true;
    }

    private boolean handleXpCommand(CommandSender sender, String[] args) {
        double amount;
        if (args.length < 6) {
            this.sendMessage(sender, "usage.xp", new String[0]);
            return true;
        }
        String action = args[2].toLowerCase();
        String playerName = args[3];
        String jobId = args[4];
        try {
            amount = Double.parseDouble(args[5]);
            if (amount < 0.0 && !action.equals("remove")) {
                this.sendMessage(sender, "invalid-amount", "amount", args[5]);
                return true;
            }
        }
        catch (NumberFormatException e) {
            this.sendMessage(sender, "invalid-amount", "amount", args[5]);
            return true;
        }
        return switch (action) {
            case "give" -> this.handleGiveXp(sender, playerName, jobId, amount);
            case "set" -> this.handleSetXpDirect(sender, playerName, jobId, amount);
            case "remove" -> this.handleRemoveXp(sender, playerName, jobId, amount);
            default -> {
                this.sendMessage(sender, "invalid-action", "actions", "give, set, remove");
                yield true;
            }
        };
    }

    private boolean handleLevelCommand(CommandSender sender, String[] args) {
        int amount;
        if (args.length < 6) {
            this.sendMessage(sender, "usage.level", new String[0]);
            return true;
        }
        String action = args[2].toLowerCase();
        String playerName = args[3];
        String jobId = args[4];
        try {
            amount = Integer.parseInt(args[5]);
            if (amount < 0 && !action.equals("remove")) {
                this.sendMessage(sender, "invalid-amount", "amount", args[5]);
                return true;
            }
        }
        catch (NumberFormatException e) {
            this.sendMessage(sender, "invalid-amount", "amount", args[5]);
            return true;
        }
        return switch (action) {
            case "give" -> this.handleAddLevel(sender, playerName, jobId, amount);
            case "set" -> this.handleSetLevel(sender, new String[]{"admin", "setlevel", playerName, jobId, String.valueOf(amount)});
            case "remove" -> this.handleRemoveLevel(sender, playerName, jobId, amount);
            default -> {
                this.sendMessage(sender, "invalid-action", "actions", "give, set, remove");
                yield true;
            }
        };
    }

    private boolean handleRemoveXp(CommandSender sender, String playerName, String jobId, double amount) {
        if (!sender.hasPermission("universejobs.admin.setxp")) {
            this.sendMessage(sender, "no-permission", new String[0]);
            return true;
        }
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)playerName);
        if (target == null) {
            this.sendMessage(sender, "player-not-found", "player", playerName);
            return true;
        }
        Job job = this.jobManager.getJob(jobId);
        if (job == null) {
            this.sendMessage(sender, "job-not-found", "job", jobId);
            return true;
        }
        this.plugin.getFoliaManager().runAsync(() -> {
            try {
                PlayerJobData playerData = this.jobManager.getPlayerData(target.getUniqueId());
                if (!playerData.hasJob(jobId)) {
                    this.plugin.getFoliaManager().runNextTick(() -> this.sendMessage(sender, "player-no-job", "player", target.getName(), "job", job.getName()));
                    return;
                }
                double currentXp = playerData.getXp(jobId);
                double newXp = Math.max(0.0, currentXp - amount);
                playerData.setXp(jobId, newXp);
                int newLevel = this.jobManager.getLevel(target.getPlayer(), jobId);
                this.jobManager.savePlayerData(target.getUniqueId());
                if (target.isOnline()) {
                    this.plugin.getPlayerCache().updatePlayerXp(target.getUniqueId(), jobId, newXp, newLevel);
                }
                this.plugin.getFoliaManager().runNextTick(() -> {
                    this.sendMessage(sender, "xp-taken", "amount", String.format("%.1f", amount), "player", target.getName(), "job", job.getName());
                    if (target.isOnline()) {
                        MessageUtils.sendMessage(target.getPlayer(), this.languageManager.getMessage("commands.admin.xp-lost", "amount", String.format("%.1f", amount), "job", job.getName()));
                    }
                });
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Erreur lors de la suppression d'XP: " + e.getMessage());
                this.plugin.getFoliaManager().runNextTick(() -> this.sendMessage(sender, "xp-error", "error", e.getMessage()));
            }
        });
        return true;
    }

    private boolean handleAddLevel(CommandSender sender, String playerName, String jobId, int levels) {
        if (!sender.hasPermission("universejobs.admin.setlevel")) {
            this.sendMessage(sender, "no-permission", new String[0]);
            return true;
        }
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)playerName);
        if (target == null) {
            this.sendMessage(sender, "player-not-found", "player", playerName);
            return true;
        }
        Job job = this.jobManager.getJob(jobId);
        if (job == null) {
            this.sendMessage(sender, "job-not-found", "job", jobId);
            return true;
        }
        this.plugin.getFoliaManager().runAsync(() -> {
            try {
                PlayerJobData playerData = this.jobManager.getPlayerData(target.getUniqueId());
                if (!playerData.hasJob(jobId)) {
                    playerData.joinJob(jobId);
                    if (target.isOnline()) {
                        this.plugin.getPlayerCache().addPlayerJob(target.getUniqueId(), jobId);
                    }
                }
                int currentLevel = playerData.getLevel(jobId);
                int newLevel = Math.min(job.getMaxLevel(), currentLevel + levels);
                double requiredXp = this.jobManager.getXpRequiredForLevel(jobId, newLevel);
                playerData.setLevel(jobId, newLevel);
                playerData.setXp(jobId, requiredXp);
                this.jobManager.savePlayerData(target.getUniqueId());
                if (target.isOnline()) {
                    this.plugin.getPlayerCache().updatePlayerXp(target.getUniqueId(), jobId, requiredXp, newLevel);
                }
                this.plugin.getFoliaManager().runNextTick(() -> {
                    this.sendMessage(sender, "level-given", "amount", String.valueOf(levels), "player", target.getName(), "job", job.getName(), "level", String.valueOf(newLevel));
                    if (target.isOnline()) {
                        MessageUtils.sendMessage(target.getPlayer(), this.languageManager.getMessage("commands.admin.level-received", "amount", String.valueOf(levels), "job", job.getName()));
                    }
                });
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Erreur lors de l'ajout de niveau: " + e.getMessage());
                this.plugin.getFoliaManager().runNextTick(() -> this.sendMessage(sender, "level-error", "error", e.getMessage()));
            }
        });
        return true;
    }

    private boolean handleRemoveLevel(CommandSender sender, String playerName, String jobId, int levels) {
        if (!sender.hasPermission("universejobs.admin.setlevel")) {
            this.sendMessage(sender, "no-permission", new String[0]);
            return true;
        }
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)playerName);
        if (target == null) {
            this.sendMessage(sender, "player-not-found", "player", playerName);
            return true;
        }
        Job job = this.jobManager.getJob(jobId);
        if (job == null) {
            this.sendMessage(sender, "job-not-found", "job", jobId);
            return true;
        }
        this.plugin.getFoliaManager().runAsync(() -> {
            try {
                PlayerJobData playerData = this.jobManager.getPlayerData(target.getUniqueId());
                if (!playerData.hasJob(jobId)) {
                    this.plugin.getFoliaManager().runNextTick(() -> this.sendMessage(sender, "player-no-job", "player", target.getName(), "job", job.getName()));
                    return;
                }
                int currentLevel = playerData.getLevel(jobId);
                int newLevel = Math.max(0, currentLevel - levels);
                double requiredXp = this.jobManager.getXpRequiredForLevel(jobId, newLevel);
                playerData.setLevel(jobId, newLevel);
                playerData.setXp(jobId, requiredXp);
                this.jobManager.savePlayerData(target.getUniqueId());
                if (target.isOnline()) {
                    this.plugin.getPlayerCache().updatePlayerXp(target.getUniqueId(), jobId, requiredXp, newLevel);
                }
                this.plugin.getFoliaManager().runNextTick(() -> {
                    this.sendMessage(sender, "level-taken", "amount", String.valueOf(levels), "player", target.getName(), "job", job.getName(), "level", String.valueOf(newLevel));
                    if (target.isOnline()) {
                        MessageUtils.sendMessage(target.getPlayer(), this.languageManager.getMessage("commands.admin.level-lost", "amount", String.valueOf(levels), "job", job.getName()));
                    }
                });
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Erreur lors de la suppression de niveau: " + e.getMessage());
                this.plugin.getFoliaManager().runNextTick(() -> this.sendMessage(sender, "level-error", "error", e.getMessage()));
            }
        });
        return true;
    }

    private boolean handleSetLevel(CommandSender sender, String[] args) {
        if (args.length >= 5) {
            String[] newArgs = new String[]{"admin", "level", "set", args[2], args[3], args[4]};
            return this.handleLevelCommand(sender, newArgs);
        }
        this.sendMessage(sender, "usage.level", new String[0]);
        return true;
    }

    private boolean handleGiveXp(CommandSender sender, String playerName, String jobId, double amount) {
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)playerName);
        if (target == null) {
            this.sendMessage(sender, "player-not-found", "player", playerName);
            return true;
        }
        this.plugin.getFoliaManager().runAsync(() -> {
            try {
                PlayerJobData playerData = this.jobManager.getPlayerData(target.getUniqueId());
                if (!playerData.hasJob(jobId)) {
                    this.sendMessage(sender, "player-no-job", "player", playerName, "job", jobId);
                    return;
                }
                double currentXp = playerData.getXp(jobId);
                playerData.setXp(jobId, currentXp + amount);
                this.jobManager.savePlayerData(target.getUniqueId());
                this.sendMessage(sender, "xp-given", "amount", String.valueOf(amount), "player", playerName, "job", jobId);
                if (target.isOnline()) {
                    Player onlinePlayer = target.getPlayer();
                    MessageUtils.sendMessage(onlinePlayer, this.languageManager.getMessage("commands.admin.xp-received", "amount", String.valueOf(amount), "job", jobId));
                }
            }
            catch (Exception e) {
                this.sendMessage(sender, "xp-error", "error", e.getMessage());
            }
        });
        return true;
    }

    private boolean handleSetXpDirect(CommandSender sender, String playerName, String jobId, double amount) {
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)playerName);
        if (target == null) {
            this.sendMessage(sender, "player-not-found", "player", playerName);
            return true;
        }
        this.plugin.getFoliaManager().runAsync(() -> {
            try {
                PlayerJobData playerData = this.jobManager.getPlayerData(target.getUniqueId());
                if (!playerData.hasJob(jobId)) {
                    this.sendMessage(sender, "player-no-job", "player", playerName, "job", jobId);
                    return;
                }
                playerData.setXp(jobId, amount);
                this.jobManager.savePlayerData(target.getUniqueId());
                this.sendMessage(sender, "xp-set", "amount", String.valueOf(amount), "player", playerName, "job", jobId);
                if (target.isOnline()) {
                    Player onlinePlayer = target.getPlayer();
                    MessageUtils.sendMessage(onlinePlayer, this.languageManager.getMessage("commands.admin.xp-set-notify", "amount", String.valueOf(amount), "job", jobId));
                }
            }
            catch (Exception e) {
                this.sendMessage(sender, "xp-error", "error", e.getMessage());
            }
        });
        return true;
    }

    private boolean handlePlayerInfo(CommandSender sender, String[] args) {
        if (args.length < 3) {
            this.sendMessage(sender, "usage.info", new String[0]);
            return true;
        }
        if (!sender.hasPermission("universejobs.admin.info")) {
            this.sendMessage(sender, "no-permission", new String[0]);
            return true;
        }
        String playerName = args[2];
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)playerName);
        if (target == null) {
            this.sendMessage(sender, "player-not-found", "player", playerName);
            return true;
        }
        this.plugin.getFoliaManager().runAsync(() -> {
            try {
                PlayerJobData playerData = this.jobManager.getPlayerData(target.getUniqueId());
                Set<String> jobs = playerData.getJobs();
                this.plugin.getFoliaManager().runNextTick(() -> {
                    this.sendMessage(sender, "debug-header", "player", target.getName());
                    this.sendMessage(sender, "debug-jobs", "count", String.valueOf(jobs.size()));
                    if (jobs.isEmpty()) {
                        MessageUtils.sendMessage(sender, this.languageManager.getMessage("commands.stats.no-jobs-other", "player", target.getName()));
                    } else {
                        for (String jobId : jobs) {
                            Job job = this.jobManager.getJob(jobId);
                            if (job == null) continue;
                            double xp = playerData.getXp(jobId);
                            int level = playerData.getLevel(jobId);
                            MessageUtils.sendMessage(sender, this.languageManager.getMessage("commands.admin.debug-job-line", "job", job.getName(), "level", String.valueOf(level), "xp", String.format("%.1f", xp)));
                        }
                    }
                    if (target.isOnline()) {
                        Map<String, Object> cacheStats = this.plugin.getPlayerCache().getStats();
                        MessageUtils.sendMessage(sender, this.languageManager.getMessage("commands.admin.cache-stats-hitrate", "rate", String.valueOf(cacheStats.getOrDefault("hit_rate", "N/A"))));
                    }
                });
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Erreur lors de la r\u00e9cup\u00e9ration des infos: " + e.getMessage());
                this.plugin.getFoliaManager().runNextTick(() -> this.sendMessage(sender, "info-error", "error", e.getMessage()));
            }
        });
        return true;
    }

    private boolean handleReload(CommandSender sender, String[] args) {
        if (!sender.hasPermission("universejobs.admin.reload")) {
            this.sendMessage(sender, "no-permission", new String[0]);
            return true;
        }
        this.sendMessage(sender, "reload-start", new String[0]);
        this.plugin.getFoliaManager().runAsync(() -> {
            try {
                this.plugin.getConfigManager().reloadConfig();
                this.plugin.getJobManager().reloadJobs();
                this.plugin.getLanguageManager().reload();
                this.plugin.getMenuManager().reloadConfigurations();
                this.plugin.getRewardManager().reloadRewards();
                this.plugin.getConfigCache().reload();
                this.plugin.getPlayerCache().preloadOnlinePlayers();
                this.plugin.getFoliaManager().runNextTick(() -> this.sendMessage(sender, "reload-success", new String[0]));
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Error during reload: " + e.getMessage());
                this.plugin.getFoliaManager().runNextTick(() -> this.sendMessage(sender, "reload-failed", "error", e.getMessage()));
            }
        });
        return true;
    }

    private void sendAdminHelp(CommandSender sender) {
        MessageUtils.sendMessage(sender, this.languageManager.getMessage("commands.admin.header"));
        MessageUtils.sendMessage(sender, this.languageManager.getMessage("commands.admin.give"));
        MessageUtils.sendMessage(sender, this.languageManager.getMessage("commands.admin.boost"));
        MessageUtils.sendMessage(sender, this.languageManager.getMessage("commands.admin.forcejoin"));
        MessageUtils.sendMessage(sender, this.languageManager.getMessage("commands.admin.forceleave"));
        MessageUtils.sendMessage(sender, this.languageManager.getMessage("commands.admin.reset"));
        MessageUtils.sendMessage(sender, this.languageManager.getMessage("commands.admin.info"));
        MessageUtils.sendMessage(sender, this.languageManager.getMessage("commands.admin.reload"));
    }

    @Override
    public List<String> getTabCompletions(CommandSender sender, String[] args) {
        String giveType;
        String subCommand;
        if (args.length == 2) {
            return Arrays.asList("give", "boost", "forcejoin", "forceleave", "reset", "info", "reload", "migrate");
        }
        if (args.length == 3) {
            subCommand = args[1].toLowerCase();
            if ("give".equals(subCommand)) {
                return Arrays.asList("xp", "level", "custom");
            }
            if (Arrays.asList("forcejoin", "forceleave", "reset", "info").contains(subCommand)) {
                return Bukkit.getOnlinePlayers().stream().map(Player::getName).collect(Collectors.toList());
            }
            if ("migrate".equals(subCommand)) {
                return Arrays.asList("sqlite", "mysql");
            }
            if ("boost".equals(subCommand)) {
                return this.boostHandler.getTabCompletions(sender, args);
            }
        }
        if (args.length > 3 && "boost".equalsIgnoreCase(args[1])) {
            return this.boostHandler.getTabCompletions(sender, args);
        }
        if (args.length == 4) {
            subCommand = args[1].toLowerCase();
            if ("give".equals(subCommand) && ("xp".equals(giveType = args[2].toLowerCase()) || "level".equals(giveType) || "custom".equals(giveType))) {
                return Arrays.asList("give", "set", "remove");
            }
            if (Arrays.asList("forcejoin", "forceleave").contains(subCommand)) {
                return Bukkit.getOnlinePlayers().stream().map(Player::getName).collect(Collectors.toList());
            }
            if ("reset".equals(subCommand)) {
                List<String> options = this.jobManager.getAllJobs().stream().map(Job::getId).collect(Collectors.toList());
                options.add("ALL");
                return options;
            }
        }
        if (args.length == 5) {
            subCommand = args[1].toLowerCase();
            if ("give".equals(subCommand)) {
                return Bukkit.getOnlinePlayers().stream().map(Player::getName).collect(Collectors.toList());
            }
            if (Arrays.asList("forcejoin", "forceleave").contains(subCommand)) {
                return this.jobManager.getAllJobs().stream().map(Job::getId).collect(Collectors.toList());
            }
        }
        if (args.length == 6 && "give".equals(subCommand = args[1].toLowerCase())) {
            return this.jobManager.getAllJobs().stream().map(Job::getId).collect(Collectors.toList());
        }
        if (args.length == 7 && "give".equals(subCommand = args[1].toLowerCase())) {
            giveType = args[2].toLowerCase();
            if ("xp".equals(giveType) || "level".equals(giveType)) {
                return Arrays.asList("100", "500", "1000", "5000", "10000");
            }
            if ("custom".equals(giveType)) {
                return Arrays.asList("0", "10", "50", "100", "500", "1000");
            }
        }
        if (args.length == 8) {
            subCommand = args[1].toLowerCase();
            if ("give".equals(subCommand) && "custom".equals(giveType = args[2].toLowerCase())) {
                return Arrays.asList("0", "10", "50", "100", "500", "1000");
            }
            if ("migrate".equals(subCommand)) {
                return Arrays.asList("sqlite", "mysql");
            }
        }
        return new ArrayList<String>();
    }

    private boolean handleMigrate(CommandSender sender, String[] args) {
        if (args.length < 4) {
            sender.sendMessage("\u00a7cUsage: /jobs admin migrate <old> <new>");
            sender.sendMessage("\u00a7cExample: /jobs admin migrate sqlite mysql");
            return true;
        }
        String oldType = args[2].toLowerCase();
        String newType = args[3].toLowerCase();
        if (!oldType.equals("sqlite") && !oldType.equals("mysql")) {
            sender.sendMessage("\u00a7cInvalid old database type. Use: sqlite or mysql");
            return true;
        }
        if (!newType.equals("sqlite") && !newType.equals("mysql")) {
            sender.sendMessage("\u00a7cInvalid new database type. Use: sqlite or mysql");
            return true;
        }
        if (oldType.equals(newType)) {
            sender.sendMessage("\u00a7cOld and new database types cannot be the same");
            return true;
        }
        sender.sendMessage("\u00a7aStarting database migration from " + oldType + " to " + newType + "...");
        this.plugin.getFoliaManager().runAsync(() -> {
            try {
                if (this.plugin.isDatabaseEnabled()) {
                    DatabaseDataStorage storage = (DatabaseDataStorage)this.plugin.getDataStorage();
                    DataMigrator migrator = new DataMigrator(this.plugin, storage);
                    DataMigrator.MigrationResult result = migrator.migrateAllData().join();
                    this.plugin.getFoliaManager().runNextTick(() -> {
                        if (result.isSuccessful()) {
                            sender.sendMessage("\u00a7aMigration completed successfully!");
                            sender.sendMessage("\u00a7aPlayer data migrated: " + result.playerDataMigrated);
                            sender.sendMessage("\u00a7aReward data migrated: " + result.rewardDataMigrated);
                            sender.sendMessage("\u00a7aTotal records migrated: " + result.getTotalMigrated());
                            migrator.markMigrationComplete();
                        } else {
                            sender.sendMessage("\u00a7cMigration failed: " + result.error);
                        }
                    });
                } else {
                    this.plugin.getFoliaManager().runNextTick(() -> sender.sendMessage("\u00a7cDatabase is not enabled in configuration"));
                }
            }
            catch (Exception e) {
                this.plugin.getFoliaManager().runNextTick(() -> sender.sendMessage("\u00a7cMigration failed: " + e.getMessage()));
                this.plugin.getLogger().log(Level.SEVERE, "Migration failed: " + e.getMessage(), e);
            }
        });
        return true;
    }

    private double applyXpMultipliers(Player player, Job job, double baseXp) {
        if (player == null || job == null || baseXp <= 0.0) {
            return baseXp;
        }
        double multiplier = this.getPermissionMultiplier(player);
        double xpWithPermissions = baseXp * multiplier;
        if (this.plugin.getBonusManager() != null) {
            double bonusMultiplier = this.plugin.getBonusManager().getTotalMultiplier(player.getUniqueId(), job.getId());
            xpWithPermissions *= bonusMultiplier;
        }
        return xpWithPermissions;
    }

    private double applyMoneyMultipliers(Player player, Job job, double baseMoney) {
        if (player == null || job == null || baseMoney <= 0.0) {
            return baseMoney;
        }
        if (this.plugin.getMoneyBonusManager() != null) {
            double moneyBonusMultiplier = this.plugin.getMoneyBonusManager().getTotalMultiplier(player.getUniqueId(), job.getId());
            return baseMoney * moneyBonusMultiplier;
        }
        return baseMoney;
    }

    private double getPermissionMultiplier(Player player) {
        double multiplier = 1.0;
        if (!player.isOp() && !player.hasPermission("*")) {
            for (int i = 10; i >= 1; --i) {
                String permission = "universejobs.multiplier.exp." + i;
                if (!player.hasPermission(permission)) continue;
                multiplier = i;
                break;
            }
        }
        return multiplier;
    }

    private void cleanupExpiredConfirmations() {
        long currentTime = System.currentTimeMillis();
        this.resetConfirmations.entrySet().removeIf(entry -> currentTime - (Long)entry.getValue() > 10000L);
    }
}

