/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.command.handler;

import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.storage.database.DatabaseDataStorage;
import fr.ax_dev.universejobs.storage.migration.DataMigrator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.command.CommandSender;

public class DatabaseCommandHandler {
    private final UniverseJobs plugin;

    public DatabaseCommandHandler(UniverseJobs plugin) {
        this.plugin = plugin;
    }

    public boolean handleDatabaseCommand(CommandSender sender, String[] args) {
        String subCommand;
        if (args.length < 4) {
            sender.sendMessage("\u00a7cUsage: /jobs database migrate <old> <new>");
            sender.sendMessage("\u00a7cExample: /jobs database migrate sqlite mysql");
            return true;
        }
        switch (subCommand = args[1].toLowerCase()) {
            case "migrate": {
                return this.handleMigrateCommand(sender, args);
            }
        }
        sender.sendMessage("\u00a7cUnknown database command: " + subCommand);
        sender.sendMessage("\u00a7cAvailable commands: migrate");
        return true;
    }

    private boolean handleMigrateCommand(CommandSender sender, String[] args) {
        if (args.length < 4) {
            sender.sendMessage("\u00a7cUsage: /jobs database migrate <old> <new>");
            sender.sendMessage("\u00a7cExample: /jobs database migrate sqlite mysql");
            return true;
        }
        String oldType = args[2].toLowerCase();
        String newType = args[3].toLowerCase();
        if (!oldType.equals("sqlite") && !oldType.equals("mysql")) {
            sender.sendMessage("\u00a7cInvalid old database type. Use: sqlite or mysql");
            return true;
        }
        if (!newType.equals("sqlite") && !newType.equals("mysql")) {
            sender.sendMessage("\u00a7cInvalid new database type. Use: sqlite or mysql");
            return true;
        }
        if (oldType.equals(newType)) {
            sender.sendMessage("\u00a7cOld and new database types cannot be the same");
            return true;
        }
        sender.sendMessage("\u00a7aStarting database migration from " + oldType + " to " + newType + "...");
        this.plugin.getFoliaManager().runAsync(() -> {
            try {
                if (this.plugin.isDatabaseEnabled()) {
                    DatabaseDataStorage storage = (DatabaseDataStorage)this.plugin.getDataStorage();
                    DataMigrator migrator = new DataMigrator(this.plugin, storage);
                    DataMigrator.MigrationResult result = migrator.migrateAllData().join();
                    this.plugin.getFoliaManager().runNextTick(() -> {
                        if (result.isSuccessful()) {
                            sender.sendMessage("\u00a7aMigration completed successfully!");
                            sender.sendMessage("\u00a7aPlayer data migrated: " + result.playerDataMigrated);
                            sender.sendMessage("\u00a7aReward data migrated: " + result.rewardDataMigrated);
                            sender.sendMessage("\u00a7aTotal records migrated: " + result.getTotalMigrated());
                            migrator.markMigrationComplete();
                        } else {
                            sender.sendMessage("\u00a7cMigration failed: " + result.error);
                        }
                    });
                } else {
                    this.plugin.getFoliaManager().runNextTick(() -> sender.sendMessage("\u00a7cDatabase is not enabled in configuration"));
                }
            }
            catch (Exception e) {
                this.plugin.getFoliaManager().runNextTick(() -> sender.sendMessage("\u00a7cMigration failed: " + e.getMessage()));
                this.plugin.getLogger().log(Level.SEVERE, "Migration failed: " + e.getMessage(), e);
            }
        });
        return true;
    }

    public List<String> getTabComplete(String[] args) {
        if (args.length == 2) {
            return Collections.singletonList("migrate");
        }
        if (args.length == 3 && args[1].equalsIgnoreCase("migrate")) {
            return Arrays.asList("sqlite", "mysql");
        }
        if (args.length == 4 && args[1].equalsIgnoreCase("migrate")) {
            return Arrays.asList("sqlite", "mysql");
        }
        return Collections.emptyList();
    }
}

