/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.condition.impl;

import fr.ax_dev.universejobs.condition.AbstractCondition;
import fr.ax_dev.universejobs.condition.ConditionContext;
import fr.ax_dev.universejobs.condition.ConditionType;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class WeatherCondition
extends AbstractCondition {
    private final WeatherType requiredWeather;

    public WeatherCondition(ConfigurationSection config) {
        super(config);
        WeatherType tempWeather;
        String weatherStr = config.getString("weather", "CLEAR");
        try {
            tempWeather = WeatherType.valueOf(weatherStr.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            tempWeather = WeatherType.CLEAR;
        }
        this.requiredWeather = tempWeather;
    }

    @Override
    public boolean isMet(Player player, Event event, ConditionContext context) {
        WeatherType currentWeather = this.getCurrentWeather(player);
        return currentWeather == this.requiredWeather;
    }

    private WeatherType getCurrentWeather(Player player) {
        if (player.getWorld().isThundering()) {
            return WeatherType.THUNDER;
        }
        if (player.getWorld().hasStorm()) {
            return WeatherType.RAIN;
        }
        return WeatherType.CLEAR;
    }

    @Override
    public ConditionType getType() {
        return ConditionType.WEATHER;
    }

    public String toString() {
        return "WeatherCondition{requiredWeather=" + String.valueOf((Object)this.requiredWeather) + "}";
    }

    public static enum WeatherType {
        CLEAR,
        RAIN,
        THUNDER;

    }
}

