/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.config;

import org.bukkit.configuration.ConfigurationSection;

public class ProgressBarConfig {
    private final int length;
    private final String completedChar;
    private final String remainingChar;
    private final String completedColor;
    private final String remainingColor;
    private final String percentageColor;
    private final String withPercentageFormat;
    private final String barOnlyFormat;
    private final String percentageOnlyFormat;

    public ProgressBarConfig(ConfigurationSection config) {
        this.length = config.getInt("length", 20);
        this.completedChar = config.getString("characters.completed", "\u2588");
        this.remainingChar = config.getString("characters.remaining", "\u2591");
        this.completedColor = config.getString("colors.completed", "<#32CD32>");
        this.remainingColor = config.getString("colors.remaining", "<#404040>");
        this.percentageColor = config.getString("colors.percentage", "<#FFD700>");
        this.withPercentageFormat = config.getString("format.with-percentage", "{completed_bar}{remaining_bar} {percentage_color}{percentage}%");
        this.barOnlyFormat = config.getString("format.bar-only", "{completed_bar}{remaining_bar}");
        this.percentageOnlyFormat = config.getString("format.percentage-only", "{percentage_color}{percentage}%");
    }

    public String generateProgressBar(double currentXp, double requiredXp, boolean includePercentage) {
        double percentage = Math.min(currentXp / requiredXp * 100.0, 100.0);
        int completedLength = (int)Math.round(percentage / 100.0 * (double)this.length);
        int remainingLength = this.length - completedLength;
        String completedBar = this.completedColor + this.completedChar.repeat(Math.max(0, completedLength));
        String remainingBar = this.remainingColor + this.remainingChar.repeat(Math.max(0, remainingLength));
        String format = includePercentage ? this.withPercentageFormat : this.barOnlyFormat;
        return format.replace("{completed_bar}", completedBar).replace("{remaining_bar}", remainingBar).replace("{percentage_color}", this.percentageColor).replace("{percentage}", String.valueOf((int)Math.round(percentage)));
    }

    public String generatePercentageOnly(double currentXp, double requiredXp) {
        double percentage = Math.min(currentXp / requiredXp * 100.0, 100.0);
        return this.percentageOnlyFormat.replace("{percentage_color}", this.percentageColor).replace("{percentage}", String.valueOf((int)Math.round(percentage)));
    }

    public int getLength() {
        return this.length;
    }

    public String getCompletedChar() {
        return this.completedChar;
    }

    public String getRemainingChar() {
        return this.remainingChar;
    }

    public String getCompletedColor() {
        return this.completedColor;
    }

    public String getRemainingColor() {
        return this.remainingColor;
    }

    public String getPercentageColor() {
        return this.percentageColor;
    }

    public String getWithPercentageFormat() {
        return this.withPercentageFormat;
    }

    public String getBarOnlyFormat() {
        return this.barOnlyFormat;
    }

    public String getPercentageOnlyFormat() {
        return this.percentageOnlyFormat;
    }
}

