/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.listener;

import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.action.ActionProcessor;
import fr.ax_dev.universejobs.action.ActionType;
import fr.ax_dev.universejobs.condition.ConditionContext;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.enchantment.EnchantItemEvent;

public class EnchantEventListener
implements Listener {
    private final UniverseJobs plugin;
    private final ActionProcessor actionProcessor;

    public EnchantEventListener(UniverseJobs plugin, ActionProcessor actionProcessor) {
        this.plugin = plugin;
        this.actionProcessor = actionProcessor;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEnchantItem(EnchantItemEvent event) {
        Player player = event.getEnchanter();
        if (this.plugin.getConfigManager().isDebugEnabled()) {
            this.plugin.getLogger().info("EnchantItemEvent: " + player.getName() + " enchanting " + String.valueOf(event.getItem().getType()) + " with " + event.getEnchantsToAdd().size() + " enchantments");
        }
        int processedEnchantments = 0;
        for (Enchantment enchantment : event.getEnchantsToAdd().keySet()) {
            int level = (Integer)event.getEnchantsToAdd().get(enchantment);
            String enchantmentKey = this.getEnchantmentKey(enchantment);
            ConditionContext context = new ConditionContext().set("target", enchantmentKey).set("enchantment", enchantmentKey).set("enchantment_level", String.valueOf(level)).set("item_type", event.getItem().getType().name()).set("experience_cost", String.valueOf(event.getExpLevelCost())).set("suppress_message", "true");
            if (this.plugin.getConfigManager().isDebugEnabled()) {
                this.plugin.getLogger().info("Processing enchantment: " + enchantmentKey + " level " + level);
            }
            this.actionProcessor.processAction(player, ActionType.ENCHANT, (Event)event, context);
            ++processedEnchantments;
        }
        if (this.plugin.getConfigManager().isDebugEnabled() && processedEnchantments > 0) {
            this.plugin.getLogger().info("Processed " + processedEnchantments + " enchantments for " + player.getName());
        }
    }

    private String getEnchantmentKey(Enchantment enchantment) {
        block7: {
            try {
                if (enchantment.getKey() != null) {
                    return enchantment.getKey().toString();
                }
            }
            catch (Exception | NoSuchMethodError throwable) {
                // empty catch block
            }
            try {
                String name = enchantment.getName();
                if (name != null) {
                    Object key = name.toLowerCase();
                    if (!((String)key).contains(":")) {
                        key = "minecraft:" + (String)key;
                    }
                    return key;
                }
            }
            catch (Exception e) {
                if (!this.plugin.getConfigManager().isDebugEnabled()) break block7;
                this.plugin.getLogger().warning("Failed to get enchantment name: " + e.getMessage());
            }
        }
        return "minecraft:unknown";
    }
}

