/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.menu.impl;

import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.action.ActionType;
import fr.ax_dev.universejobs.config.LanguageManager;
import fr.ax_dev.universejobs.config.ProgressBarConfig;
import fr.ax_dev.universejobs.job.Job;
import fr.ax_dev.universejobs.job.PlayerJobData;
import fr.ax_dev.universejobs.menu.BaseMenu;
import fr.ax_dev.universejobs.menu.config.MenuItemConfig;
import fr.ax_dev.universejobs.menu.config.SimpleConfigurationSection;
import fr.ax_dev.universejobs.menu.config.SingleMenuConfig;
import fr.ax_dev.universejobs.menu.utils.MenuItemUtils;
import fr.ax_dev.universejobs.utils.MessageUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class SingleJobMenu
extends BaseMenu {
    private static final int DEFAULT_PROGRESS_BARS = 20;
    private final Job job;
    private final PlayerJobData playerData;
    private final Map<String, String> cachedPlaceholders;
    private final LanguageManager languageManager;
    private boolean hasJob;

    public SingleJobMenu(UniverseJobs plugin, Player player, String jobId, SingleMenuConfig config) {
        super(plugin, player, config);
        this.job = plugin.getJobManager().getJob(jobId);
        if (this.job == null) {
            throw new IllegalArgumentException("Job not found: " + jobId);
        }
        this.playerData = plugin.getJobManager().getPlayerData(player.getUniqueId());
        this.languageManager = plugin.getLanguageManager();
        this.hasJob = this.playerData.hasJob(jobId);
        this.cachedPlaceholders = new HashMap<String, String>();
        this.cachedPlaceholders.putAll(this.createJobPlaceholders());
        this.initialize();
    }

    @Override
    protected void createInventory() {
        String title = this.config.getTitle();
        for (Map.Entry<String, String> entry : this.cachedPlaceholders.entrySet()) {
            title = title.replace(entry.getKey(), entry.getValue());
        }
        title = this.processPlaceholders(title);
        Component titleComponent = MessageUtils.parseMessage(title);
        this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)this.config.getSize(), (Component)titleComponent);
    }

    @Override
    protected void populateInventory() {
        if (this.job == null) {
            return;
        }
        this.inventory.clear();
        this.populateJobInformation();
        this.populateActionButtons();
        this.populateNavigationItems();
        this.addStaticItems();
        this.addFillItems();
    }

    private void populateJobInformation() {
        MenuItemConfig playerStatsConfig;
        Map<String, MenuItemConfig> menuItems = this.loadMenuItemsFromConfig();
        MenuItemConfig jobInfoConfig = menuItems.get("job-info");
        if (jobInfoConfig != null && jobInfoConfig.isEnabled()) {
            ItemStack jobInfo = this.createMenuItem(jobInfoConfig, this.cachedPlaceholders);
            this.placeItemInSlots(jobInfo, jobInfoConfig.getSlots());
        }
        if ((playerStatsConfig = menuItems.get("player-stats")) != null && playerStatsConfig.isEnabled()) {
            ItemStack playerStats = this.createMenuItem(playerStatsConfig, this.cachedPlaceholders);
            this.placeItemInSlots(playerStats, playerStatsConfig.getSlots());
        }
    }

    private void populateActionButtons() {
        MenuItemConfig rankingsConfig;
        MenuItemConfig rewardsConfig;
        MenuItemConfig actionsConfig;
        Map<String, MenuItemConfig> menuItems = this.loadMenuItemsFromConfig();
        MenuItemConfig joinLeaveConfig = menuItems.get("join-leave-button");
        if (joinLeaveConfig != null && joinLeaveConfig.isEnabled()) {
            ItemStack button = this.createJoinLeaveButton(joinLeaveConfig);
            this.placeItemInSlots(button, joinLeaveConfig.getSlots());
        }
        if ((actionsConfig = menuItems.get("actions-button")) != null && actionsConfig.isEnabled()) {
            ItemStack button = this.createMenuItem(actionsConfig, this.cachedPlaceholders);
            this.placeItemInSlots(button, actionsConfig.getSlots());
        }
        if ((rewardsConfig = menuItems.get("rewards-button")) != null && rewardsConfig.isEnabled()) {
            ItemStack button = this.createMenuItem(rewardsConfig, this.cachedPlaceholders);
            this.placeItemInSlots(button, rewardsConfig.getSlots());
        }
        if ((rankingsConfig = menuItems.get("rankings-button")) != null && rankingsConfig.isEnabled()) {
            ItemStack button = this.createMenuItem(rankingsConfig, this.cachedPlaceholders);
            this.placeItemInSlots(button, rankingsConfig.getSlots());
        }
    }

    public Job getJob() {
        return this.job;
    }

    private void populateNavigationItems() {
        Map<String, MenuItemConfig> navItems = this.config.getNavigationItems();
        for (Map.Entry<String, MenuItemConfig> entry : navItems.entrySet()) {
            MenuItemConfig navConfig = entry.getValue();
            if (!navConfig.isEnabled()) continue;
            ItemStack navItem = this.createMenuItem(navConfig, this.cachedPlaceholders);
            this.placeItemInSlots(navItem, navConfig.getSlots());
        }
    }

    private ItemStack createJoinLeaveButton(MenuItemConfig baseConfig) {
        if (!this.hasJob) {
            return this.createMenuItem(baseConfig, this.cachedPlaceholders);
        }
        if (baseConfig.hasElseConfiguration()) {
            HashMap<String, Object> leaveConfig = new HashMap<String, Object>();
            leaveConfig.put("enabled", true);
            leaveConfig.put("material", baseConfig.getElseMaterial());
            leaveConfig.put("display-name", baseConfig.getElseDisplayName());
            leaveConfig.put("lore", baseConfig.getElseLore());
            leaveConfig.put("amount", baseConfig.getAmount());
            leaveConfig.put("custom-model-data", baseConfig.getElseCustomModelData());
            leaveConfig.put("glow", baseConfig.isGlow());
            leaveConfig.put("hide-attributes", baseConfig.isHideAttributes());
            leaveConfig.put("hide-enchants", baseConfig.isHideEnchants());
            leaveConfig.put("slots", baseConfig.getSlots());
            leaveConfig.put("action", baseConfig.getAction());
            MenuItemConfig leaveItemConfig = new MenuItemConfig((ConfigurationSection)new SimpleConfigurationSection(leaveConfig));
            return this.createMenuItem(leaveItemConfig, this.cachedPlaceholders);
        }
        return this.createMenuItem(baseConfig, this.cachedPlaceholders);
    }

    private void placeItemInSlots(ItemStack item, List<Integer> slots) {
        if (item == null || slots == null) {
            return;
        }
        for (int slot : slots) {
            if (slot < 0 || slot >= this.inventory.getSize()) continue;
            this.inventory.setItem(slot, item);
        }
    }

    private void addStaticItems() {
        MenuItemUtils.addStaticItems(this.inventory, this.config.getStaticItems(), this.cachedPlaceholders, config -> this.createMenuItem((MenuItemConfig)config, this.cachedPlaceholders));
    }

    @Override
    public void handleClick(int slot, InventoryClickEvent event) {
        event.setCancelled(true);
        if (this.handleNavigationClickWithSound(slot)) {
            return;
        }
        MenuItemConfig clickedItem = this.getMenuItemForSlot(slot);
        if (clickedItem != null) {
            String action;
            if (clickedItem.getCommands() != null && !clickedItem.getCommands().isEmpty()) {
                this.executeCommands(clickedItem.getCommands());
            }
            switch (action = clickedItem.getAction()) {
                case "toggle-job": {
                    this.handleJoinLeave();
                    break;
                }
                case "open-actions": {
                    this.plugin.getMenuManager().openJobActionsMenu(this.player, this.job.getId());
                    break;
                }
                case "open-rewards": {
                    this.plugin.getMenuManager().openRewardsMenu(this.player, this.job.getId());
                    break;
                }
                case "open-rankings": {
                    this.plugin.getMenuManager().openGlobalRankingsMenu(this.player);
                    break;
                }
                case "back": {
                    this.plugin.getMenuManager().openJobsMainMenu(this.player);
                    break;
                }
                case "close": {
                    this.close();
                }
            }
        }
    }

    private MenuItemConfig getMenuItemForSlot(int slot) {
        MenuItemConfig itemConfig;
        for (Map.Entry<String, MenuItemConfig> entry : this.config.getMenuItems().entrySet()) {
            itemConfig = entry.getValue();
            if (!itemConfig.getSlots().contains(slot)) continue;
            return itemConfig;
        }
        for (Map.Entry<String, MenuItemConfig> entry : this.config.getNavigationItems().entrySet()) {
            itemConfig = entry.getValue();
            if (!itemConfig.getSlots().contains(slot)) continue;
            return itemConfig;
        }
        return null;
    }

    private void handleJoinLeave() {
        if (this.hasJob) {
            this.handleLeaveJob();
        } else {
            this.handleJoinJob();
        }
    }

    private void handleLeaveJob() {
        if (this.plugin.getJobManager().leaveJob(this.player, this.job.getId())) {
            MessageUtils.sendMessage(this.player, this.languageManager.getMessage("commands.leave.success", "job", this.job.getName()));
            this.hasJob = false;
            this.updatePlaceholdersAndRefresh();
        } else {
            MessageUtils.sendMessage(this.player, this.languageManager.getMessage("commands.leave.failed", "job", this.job.getName()));
        }
    }

    private void handleJoinJob() {
        if (!this.validateJobJoinRequirements()) {
            return;
        }
        if (this.plugin.getJobManager().joinJob(this.player, this.job.getId())) {
            MessageUtils.sendMessage(this.player, this.languageManager.getMessage("commands.join.success", "job", this.job.getName()));
            this.hasJob = true;
            this.updatePlaceholdersAndRefresh();
        } else {
            MessageUtils.sendMessage(this.player, this.languageManager.getMessage("commands.join.failed", "job", this.job.getName()));
        }
    }

    private boolean validateJobJoinRequirements() {
        if (this.job.getPermission() != null && !this.player.hasPermission(this.job.getPermission())) {
            MessageUtils.sendMessage(this.player, this.languageManager.getMessage("commands.join.no-permission", "job", this.job.getName()));
            return false;
        }
        int maxJobs = this.calculateMaxJobsForPlayer();
        int currentJobs = this.playerData.getJobs().size();
        if (currentJobs >= maxJobs) {
            MessageUtils.sendMessage(this.player, this.languageManager.getMessage("commands.join.max-jobs-reached", "max", String.valueOf(maxJobs)));
            return false;
        }
        return true;
    }

    private int calculateMaxJobsForPlayer() {
        return this.plugin.getConfigManager().getMaxJobsPerPlayer();
    }

    private void updatePlaceholdersAndRefresh() {
        this.cachedPlaceholders.clear();
        this.cachedPlaceholders.putAll(this.createJobPlaceholders());
        this.refresh();
    }

    @Override
    protected boolean hasNextPage() {
        return false;
    }

    @Override
    protected void handleBackButton() {
        this.plugin.getMenuManager().openJobsMainMenu(this.player);
    }

    private String createProgressBar(double progress) {
        ProgressBarConfig progressBarConfig = this.plugin.getAccessor().getConfigManager().getProgressBarConfig();
        if (progressBarConfig != null) {
            return progressBarConfig.generateProgressBar(progress * 100.0, 100.0, true);
        }
        int filled = (int)Math.round(progress * 20.0);
        StringBuilder progressBar = new StringBuilder("&a");
        for (int i = 0; i < 20; ++i) {
            progressBar.append(i < filled ? "\u2588" : "&7\u2588");
        }
        progressBar.append(" &f").append(String.format("%.1f", progress * 100.0)).append("%");
        return progressBar.toString();
    }

    private Map<String, MenuItemConfig> loadMenuItemsFromConfig() {
        Map<String, MenuItemConfig> configItems = this.config.getMenuItems();
        if (!configItems.isEmpty()) {
            return configItems;
        }
        HashMap<String, MenuItemConfig> items = new HashMap<String, MenuItemConfig>();
        try {
            HashMap<String, Object> jobInfoData = new HashMap<String, Object>();
            jobInfoData.put("enabled", true);
            jobInfoData.put("material", "PAPER");
            jobInfoData.put("slots", Arrays.asList(10));
            items.put("job-info", new MenuItemConfig((ConfigurationSection)new SimpleConfigurationSection(jobInfoData)));
            HashMap<String, Object> playerStatsData = new HashMap<String, Object>();
            playerStatsData.put("enabled", true);
            playerStatsData.put("material", "PLAYER_HEAD");
            playerStatsData.put("slots", Arrays.asList(12));
            items.put("player-stats", new MenuItemConfig((ConfigurationSection)new SimpleConfigurationSection(playerStatsData)));
            HashMap<String, Object> joinLeaveData = new HashMap<String, Object>();
            joinLeaveData.put("enabled", true);
            joinLeaveData.put("material", "EMERALD_BLOCK");
            joinLeaveData.put("slots", Arrays.asList(14));
            items.put("join-leave-button", new MenuItemConfig((ConfigurationSection)new SimpleConfigurationSection(joinLeaveData)));
            HashMap<String, Object> actionsData = new HashMap<String, Object>();
            actionsData.put("enabled", true);
            actionsData.put("material", "DIAMOND_SWORD");
            actionsData.put("slots", Arrays.asList(15));
            items.put("actions-button", new MenuItemConfig((ConfigurationSection)new SimpleConfigurationSection(actionsData)));
            HashMap<String, Object> rewardsData = new HashMap<String, Object>();
            rewardsData.put("enabled", true);
            rewardsData.put("material", "EMERALD");
            rewardsData.put("slots", Arrays.asList(17));
            items.put("rewards-button", new MenuItemConfig((ConfigurationSection)new SimpleConfigurationSection(rewardsData)));
            HashMap<String, Object> rankingsData = new HashMap<String, Object>();
            rankingsData.put("enabled", true);
            rankingsData.put("material", "GOLD_INGOT");
            rankingsData.put("slots", Arrays.asList(18));
            items.put("rankings-button", new MenuItemConfig((ConfigurationSection)new SimpleConfigurationSection(rankingsData)));
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to load menu items configuration: " + e.getMessage());
        }
        return items;
    }

    private Map<String, String> createJobPlaceholders() {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        this.addJobPlaceholders(placeholders);
        this.addPlayerPlaceholders(placeholders);
        this.addStatisticsPlaceholders(placeholders);
        return placeholders;
    }

    private void addJobPlaceholders(Map<String, String> placeholders) {
        placeholders.put("{job_id}", this.job.getId());
        placeholders.put("{job_name}", this.job.getDisplayName());
        placeholders.put("{job_description}", this.job.getDescription());
        placeholders.put("{job_description_lines}", String.join((CharSequence)"\n", this.job.getDescriptionLines()));
        placeholders.put("{job_max_level}", String.valueOf(this.job.getMaxLevel()));
        placeholders.put("{job_permission}", this.job.getPermission() != null ? this.job.getPermission() : "none");
    }

    private void addPlayerPlaceholders(Map<String, String> placeholders) {
        placeholders.put("{player_name}", this.player.getName());
        placeholders.put("{job_status}", this.plugin.getConfigManager().getJobStatus(this.hasJob));
        placeholders.put("{max_jobs}", String.valueOf(this.plugin.getConfigManager().getMaxJobsPerPlayer()));
        if (this.hasJob) {
            int playerLevel = this.playerData.getLevel(this.job.getId());
            long playerXp = (long)this.playerData.getXp(this.job.getId());
            placeholders.put("{player_level}", String.valueOf(playerLevel));
            placeholders.put("{player_xp}", String.valueOf(playerXp));
            this.calculateAndAddProgressPlaceholders(placeholders, playerLevel, playerXp);
        } else {
            this.addDefaultProgressPlaceholders(placeholders);
        }
    }

    private void calculateAndAddProgressPlaceholders(Map<String, String> placeholders, int playerLevel, long playerXp) {
        if (playerLevel < this.job.getMaxLevel() && this.job.getXpCurve() != null) {
            long nextLevelXp = (long)this.job.getXpCurve().getXpForLevel(playerLevel + 1);
            long xpToNext = Math.max(0L, nextLevelXp - playerXp);
            double progress = Math.min(1.0, (double)playerXp / (double)nextLevelXp);
            placeholders.put("{xp_to_next}", String.valueOf(xpToNext));
            placeholders.put("{next_level_xp}", String.valueOf(nextLevelXp));
            placeholders.put("{progress_percent}", String.format("%.1f", progress * 100.0));
            placeholders.put("{progress_bar}", this.createProgressBar(progress));
        } else {
            this.addDefaultProgressPlaceholders(placeholders);
            placeholders.put("{progress_percent}", "100.0");
            placeholders.put("{progress_bar}", this.createProgressBar(1.0));
        }
    }

    private void addDefaultProgressPlaceholders(Map<String, String> placeholders) {
        placeholders.put("{player_level}", "0");
        placeholders.put("{player_xp}", "0");
        placeholders.put("{xp_to_next}", "0");
        placeholders.put("{next_level_xp}", "0");
        placeholders.put("{progress_percent}", "0.0");
        placeholders.put("{progress_bar}", this.createProgressBar(0.0));
    }

    private String calculatePlayerRank() {
        if (!this.hasJob) {
            return "N/A";
        }
        List<RankingEntry> rankings = this.getJobRankings();
        for (int i = 0; i < rankings.size(); ++i) {
            if (!rankings.get((int)i).playerUuid.equals(this.player.getUniqueId())) continue;
            return "" + (i + 1);
        }
        return "N/A";
    }

    private String getTopPlayerForJob() {
        List<RankingEntry> rankings = this.getJobRankings();
        if (!rankings.isEmpty()) {
            return rankings.get((int)0).playerName;
        }
        return "N/A";
    }

    private List<RankingEntry> getJobRankings() {
        ArrayList<RankingEntry> entries = new ArrayList<RankingEntry>();
        File dataFolder = new File(this.plugin.getDataFolder(), "data");
        if (!dataFolder.exists()) {
            return entries;
        }
        File[] dataFiles = dataFolder.listFiles((dir, name) -> name.endsWith(".yml"));
        if (dataFiles == null) {
            return entries;
        }
        for (File dataFile : dataFiles) {
            try {
                String uuidString = dataFile.getName().replace(".yml", "");
                UUID playerUuid = UUID.fromString(uuidString);
                PlayerJobData data = this.plugin.getJobManager().getPlayerData(playerUuid);
                if (!data.hasJob(this.job.getId())) continue;
                OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)playerUuid);
                String playerName = offlinePlayer.getName();
                if (playerName == null) {
                    playerName = "Unknown";
                }
                double xp = data.getXp(this.job.getId());
                int level = data.getLevel(this.job.getId());
                entries.add(new RankingEntry(playerUuid, playerName, level, xp));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        entries.sort((a, b) -> {
            int levelCompare = Integer.compare(b.level, a.level);
            if (levelCompare != 0) {
                return levelCompare;
            }
            return Double.compare(b.xp, a.xp);
        });
        return entries;
    }

    private void addStatisticsPlaceholders(Map<String, String> placeholders) {
        int totalActions = this.job.getActionTypes().stream().mapToInt(type -> this.job.getActions((ActionType)((Object)type)).size()).sum();
        placeholders.put("{total_actions}", String.valueOf(totalActions));
        int totalRewards = this.plugin.getRewardManager() != null ? this.plugin.getRewardManager().getJobRewards(this.job.getId()).size() : 0;
        placeholders.put("{total_rewards}", String.valueOf(totalRewards));
        String playerRank = this.calculatePlayerRank();
        placeholders.put("{player_rank}", playerRank);
        String topPlayer = this.getTopPlayerForJob();
        placeholders.put("{top_player}", topPlayer);
    }

    private static class RankingEntry {
        final UUID playerUuid;
        final String playerName;
        final int level;
        final double xp;

        RankingEntry(UUID playerUuid, String playerName, int level, double xp) {
            this.playerUuid = playerUuid;
            this.playerName = playerName;
            this.level = level;
            this.xp = xp;
        }
    }
}

