/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.protection;

import com.nexomc.nexo.api.NexoBlocks;
import com.nexomc.nexo.mechanics.custom_block.CustomBlockMechanic;
import fr.ax_dev.universejobs.UniverseJobs;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class BlockProtectionManager {
    private static final String BLOCK_PREFIX = "block_";
    private final UniverseJobs plugin;
    private boolean enabled;
    private boolean nexoEnabled;
    private List<String> blacklist;

    public BlockProtectionManager(UniverseJobs plugin) {
        this.plugin = plugin;
        new NamespacedKey((Plugin)plugin, "player_placed");
        this.loadConfiguration();
        this.checkNexoCompatibility();
    }

    private void loadConfiguration() {
        this.enabled = this.plugin.getConfig().getBoolean("block-protection.enabled", true);
        this.blacklist = this.plugin.getConfig().getStringList("block-protection.blacklist");
    }

    public void reloadConfig() {
        this.loadConfiguration();
        this.checkNexoCompatibility();
    }

    private void checkNexoCompatibility() {
        this.nexoEnabled = this.plugin.getServer().getPluginManager().isPluginEnabled("Nexo");
        if (this.nexoEnabled && this.plugin.getConfigManager().isDebugEnabled()) {
            this.plugin.getLogger().info("Nexo plugin detected - custom blocks will be tracked for anti-exploit protection");
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void recordBlockPlacement(Player player, Block block) {
        if (!this.enabled) {
            if (this.plugin.getConfigManager().isDebugEnabled()) {
                this.plugin.getLogger().info("Block protection disabled - not tracking block placement by " + player.getName() + " at " + String.valueOf(block.getLocation()));
            }
            return;
        }
        try {
            String nexoBlockId;
            NamespacedKey blockKey = new NamespacedKey((Plugin)this.plugin, BLOCK_PREFIX + block.getX() + "_" + block.getY() + "_" + block.getZ());
            Object playerData = player.getUniqueId().toString();
            if (this.nexoEnabled && (nexoBlockId = this.getNexoBlockId(block)) != null) {
                playerData = (String)playerData + "|NEXO:" + nexoBlockId;
                if (this.plugin.getConfigManager().isDebugEnabled()) {
                    this.plugin.getLogger().info("Detected Nexo custom block: " + nexoBlockId + " at " + String.valueOf(block.getLocation()));
                }
            }
            block.getChunk().getPersistentDataContainer().set(blockKey, PersistentDataType.STRING, playerData);
            if (this.plugin.getConfigManager().isDebugEnabled()) {
                this.plugin.getLogger().info("\u2705 TRACKED block placement by " + player.getName() + " at " + String.valueOf(block.getLocation()));
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to mark block as player-placed", e);
        }
    }

    public boolean isPlayerPlacedBlock(Block block) {
        if (!this.enabled) {
            if (this.plugin.getConfigManager().isDebugEnabled()) {
                this.plugin.getLogger().info("Block protection disabled - allowing XP for block at " + String.valueOf(block.getLocation()));
            }
            return false;
        }
        String blockType = block.getType().name();
        if (this.blacklist != null && this.blacklist.contains(blockType)) {
            if (this.plugin.getConfigManager().isDebugEnabled()) {
                this.plugin.getLogger().info("Block type " + blockType + " is blacklisted - allowing XP");
            }
            return false;
        }
        try {
            NamespacedKey blockKey = new NamespacedKey((Plugin)this.plugin, BLOCK_PREFIX + block.getX() + "_" + block.getY() + "_" + block.getZ());
            String placedBy = (String)block.getChunk().getPersistentDataContainer().get(blockKey, PersistentDataType.STRING);
            if (placedBy != null) {
                if (this.plugin.getConfigManager().isDebugEnabled()) {
                    this.plugin.getLogger().info("Block at " + String.valueOf(block.getLocation()) + " was placed by: " + placedBy + " - blocking XP");
                }
                return true;
            }
            if (this.plugin.getConfigManager().isDebugEnabled()) {
                this.plugin.getLogger().info("Block at " + String.valueOf(block.getLocation()) + " is natural - allowing XP");
            }
            return false;
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to check if block is player-placed", e);
            return false;
        }
    }

    public void removeTrackedBlock(Block block) {
        if (!this.enabled) {
            return;
        }
        try {
            NamespacedKey blockKey = new NamespacedKey((Plugin)this.plugin, BLOCK_PREFIX + block.getX() + "_" + block.getY() + "_" + block.getZ());
            block.getChunk().getPersistentDataContainer().remove(blockKey);
            if (this.plugin.getConfigManager().isDebugEnabled()) {
                this.plugin.getLogger().info("Removed player-placed tag from block at " + String.valueOf(block.getLocation()));
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to remove block tracking", e);
        }
    }

    private String getNexoBlockId(Block block) {
        if (!this.nexoEnabled) {
            return null;
        }
        try {
            CustomBlockMechanic mechanic = NexoBlocks.customBlockMechanic((Location)block.getLocation());
            return mechanic != null ? mechanic.getItemID() : null;
        }
        catch (Exception e) {
            if (this.plugin.getConfigManager().isDebugEnabled()) {
                this.plugin.getLogger().warning("Failed to check Nexo block ID: " + e.getMessage());
            }
            return null;
        }
    }
}

