/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.reward;

import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.condition.ConditionContext;
import fr.ax_dev.universejobs.condition.ConditionResult;
import fr.ax_dev.universejobs.config.LanguageManager;
import fr.ax_dev.universejobs.job.Job;
import fr.ax_dev.universejobs.menu.MenuUtils;
import fr.ax_dev.universejobs.reward.Reward;
import fr.ax_dev.universejobs.reward.RewardStatus;
import fr.ax_dev.universejobs.reward.gui.GuiConfig;
import fr.ax_dev.universejobs.reward.gui.GuiConfigLoader;
import fr.ax_dev.universejobs.reward.gui.ItemBuilder;
import fr.ax_dev.universejobs.reward.storage.RewardStorage;
import fr.ax_dev.universejobs.utils.MessageUtils;
import java.io.File;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class RewardManager {
    private final UniverseJobs plugin;
    private final LanguageManager languageManager;
    private final RewardStorage storage;
    private final Map<String, List<Reward>> jobRewards;
    private final Map<String, Reward> allRewards;
    private final GuiConfigLoader guiConfigLoader;

    public RewardManager(UniverseJobs plugin) {
        this.plugin = plugin;
        this.languageManager = plugin.getLanguageManager();
        this.jobRewards = new ConcurrentHashMap<String, List<Reward>>();
        this.allRewards = new ConcurrentHashMap<String, Reward>();
        this.guiConfigLoader = new GuiConfigLoader(plugin);
        this.storage = plugin.getDataStorage();
    }

    public void initialize() {
        this.storage.initialize();
        this.loadRewards();
        this.guiConfigLoader.loadGuiConfigs();
    }

    public void shutdown() {
        this.storage.shutdown();
        this.jobRewards.clear();
        this.allRewards.clear();
        this.plugin.getLogger().info("Reward system shutdown complete");
    }

    public void loadRewards() {
        this.jobRewards.clear();
        this.allRewards.clear();
        File rewardsFolder = new File(this.plugin.getDataFolder(), "rewards");
        if (!rewardsFolder.exists()) {
            if (rewardsFolder.mkdirs()) {
                this.createDefaultRewardFiles();
            } else {
                this.plugin.getLogger().severe("Failed to create rewards folder: " + rewardsFolder.getPath());
                return;
            }
        }
        HashSet<CallSite> processedFiles = new HashSet<CallSite>();
        for (Job job : this.plugin.getJobManager().getAllJobs()) {
            String rewardsFileName = job.getRewardsFile();
            if (rewardsFileName == null || rewardsFileName.isEmpty()) continue;
            File rewardFile = new File(rewardsFolder, rewardsFileName + ".yml");
            if (rewardFile.exists()) {
                this.loadRewardFileForJob(rewardFile, job.getId());
                processedFiles.add((CallSite)((Object)(rewardsFileName + ".yml")));
                continue;
            }
            this.plugin.getLogger().warning("Job '" + job.getId() + "' specifies rewards '" + rewardsFileName + "' but file " + rewardFile.getName() + " does not exist");
        }
        File[] files = rewardsFolder.listFiles((dir, name) -> name.endsWith(".yml"));
        if (files != null) {
            for (File file : files) {
                if (processedFiles.contains(file.getName())) continue;
                this.loadRewardFile(file);
            }
        }
    }

    private void loadRewardFileForJob(File file, String jobId) {
        try {
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
            Job job = this.plugin.getJobManager().getJob(jobId);
            if (job == null) {
                this.plugin.getLogger().warning("Reward file " + file.getName() + " references unknown job: " + jobId);
                return;
            }
            ArrayList<Reward> rewards = new ArrayList<Reward>();
            ConfigurationSection rewardsSection = config.getConfigurationSection("rewards");
            if (rewardsSection != null) {
                for (String rewardId : rewardsSection.getKeys(false)) {
                    ConfigurationSection rewardConfig = rewardsSection.getConfigurationSection(rewardId);
                    if (rewardConfig == null) continue;
                    try {
                        Reward reward = new Reward(rewardId, jobId, rewardConfig);
                        rewards.add(reward);
                        this.allRewards.put(jobId + ":" + rewardId, reward);
                    }
                    catch (Exception e) {
                        this.plugin.getLogger().warning("Failed to load reward " + rewardId + " from file " + file.getName() + ": " + e.getMessage());
                    }
                }
            }
            this.jobRewards.put(jobId, rewards);
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Failed to load reward file " + file.getName() + ": " + e.getMessage());
        }
    }

    private void loadRewardFile(File file) {
        String jobId = file.getName().replace(".yml", "");
        this.loadRewardFileForJob(file, jobId);
    }

    public List<Reward> getJobRewards(String jobId) {
        return new ArrayList<Reward>(this.jobRewards.getOrDefault(jobId, new ArrayList()));
    }

    public Reward getReward(String jobId, String rewardId) {
        return this.allRewards.get(jobId + ":" + rewardId);
    }

    public RewardStatus getRewardStatus(Player player, Reward reward) {
        if (this.storage.hasClaimedReward(player.getUniqueId(), reward.getJobId(), reward.getId())) {
            if (!reward.isRepeatable()) {
                return RewardStatus.RETRIEVED;
            }
            if (reward.getCooldownHours() > 0L) {
                long lastClaim = this.storage.getClaimTime(player.getUniqueId(), reward.getJobId(), reward.getId());
                long cooldownMs = reward.getCooldownHours() * 3600000L;
                if (System.currentTimeMillis() - lastClaim < cooldownMs) {
                    return RewardStatus.RETRIEVED;
                }
            }
        }
        if (!this.canClaimReward(player, reward, false)) {
            return RewardStatus.BLOCKED;
        }
        return RewardStatus.RETRIEVABLE;
    }

    public boolean canClaimReward(Player player, Reward reward) {
        return this.canClaimReward(player, reward, true);
    }

    public boolean canClaimReward(Player player, Reward reward, boolean showFeedback) {
        if (!this.plugin.getJobManager().hasJob(player, reward.getJobId())) {
            if (showFeedback) {
                MessageUtils.sendMessage(player, this.languageManager.getMessage("rewards.claim.no-job", "job", reward.getJobId()));
            }
            return false;
        }
        int playerLevel = this.plugin.getJobManager().getLevel(player, reward.getJobId());
        if (playerLevel < reward.getRequiredLevel()) {
            if (showFeedback) {
                MessageUtils.sendMessage(player, this.languageManager.getMessage("rewards.claim.level-requirement", "required", String.valueOf(reward.getRequiredLevel()), "job", reward.getJobId(), "current", String.valueOf(playerLevel)));
            }
            return false;
        }
        if (reward.getPermission() != null && !player.hasPermission(reward.getPermission())) {
            if (showFeedback) {
                MessageUtils.sendMessage(player, this.languageManager.getMessage("rewards.claim.no-permission", "permission", reward.getPermission()));
            }
            return false;
        }
        if (reward.hasRequirements()) {
            ConditionContext context = new ConditionContext();
            ConditionResult result = reward.getRequirements().evaluate(player, null, context);
            if (!result.isAllowed()) {
                if (showFeedback) {
                    result.execute(player);
                }
                return false;
            }
            if (showFeedback && (result.getAcceptMessage() != null || result.getAcceptSound() != null || result.getAcceptCommands() != null)) {
                result.execute(player);
            }
        }
        return true;
    }

    public boolean claimReward(Player player, Reward reward) {
        RewardStatus status = this.getRewardStatus(player, reward);
        if (status != RewardStatus.RETRIEVABLE) {
            return false;
        }
        if (reward.hasItems()) {
            for (Reward.RewardItem rewardItem : reward.getItems()) {
                ItemStack item = ItemBuilder.fromRewardItem(this.plugin, rewardItem).build();
                HashMap overflow = player.getInventory().addItem(new ItemStack[]{item});
                for (ItemStack overflowItem : overflow.values()) {
                    player.getWorld().dropItemNaturally(player.getLocation(), overflowItem);
                }
            }
        }
        if (reward.hasEconomyReward()) {
            try {
                Economy economy = null;
                if (this.plugin.getServer().getServicesManager().getRegistration(Economy.class) != null) {
                    economy = (Economy)this.plugin.getServer().getServicesManager().getRegistration(Economy.class).getProvider();
                }
                if (economy != null) {
                    economy.depositPlayer((OfflinePlayer)player, reward.getEconomyReward());
                    if (this.plugin.getConfigManager().isDebugEnabled()) {
                        this.plugin.getLogger().info("Economy reward of " + reward.getEconomyReward() + " given to player " + player.getName());
                    }
                } else {
                    this.plugin.getLogger().warning("Economy reward of " + reward.getEconomyReward() + " could not be given to " + player.getName() + " - Vault/Economy not found");
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Failed to give economy reward to " + player.getName() + ": " + e.getMessage());
            }
        }
        if (reward.hasCommands()) {
            for (String command : reward.getCommands()) {
                String processedCommand = command.replace("{player}", player.getName()).replace("{job}", reward.getJobId()).replace("{reward}", reward.getId()).replace("%player_name%", player.getName());
                processedCommand = MenuUtils.processPlaceholders(player, processedCommand);
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)processedCommand);
            }
        }
        this.storage.claimReward(player.getUniqueId(), reward.getJobId(), reward.getId(), System.currentTimeMillis());
        if (this.plugin.getConfigManager().isDebugEnabled()) {
            this.plugin.getLogger().info("Player " + player.getName() + " claimed reward: " + reward.getId() + " from job: " + reward.getJobId());
        }
        return true;
    }

    public long getLastClaimTime(Player player, Reward reward) {
        return this.storage.getClaimTime(player.getUniqueId(), reward.getJobId(), reward.getId());
    }

    public void resetRewardClaim(Player player, Reward reward) {
        this.storage.resetRewardClaim(player.getUniqueId(), reward.getJobId(), reward.getId());
    }

    public void resetJobRewards(Player player, String jobId) {
        this.storage.resetJobRewards(player.getUniqueId(), jobId);
    }

    public void resetJobRewards(UUID playerUuid, String jobId) {
        this.storage.resetJobRewards(playerUuid, jobId);
    }

    public void resetAllRewards(Player player) {
        this.storage.resetAllRewards(player.getUniqueId());
    }

    public void loadPlayerData(Player player) {
        this.storage.loadPlayerData(player.getUniqueId());
    }

    public void unloadPlayerData(Player player) {
        this.storage.unloadPlayerData(player.getUniqueId());
    }

    private void createDefaultRewardFiles() {
        String[] defaultRewardFiles;
        for (String rewardFile : defaultRewardFiles = new String[]{"example_rewards.yml", "miner_rewards.yml", "farmer_rewards.yml", "hunter_rewards.yml", "lumberjack_rewards.yml"}) {
            try {
                this.plugin.saveResource("rewards/" + rewardFile, false);
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().warning("Could not create reward file " + rewardFile + ": " + e.getMessage());
            }
        }
    }

    public void saveAll() {
        this.storage.save();
    }

    public void reloadRewards() {
        this.loadRewards();
        this.guiConfigLoader.reloadGuiConfigs();
    }

    public RewardStorage getStorage() {
        return this.storage;
    }

    public GuiConfig getGuiConfig(String jobId) {
        Job job = this.plugin.getJobManager().getJob(jobId);
        if (job != null && job.getGuiReward() != null) {
            return this.guiConfigLoader.getGuiConfig(job.getGuiReward());
        }
        return this.guiConfigLoader.getGuiConfig(jobId);
    }

    public Map<String, Reward> getAllRewards() {
        return new HashMap<String, Reward>(this.allRewards);
    }

    public Map<String, Object> getStatistics() {
        HashMap<String, Object> stats = new HashMap<String, Object>();
        stats.put("total_rewards", this.allRewards.size());
        stats.put("jobs_with_rewards", this.jobRewards.size());
        int totalRepeatable = 0;
        int totalWithCooldown = 0;
        for (Reward reward : this.allRewards.values()) {
            if (reward.isRepeatable()) {
                ++totalRepeatable;
            }
            if (reward.getCooldownHours() <= 0L) continue;
            ++totalWithCooldown;
        }
        stats.put("repeatable_rewards", totalRepeatable);
        stats.put("cooldown_rewards", totalWithCooldown);
        return stats;
    }

    public void debugPlayerRewards(Player player, String jobId) {
        this.plugin.getLogger().info("=== DEBUG REWARD INFO FOR " + player.getName() + " ===");
        boolean hasJob = this.plugin.getJobManager().hasJob(player, jobId);
        this.plugin.getLogger().info("Has job '" + jobId + "': " + hasJob);
        if (hasJob) {
            int level = this.plugin.getJobManager().getLevel(player, jobId);
            this.plugin.getLogger().info("Current level in '" + jobId + "': " + level);
        }
        List<Reward> rewards = this.getJobRewards(jobId);
        this.plugin.getLogger().info("Total rewards for job '" + jobId + "': " + rewards.size());
        for (Reward reward : rewards) {
            RewardStatus status = this.getRewardStatus(player, reward);
            this.plugin.getLogger().info("Reward '" + reward.getId() + "' - Required Level: " + reward.getRequiredLevel() + " - Status: " + String.valueOf((Object)status));
        }
        this.plugin.getLogger().info("=== END DEBUG INFO ===");
    }
}

