/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.storage.dao;

import fr.ax_dev.universejobs.storage.SqlIdentifierValidator;
import fr.ax_dev.universejobs.storage.database.DatabaseConfig;
import fr.ax_dev.universejobs.storage.database.HikariConnectionPool;
import java.lang.invoke.CallSite;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;

public class RewardDao {
    private final HikariConnectionPool connectionPool;
    private final String tableName;
    private final String insertSql;
    private final String selectByPlayerAndJobAndRewardSql;
    private final String selectByPlayerAndJobSql;
    private final String selectByPlayerSql;
    private final String deleteByPlayerAndJobAndRewardSql;
    private final String deleteByPlayerAndJobSql;
    private final String deleteByPlayerSql;

    public RewardDao(HikariConnectionPool connectionPool, DatabaseConfig config) {
        this.connectionPool = connectionPool;
        this.tableName = SqlIdentifierValidator.buildSafeTableName(config.getPrefix(), "reward_claims");
        this.insertSql = "INSERT INTO " + this.tableName + " (player_uuid, job_id, reward_id, claim_time) VALUES (?, ?, ?, ?)";
        this.selectByPlayerAndJobAndRewardSql = "SELECT claim_time FROM " + this.tableName + " WHERE player_uuid = ? AND job_id = ? AND reward_id = ?";
        this.selectByPlayerAndJobSql = "SELECT reward_id, claim_time FROM " + this.tableName + " WHERE player_uuid = ? AND job_id = ?";
        this.selectByPlayerSql = "SELECT job_id, reward_id, claim_time FROM " + this.tableName + " WHERE player_uuid = ?";
        this.deleteByPlayerAndJobAndRewardSql = "DELETE FROM " + this.tableName + " WHERE player_uuid = ? AND job_id = ? AND reward_id = ?";
        this.deleteByPlayerAndJobSql = "DELETE FROM " + this.tableName + " WHERE player_uuid = ? AND job_id = ?";
        this.deleteByPlayerSql = "DELETE FROM " + this.tableName + " WHERE player_uuid = ?";
    }

    public CompletableFuture<Void> claimReward(UUID playerId, String jobId, String rewardId, long claimTime) {
        return CompletableFuture.runAsync(() -> {
            try (Connection conn = this.connectionPool.getConnection();
                 PreparedStatement stmt = conn.prepareStatement(this.insertSql);){
                stmt.setString(1, playerId.toString());
                stmt.setString(2, jobId);
                stmt.setString(3, rewardId);
                stmt.setLong(4, claimTime);
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                throw new RuntimeException("Failed to claim reward " + rewardId + " for player " + String.valueOf(playerId), e);
            }
        });
    }

    public CompletableFuture<Boolean> hasClaimedReward(UUID playerId, String jobId, String rewardId) {
        return CompletableFuture.supplyAsync(() -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
    }

    public CompletableFuture<Long> getClaimTime(UUID playerId, String jobId, String rewardId) {
        return CompletableFuture.supplyAsync(() -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
    }

    public CompletableFuture<Set<String>> getClaimedRewards(UUID playerId, String jobId) {
        return CompletableFuture.supplyAsync(() -> {
            HashSet<String> claimedRewards = new HashSet<String>();
            try (Connection conn = this.connectionPool.getConnection();){
                HashSet<String> hashSet;
                block22: {
                    PreparedStatement stmt = conn.prepareStatement(this.selectByPlayerAndJobSql);
                    try {
                        stmt.setString(1, playerId.toString());
                        stmt.setString(2, jobId);
                        try (ResultSet rs = stmt.executeQuery();){
                            while (rs.next()) {
                                claimedRewards.add(rs.getString("reward_id"));
                            }
                        }
                        hashSet = claimedRewards;
                        if (stmt == null) break block22;
                    }
                    catch (Throwable throwable) {
                        if (stmt != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    stmt.close();
                }
                return hashSet;
            }
            catch (SQLException e) {
                throw new RuntimeException("Failed to get claimed rewards for " + String.valueOf(playerId), e);
            }
        });
    }

    public CompletableFuture<Set<String>> getAllClaimedRewards(UUID playerId) {
        return CompletableFuture.supplyAsync(() -> {
            HashSet<CallSite> allClaimedRewards = new HashSet<CallSite>();
            try (Connection conn = this.connectionPool.getConnection();){
                HashSet<CallSite> hashSet;
                block22: {
                    PreparedStatement stmt = conn.prepareStatement(this.selectByPlayerSql);
                    try {
                        stmt.setString(1, playerId.toString());
                        try (ResultSet rs = stmt.executeQuery();){
                            while (rs.next()) {
                                String jobId = rs.getString("job_id");
                                String rewardId = rs.getString("reward_id");
                                allClaimedRewards.add((CallSite)((Object)(jobId + ":" + rewardId)));
                            }
                        }
                        hashSet = allClaimedRewards;
                        if (stmt == null) break block22;
                    }
                    catch (Throwable throwable) {
                        if (stmt != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    stmt.close();
                }
                return hashSet;
            }
            catch (SQLException e) {
                throw new RuntimeException("Failed to get all claimed rewards for " + String.valueOf(playerId), e);
            }
        });
    }

    public CompletableFuture<Map<String, Long>> getClaimedRewardsWithTime(UUID playerId, String jobId) {
        return CompletableFuture.supplyAsync(() -> {
            HashMap<String, Long> claimedRewards = new HashMap<String, Long>();
            try (Connection conn = this.connectionPool.getConnection();){
                HashMap<String, Long> hashMap;
                block22: {
                    PreparedStatement stmt = conn.prepareStatement(this.selectByPlayerAndJobSql);
                    try {
                        stmt.setString(1, playerId.toString());
                        stmt.setString(2, jobId);
                        try (ResultSet rs = stmt.executeQuery();){
                            while (rs.next()) {
                                String rewardId = rs.getString("reward_id");
                                long claimTime = rs.getLong("claim_time");
                                claimedRewards.put(rewardId, claimTime);
                            }
                        }
                        hashMap = claimedRewards;
                        if (stmt == null) break block22;
                    }
                    catch (Throwable throwable) {
                        if (stmt != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    stmt.close();
                }
                return hashMap;
            }
            catch (SQLException e) {
                throw new RuntimeException("Failed to get claimed rewards with time for " + String.valueOf(playerId), e);
            }
        });
    }

    public CompletableFuture<Void> resetRewardClaim(UUID playerId, String jobId, String rewardId) {
        return CompletableFuture.runAsync(() -> {
            try (Connection conn = this.connectionPool.getConnection();
                 PreparedStatement stmt = conn.prepareStatement(this.deleteByPlayerAndJobAndRewardSql);){
                stmt.setString(1, playerId.toString());
                stmt.setString(2, jobId);
                stmt.setString(3, rewardId);
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                throw new RuntimeException("Failed to reset reward claim for " + String.valueOf(playerId), e);
            }
        });
    }

    public CompletableFuture<Void> resetJobRewards(UUID playerId, String jobId) {
        return CompletableFuture.runAsync(() -> {
            try (Connection conn = this.connectionPool.getConnection();
                 PreparedStatement stmt = conn.prepareStatement(this.deleteByPlayerAndJobSql);){
                stmt.setString(1, playerId.toString());
                stmt.setString(2, jobId);
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                throw new RuntimeException("Failed to reset job rewards for " + String.valueOf(playerId), e);
            }
        });
    }

    public CompletableFuture<Void> resetAllRewards(UUID playerId) {
        return CompletableFuture.runAsync(() -> {
            try (Connection conn = this.connectionPool.getConnection();
                 PreparedStatement stmt = conn.prepareStatement(this.deleteByPlayerSql);){
                stmt.setString(1, playerId.toString());
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                throw new RuntimeException("Failed to reset all rewards for " + String.valueOf(playerId), e);
            }
        });
    }
}

