/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Registry;
import org.bukkit.Sound;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarStyle;
import org.bukkit.entity.EntityType;

public class EnumUtils {
    public static Sound parseSound(String soundName, Sound defaultSound) {
        if (soundName == null || soundName.isEmpty()) {
            return defaultSound;
        }
        try {
            try {
                NamespacedKey key = NamespacedKey.minecraft((String)soundName.toLowerCase().replace("_", "."));
                Field soundsField = Registry.class.getField("SOUNDS");
                Object soundsRegistry = soundsField.get(null);
                Method getMethod = soundsRegistry.getClass().getMethod("get", NamespacedKey.class);
                Object result = getMethod.invoke(soundsRegistry, key);
                if (result instanceof Sound) {
                    return (Sound)result;
                }
            }
            catch (NoSuchFieldException key) {
            }
            catch (Exception key) {
                // empty catch block
            }
            try {
                Method valueOfMethod = Sound.class.getMethod("valueOf", String.class);
                Object result = valueOfMethod.invoke(null, soundName.toUpperCase());
                if (result instanceof Sound) {
                    return (Sound)result;
                }
            }
            catch (Exception valueOfMethod) {
                // empty catch block
            }
            try {
                Field field = Sound.class.getField(soundName.toUpperCase());
                if (field.getType() == Sound.class) {
                    return (Sound)field.get(null);
                }
            }
            catch (Exception field) {
                // empty catch block
            }
            try {
                Sound[] values;
                Method valuesMethod = Sound.class.getMethod("values", new Class[0]);
                for (Sound enumConstant : values = (Sound[])valuesMethod.invoke(null, new Object[0])) {
                    if (!enumConstant.name().equalsIgnoreCase(soundName)) continue;
                    return enumConstant;
                }
            }
            catch (Exception exception) {
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultSound;
    }

    public static Material parseMaterial(String materialName, Material defaultMaterial) {
        return EnumUtils.parseEnumSafely(Material.class, materialName, defaultMaterial);
    }

    public static Particle parseParticle(String particleName, Particle defaultParticle) {
        return EnumUtils.parseEnumSafely(Particle.class, particleName, defaultParticle);
    }

    public static EntityType parseEntityType(String entityName, EntityType defaultType) {
        return EnumUtils.parseEnumSafely(EntityType.class, entityName, defaultType);
    }

    public static BarColor parseBarColor(String colorName, BarColor defaultColor) {
        return EnumUtils.parseEnumSafely(BarColor.class, colorName, defaultColor);
    }

    public static BarStyle parseBarStyle(String styleName, BarStyle defaultStyle) {
        return EnumUtils.parseEnumSafely(BarStyle.class, styleName, defaultStyle);
    }

    public static <T extends Enum<T>> T parseEnumSafely(Class<T> enumClass, String value, T defaultValue) {
        if (value == null || value.isEmpty()) {
            return defaultValue;
        }
        try {
            try {
                Method valueOfMethod = enumClass.getMethod("valueOf", String.class);
                Object result = valueOfMethod.invoke(null, value.toUpperCase());
                if (enumClass.isInstance(result)) {
                    return (T)((Enum)result);
                }
            }
            catch (Exception valueOfMethod) {
                // empty catch block
            }
            try {
                Field field = enumClass.getField(value.toUpperCase());
                if (field.getType() == enumClass) {
                    return (T)((Enum)field.get(null));
                }
            }
            catch (Exception field) {
                // empty catch block
            }
            try {
                Enum[] values;
                Method valuesMethod = enumClass.getMethod("values", new Class[0]);
                for (Enum enumConstant : values = (Enum[])valuesMethod.invoke(null, new Object[0])) {
                    if (!enumConstant.name().equalsIgnoreCase(value)) continue;
                    return (T)enumConstant;
                }
            }
            catch (Exception exception) {
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultValue;
    }
}

