/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.xp;

import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.xp.XpCurve;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public class XpCurveManager {
    private final UniverseJobs plugin;
    private final File curvesFolder;
    private final Map<String, XpCurve> curves = new HashMap<String, XpCurve>();

    public XpCurveManager(UniverseJobs plugin) {
        File[] existingFiles;
        this.plugin = plugin;
        this.curvesFolder = new File(plugin.getDataFolder(), "xp-curves");
        if (!this.curvesFolder.exists()) {
            this.curvesFolder.mkdirs();
        }
        if ((existingFiles = this.curvesFolder.listFiles((dir, name) -> name.endsWith(".yml"))) == null || existingFiles.length == 0) {
            this.createExampleCurves();
        }
        this.loadAllCurves();
    }

    private void loadAllCurves() {
        File[] files = this.curvesFolder.listFiles((dir, name) -> name.endsWith(".yml"));
        if (files != null) {
            for (File file : files) {
                String curveName = file.getName().replace(".yml", "");
                try {
                    XpCurve curve = XpCurve.fromFile(curveName, file);
                    this.curves.put(curveName, curve);
                }
                catch (Exception e) {
                    this.plugin.getLogger().log(Level.WARNING, "Failed to load XP curve: " + file.getName(), e);
                }
            }
        }
        if (this.curves.isEmpty()) {
            XpCurve defaultCurve = XpCurve.createDefault();
            this.curves.put("default", defaultCurve);
        }
    }

    private void createExampleCurves() {
        this.plugin.saveResource("xp-curves/example.yml", false);
    }

    public XpCurve getCurve(String name) {
        return this.curves.getOrDefault(name, this.getDefaultCurve());
    }

    public XpCurve getCurveFromEquation(String equation) {
        String equationKey = "equation_" + equation.hashCode();
        if (!this.curves.containsKey(equationKey)) {
            XpCurve curve = XpCurve.fromEquation(equationKey, equation);
            this.curves.put(equationKey, curve);
        }
        return this.curves.get(equationKey);
    }

    public XpCurve getDefaultCurve() {
        if (this.curves.containsKey("default")) {
            return this.curves.get("default");
        }
        XpCurve defaultCurve = XpCurve.createDefault();
        this.curves.put("default", defaultCurve);
        return defaultCurve;
    }

    public void reload() {
        this.curves.clear();
        this.loadAllCurves();
    }

    public Map<String, XpCurve> getAllCurves() {
        return new HashMap<String, XpCurve>(this.curves);
    }
}

