/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.cache;

import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.action.ActionType;
import fr.ax_dev.universejobs.action.JobAction;
import fr.ax_dev.universejobs.job.Job;
import java.util.AbstractCollection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;

public class ConfigurationCache {
    private final UniverseJobs plugin;
    private volatile boolean debugEnabled;
    private volatile boolean showXpGain;
    private volatile int maxCachedPlayers;
    private final Map<ActionType, Map<String, Set<JobAction>>> jobActionsByMaterial = new ConcurrentHashMap<ActionType, Map<String, Set<JobAction>>>();
    private final Map<ActionType, Map<String, Set<JobAction>>> jobActionsByEntity = new ConcurrentHashMap<ActionType, Map<String, Set<JobAction>>>();
    private final Map<ActionType, Map<String, Set<JobAction>>> actionTypeLookup = new ConcurrentHashMap<ActionType, Map<String, Set<JobAction>>>();
    private final Map<String, Pattern> compiledPatterns = new ConcurrentHashMap<String, Pattern>();
    private final Map<String, Set<String>> expandedWildcards = new ConcurrentHashMap<String, Set<String>>();
    private final Map<String, Boolean> targetValidationCache = new ConcurrentHashMap<String, Boolean>();
    private final Set<String> validPermissionNodes = ConcurrentHashMap.newKeySet();
    private final Map<String, String> messageTemplates = new ConcurrentHashMap<String, String>();

    public ConfigurationCache(UniverseJobs plugin) {
        this.plugin = plugin;
    }

    public void loadAllConfigurations() {
        this.plugin.getLogger().info("Loading configuration cache...");
        long startTime = System.currentTimeMillis();
        this.loadConfigurationFlags();
        this.loadJobActionMappings();
        this.loadPatternMappings();
        this.loadPermissionNodes();
        this.loadMessageTemplates();
        long loadTime = System.currentTimeMillis() - startTime;
        this.plugin.getLogger().info("Configuration cache loaded in " + loadTime + "ms");
        this.plugin.getLogger().info("Cache size: " + this.getCacheStats());
    }

    private void loadConfigurationFlags() {
        this.debugEnabled = this.plugin.getConfig().getBoolean("debug", false);
        this.showXpGain = this.plugin.getConfig().getBoolean("messages.show-xp-gain", true);
        this.maxCachedPlayers = this.plugin.getConfig().getInt("performance.max-cached-players", 1000);
    }

    private void loadJobActionMappings() {
        for (Job job : this.plugin.getJobManager().getAllJobs()) {
            if (!job.isEnabled()) continue;
            for (ActionType actionType : ActionType.values()) {
                List<JobAction> actions = job.getActions(actionType);
                if (actions.isEmpty()) continue;
                this.actionTypeLookup.computeIfAbsent(actionType, k -> new ConcurrentHashMap()).computeIfAbsent(job.getId(), k -> new HashSet()).addAll(actions);
                for (JobAction action : actions) {
                    String target = action.getTarget();
                    if (target == null) continue;
                    if (this.isMaterialAction(actionType)) {
                        Set<String> materials = this.expandTarget(target, this.getAllMaterials());
                        for (String material : materials) {
                            this.jobActionsByMaterial.computeIfAbsent(actionType, k -> new ConcurrentHashMap()).computeIfAbsent(material, k -> new HashSet()).add(action);
                        }
                    }
                    if (!this.isEntityAction(actionType)) continue;
                    Set<String> entities = this.expandTarget(target, this.getAllEntities());
                    for (String entity : entities) {
                        this.jobActionsByEntity.computeIfAbsent(actionType, k -> new ConcurrentHashMap()).computeIfAbsent(entity, k -> new HashSet()).add(action);
                    }
                }
            }
        }
    }

    private void loadPatternMappings() {
        HashSet<String> allTargets = new HashSet<String>();
        for (Job job : this.plugin.getJobManager().getAllJobs()) {
            for (ActionType actionType : ActionType.values()) {
                for (JobAction action : job.getActions(actionType)) {
                    if (action.getTarget() == null) continue;
                    allTargets.add(action.getTarget());
                }
            }
        }
        for (String target : allTargets) {
            if (!target.contains("*") && !target.contains("?")) continue;
            this.compiledPatterns.put(target, Pattern.compile(target.replace("*", ".*").replace("?", "."), 2));
        }
        for (String target : allTargets) {
            if (!target.contains("*")) continue;
            this.expandedWildcards.put(target, this.expandWildcard(target));
        }
    }

    private void loadPermissionNodes() {
        this.validPermissionNodes.add("*");
        this.validPermissionNodes.add("universejobs.*");
        this.validPermissionNodes.add("universejobs.multiplier.*");
        this.validPermissionNodes.add("universejobs.multiplier.money.*");
        this.validPermissionNodes.add("universejobs.multiplier.exp.*");
        for (int i = 1; i <= 10; ++i) {
            this.validPermissionNodes.add("universejobs.multiplier.money." + i);
            this.validPermissionNodes.add("universejobs.multiplier.exp." + i);
        }
        for (Job job : this.plugin.getJobManager().getAllJobs()) {
            if (job.getPermission() == null) continue;
            this.validPermissionNodes.add(job.getPermission());
        }
    }

    private void loadMessageTemplates() {
        if (this.plugin.getConfig().contains("messages")) {
            for (String key : this.plugin.getConfig().getConfigurationSection("messages").getKeys(true)) {
                Object value = this.plugin.getConfig().get("messages." + key);
                if (!(value instanceof String)) continue;
                this.messageTemplates.put(key, (String)value);
            }
        }
    }

    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    public boolean isShowXpGain() {
        return this.showXpGain;
    }

    public int getMaxCachedPlayers() {
        return this.maxCachedPlayers;
    }

    public Set<JobAction> getActionsForMaterial(ActionType actionType, String material) {
        Map<String, Set<JobAction>> materialMap = this.jobActionsByMaterial.get((Object)actionType);
        if (materialMap == null) {
            return Collections.emptySet();
        }
        Set<JobAction> exactMatch = materialMap.get(material);
        if (exactMatch != null && !exactMatch.isEmpty()) {
            return exactMatch;
        }
        for (Map.Entry<String, Set<JobAction>> entry : materialMap.entrySet()) {
            if (!entry.getKey().equalsIgnoreCase(material)) continue;
            return entry.getValue();
        }
        return Collections.emptySet();
    }

    public Set<JobAction> getActionsForEntity(ActionType actionType, String entity) {
        Map<String, Set<JobAction>> entityMap = this.jobActionsByEntity.get((Object)actionType);
        if (entityMap == null) {
            return Collections.emptySet();
        }
        Set<JobAction> exactMatch = entityMap.get(entity);
        if (exactMatch != null && !exactMatch.isEmpty()) {
            return exactMatch;
        }
        for (Map.Entry<String, Set<JobAction>> entry : entityMap.entrySet()) {
            if (!entry.getKey().equalsIgnoreCase(entity)) continue;
            return entry.getValue();
        }
        return Collections.emptySet();
    }

    public boolean isValidTarget(String actionTarget, String contextTarget) {
        String cacheKey = actionTarget + ":" + contextTarget;
        return this.targetValidationCache.computeIfAbsent(cacheKey, key -> {
            if (actionTarget.equalsIgnoreCase(contextTarget)) {
                return true;
            }
            Pattern pattern = this.compiledPatterns.get(actionTarget);
            if (pattern != null) {
                return pattern.matcher(contextTarget).matches();
            }
            Set<String> expanded = this.expandedWildcards.get(actionTarget);
            if (expanded != null) {
                return expanded.stream().anyMatch(target -> target.equalsIgnoreCase(contextTarget));
            }
            return false;
        });
    }

    public boolean isValidPermissionNode(String permission) {
        return this.validPermissionNodes.contains(permission);
    }

    public String getMessageTemplate(String key) {
        return this.messageTemplates.get(key);
    }

    private boolean isMaterialAction(ActionType type) {
        return type == ActionType.BREAK || type == ActionType.PLACE || type == ActionType.CRAFT || type == ActionType.SMELT || type == ActionType.EAT || type == ActionType.POTION;
    }

    private boolean isEntityAction(ActionType type) {
        return type == ActionType.KILL || type == ActionType.BREED || type == ActionType.TAME || type == ActionType.SHEAR || type == ActionType.ENTITY_INTERACT || type == ActionType.TRADE;
    }

    private Set<String> expandTarget(String target, Set<String> allPossible) {
        if (!target.contains("*")) {
            return allPossible.stream().filter(s -> s.equalsIgnoreCase(target)).collect(HashSet::new, HashSet::add, AbstractCollection::addAll);
        }
        Pattern pattern = Pattern.compile(target.replace("*", ".*"), 2);
        return allPossible.stream().filter(s -> pattern.matcher((CharSequence)s).matches()).collect(HashSet::new, HashSet::add, AbstractCollection::addAll);
    }

    private Set<String> expandWildcard(String wildcard) {
        Pattern pattern = this.compiledPatterns.get(wildcard);
        if (pattern == null) {
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>();
        for (Material material : Material.values()) {
            if (!pattern.matcher(material.name()).matches()) continue;
            result.add(material.name());
        }
        for (Material material : EntityType.values()) {
            if (!pattern.matcher(material.name()).matches()) continue;
            result.add(material.name());
        }
        return result;
    }

    private Set<String> getAllMaterials() {
        HashSet<String> materials = new HashSet<String>();
        for (Material mat : Material.values()) {
            materials.add(mat.name());
        }
        return materials;
    }

    private Set<String> getAllEntities() {
        HashSet<String> entities = new HashSet<String>();
        for (EntityType entity : EntityType.values()) {
            entities.add(entity.name());
        }
        return entities;
    }

    public void reload() {
        this.clearCaches();
        this.loadAllConfigurations();
    }

    private void clearCaches() {
        this.jobActionsByMaterial.clear();
        this.jobActionsByEntity.clear();
        this.actionTypeLookup.clear();
        this.compiledPatterns.clear();
        this.expandedWildcards.clear();
        this.targetValidationCache.clear();
        this.validPermissionNodes.clear();
        this.messageTemplates.clear();
    }

    public Set<String> getCachedMaterials() {
        HashSet<String> allMaterials = new HashSet<String>();
        for (Map<String, Set<JobAction>> materialMap : this.jobActionsByMaterial.values()) {
            allMaterials.addAll(materialMap.keySet());
        }
        return allMaterials;
    }

    public String getCacheStats() {
        int materialActions = 0;
        for (Map<String, Set<JobAction>> materialMap : this.jobActionsByMaterial.values()) {
            materialActions += materialMap.size();
        }
        int entityActions = 0;
        for (Map<String, Set<JobAction>> entityMap : this.jobActionsByEntity.values()) {
            entityActions += entityMap.size();
        }
        return String.format("Materials: %d, Entities: %d, Patterns: %d, Validations: %d, Permissions: %d, Messages: %d", materialActions, entityActions, this.compiledPatterns.size(), this.targetValidationCache.size(), this.validPermissionNodes.size(), this.messageTemplates.size());
    }
}

