/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.condition;

import fr.ax_dev.universejobs.utils.MessageUtils;
import java.util.List;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class ConditionResult {
    private final boolean allowed;
    private final String denyMessage;
    private final Sound denySound;
    private final List<String> denyCommands;
    private final boolean denyCancelEvent;
    private final String acceptMessage;
    private final Sound acceptSound;
    private final List<String> acceptCommands;
    private final boolean acceptCancelEvent;
    private final boolean isDefault;

    public ConditionResult(boolean allowed, String denyMessage, Sound denySound, List<String> denyCommands, boolean denyCancelEvent, String acceptMessage, Sound acceptSound, List<String> acceptCommands, boolean acceptCancelEvent) {
        this.allowed = allowed;
        this.denyMessage = denyMessage;
        this.denySound = denySound;
        this.denyCommands = denyCommands;
        this.denyCancelEvent = denyCancelEvent;
        this.acceptMessage = acceptMessage;
        this.acceptSound = acceptSound;
        this.acceptCommands = acceptCommands;
        this.acceptCancelEvent = acceptCancelEvent;
        this.isDefault = false;
    }

    public ConditionResult(ConfigurationSection config) {
        this(config, true);
    }

    public ConditionResult(ConfigurationSection config, boolean isAccept) {
        this.allowed = isAccept;
        if (isAccept) {
            this.denyMessage = null;
            this.denySound = null;
            this.denyCommands = null;
            this.denyCancelEvent = false;
            this.acceptMessage = config.getString("message");
            this.acceptSound = this.parseSound(config.getString("sound"));
            this.acceptCommands = config.getStringList("commands");
            this.acceptCancelEvent = config.getBoolean("cancel-event", false);
        } else {
            this.denyMessage = config.getString("message");
            this.denySound = this.parseSound(config.getString("sound"));
            this.denyCommands = config.getStringList("commands");
            this.denyCancelEvent = config.getBoolean("cancel-event", false);
            this.acceptMessage = null;
            this.acceptSound = null;
            this.acceptCommands = null;
            this.acceptCancelEvent = false;
        }
        this.isDefault = false;
    }

    public ConditionResult(boolean allowed, String denyMessage, Sound denySound, List<String> denyCommands, String acceptMessage, Sound acceptSound, List<String> acceptCommands) {
        this(allowed, denyMessage, denySound, denyCommands, false, acceptMessage, acceptSound, acceptCommands, false);
    }

    public ConditionResult(boolean allowed, String message, Sound sound, List<String> commands) {
        this(allowed, allowed ? null : message, allowed ? null : sound, allowed ? null : commands, false, allowed ? message : null, (Sound)(allowed ? sound : null), allowed ? commands : null, false);
    }

    private Sound parseSound(String soundString) {
        if (soundString == null || soundString.isEmpty()) {
            return null;
        }
        try {
            return Sound.valueOf((String)soundString.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private ConditionResult(boolean allowed, boolean isDefault) {
        this.allowed = allowed;
        this.denyMessage = null;
        this.denySound = null;
        this.denyCommands = null;
        this.denyCancelEvent = false;
        this.acceptMessage = null;
        this.acceptSound = null;
        this.acceptCommands = null;
        this.acceptCancelEvent = false;
        this.isDefault = isDefault;
    }

    public static ConditionResult allow() {
        return new ConditionResult(true, true);
    }

    public static ConditionResult allow(String message, Sound sound, List<String> commands) {
        return new ConditionResult(true, null, null, null, message, sound, commands);
    }

    public static ConditionResult deny() {
        return new ConditionResult(false, true);
    }

    public static ConditionResult deny(String message) {
        return new ConditionResult(false, message, null, null, null, null, null);
    }

    public static ConditionResult deny(String message, Sound sound) {
        return new ConditionResult(false, message, sound, null, null, null, null);
    }

    public static ConditionResult deny(String message, Sound sound, List<String> commands) {
        return new ConditionResult(false, message, sound, commands, null, null, null);
    }

    public boolean isAllowed() {
        return this.allowed;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public String getDenyMessage() {
        return this.denyMessage;
    }

    public Sound getDenySound() {
        return this.denySound;
    }

    public List<String> getDenyCommands() {
        return this.denyCommands;
    }

    public String getAcceptMessage() {
        return this.acceptMessage;
    }

    public Sound getAcceptSound() {
        return this.acceptSound;
    }

    public List<String> getAcceptCommands() {
        return this.acceptCommands;
    }

    public boolean shouldCancelEvent() {
        return this.allowed ? this.acceptCancelEvent : this.denyCancelEvent;
    }

    public boolean getDenyCancelEvent() {
        return this.denyCancelEvent;
    }

    public boolean getAcceptCancelEvent() {
        return this.acceptCancelEvent;
    }

    public void execute(Player player) {
        List<String> commands;
        Sound sound;
        String message;
        if (this.allowed) {
            message = this.acceptMessage;
            sound = this.acceptSound;
            commands = this.acceptCommands;
        } else {
            message = this.denyMessage;
            sound = this.denySound;
            commands = this.denyCommands;
        }
        if (message != null && !message.isEmpty()) {
            MessageUtils.sendMessage(player, message);
        }
        if (sound != null) {
            player.playSound(player.getLocation(), sound, 1.0f, 1.0f);
        }
        if (commands != null && !commands.isEmpty()) {
            for (String command : commands) {
                String processedCommand = command.replace("{player}", player.getName());
                player.getServer().dispatchCommand((CommandSender)player.getServer().getConsoleSender(), processedCommand);
            }
        }
    }

    public String toString() {
        return "ConditionResult{allowed=" + this.allowed + ", hasDenyMessage=" + (this.denyMessage != null) + ", hasDenySound=" + (this.denySound != null) + ", denyCommandCount=" + (this.denyCommands != null ? this.denyCommands.size() : 0) + ", denyCancelEvent=" + this.denyCancelEvent + ", hasAcceptMessage=" + (this.acceptMessage != null) + ", hasAcceptSound=" + (this.acceptSound != null) + ", acceptCommandCount=" + (this.acceptCommands != null ? this.acceptCommands.size() : 0) + ", acceptCancelEvent=" + this.acceptCancelEvent + "}";
    }
}

