/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.condition.impl;

import de.tr7zw.changeme.nbtapi.NBTItem;
import fr.ax_dev.universejobs.condition.AbstractCondition;
import fr.ax_dev.universejobs.condition.ConditionContext;
import fr.ax_dev.universejobs.condition.ConditionType;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

public class ItemCondition
extends AbstractCondition {
    private final List<String> materials = new ArrayList<String>();
    private final String nbtKey;
    private final String nbtValue;
    private final Integer customModelData;
    private final String mmoItemsType;
    private final String mmoItemsId;

    public ItemCondition(ConfigurationSection config) {
        super(config);
        if (config.isList("material")) {
            this.materials.addAll(config.getStringList("material"));
        } else if (config.getString("material") != null) {
            this.materials.add(config.getString("material"));
        }
        this.nbtKey = config.getString("nbt.key");
        this.nbtValue = config.getString("nbt.value");
        this.customModelData = config.contains("custom-model-data") ? Integer.valueOf(config.getInt("custom-model-data")) : null;
        this.mmoItemsType = config.getString("mmoitems.type");
        this.mmoItemsId = config.getString("mmoitems.id");
    }

    @Override
    public boolean isMet(Player player, Event event, ConditionContext context) {
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item == null || item.getType() == Material.AIR) {
            return false;
        }
        if (!this.materials.isEmpty()) {
            boolean materialMatched = false;
            for (String materialName : this.materials) {
                try {
                    Material requiredMaterial = Material.valueOf((String)materialName.toUpperCase());
                    if (item.getType() != requiredMaterial) continue;
                    materialMatched = true;
                    break;
                }
                catch (IllegalArgumentException e) {
                }
            }
            if (!materialMatched) {
                return false;
            }
        }
        if (!(this.customModelData == null || item.hasItemMeta() && item.getItemMeta().hasCustomModelData() && item.getItemMeta().getCustomModelData() == this.customModelData.intValue())) {
            return false;
        }
        if (this.nbtKey != null && this.nbtValue != null) {
            try {
                NBTItem nbtItem = new NBTItem(item);
                if (!nbtItem.hasKey(this.nbtKey).booleanValue()) {
                    return false;
                }
                String itemNbtValue = nbtItem.getString(this.nbtKey);
                if (!this.nbtValue.equals(itemNbtValue)) {
                    return false;
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return this.mmoItemsType == null || this.mmoItemsId == null || this.checkMMOItemsData(item);
    }

    private boolean checkMMOItemsData(ItemStack item) {
        try {
            NBTItem nbtItem = new NBTItem(item);
            if (!nbtItem.hasKey("MMOITEMS_ITEM_TYPE").booleanValue() || !nbtItem.hasKey("MMOITEMS_ITEM_ID").booleanValue()) {
                return false;
            }
            String itemType = nbtItem.getString("MMOITEMS_ITEM_TYPE");
            String itemId = nbtItem.getString("MMOITEMS_ITEM_ID");
            return this.mmoItemsType.equals(itemType) && this.mmoItemsId.equals(itemId);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public ConditionType getType() {
        return ConditionType.ITEM;
    }

    public String toString() {
        return "ItemCondition{materials=" + String.valueOf(this.materials) + ", hasNBT=" + (this.nbtKey != null) + ", hasMMOItems=" + (this.mmoItemsType != null) + "}";
    }
}

