/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.config;

import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.config.ProgressBarConfig;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.file.FileConfiguration;

public class ConfigManager {
    private final UniverseJobs plugin;
    private ProgressBarConfig progressBarConfig;

    public ConfigManager(UniverseJobs plugin) {
        this.plugin = plugin;
    }

    public void loadConfig() {
        this.plugin.saveDefaultConfig();
        this.plugin.reloadConfig();
        FileConfiguration config = this.plugin.getConfig();
        this.validateConfig(config);
        this.progressBarConfig = new ProgressBarConfig(config.getConfigurationSection("progress-bar"));
    }

    private void validateConfig(FileConfiguration config) {
    }

    public void reloadConfig() {
        this.plugin.reloadConfig();
        FileConfiguration config = this.plugin.getConfig();
        this.validateConfig(config);
        this.progressBarConfig = new ProgressBarConfig(config.getConfigurationSection("progress-bar"));
        this.plugin.getLevelUpActionManager().reload();
        this.plugin.getBatchedRewardManager().reloadConfig();
        this.plugin.getProtectionManager().reloadConfig();
    }

    public String getMessage(String key, String defaultValue) {
        String message = this.plugin.getConfig().getString("messages." + key, defaultValue);
        return message;
    }

    public String getMessage(String key, String defaultValue, String ... placeholders) {
        String message = this.getMessage(key, defaultValue);
        HashMap<String, String> placeholderMap = new HashMap<String, String>();
        for (int i = 0; i < placeholders.length - 1; i += 2) {
            placeholderMap.put(placeholders[i], placeholders[i + 1]);
        }
        for (Map.Entry entry : placeholderMap.entrySet()) {
            message = message.replace("{" + (String)entry.getKey() + "}", (CharSequence)entry.getValue());
        }
        return message;
    }

    public boolean isDebugEnabled() {
        return this.plugin.getConfig().getBoolean("debug", false);
    }

    public int getMaxJobsPerPlayer() {
        if (this.isAllJobsByDefault()) {
            return Integer.MAX_VALUE;
        }
        return this.plugin.getConfig().getInt("jobs.max-jobs-per-player", 3);
    }

    public boolean isAllJobsByDefault() {
        return this.plugin.getConfig().getBoolean("jobs.all-jobs-by-default", false);
    }

    public List<String> getJobsByDefault() {
        return this.plugin.getConfig().getStringList("jobs.jobs-by-default");
    }

    public boolean isDefaultJob(String jobId) {
        if (this.isAllJobsByDefault()) {
            return true;
        }
        return this.getJobsByDefault().contains(jobId);
    }

    public int getSaveInterval() {
        return this.plugin.getConfig().getInt("settings.save-interval", 300);
    }

    public ProgressBarConfig getProgressBarConfig() {
        return this.progressBarConfig;
    }

    public BoostCalculationMode getBoostCalculationMode() {
        String modeStr = this.plugin.getConfig().getString("jobs.boost-calculation-mode", "MULTIPLICATIVE");
        try {
            return BoostCalculationMode.valueOf(modeStr.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLogger().warning("Invalid boost calculation mode: " + modeStr + ", using MULTIPLICATIVE");
            return BoostCalculationMode.MULTIPLICATIVE;
        }
    }

    public String getJobStatus(boolean hasJob) {
        String key = hasJob ? "placeholders.job_status.joined" : "placeholders.job_status.not_joined";
        String defaultValue = hasJob ? "<#abffb3>\u2713 Active" : "<#ff6b6b>\u25cb Not Joined";
        return this.plugin.getConfig().getString(key, defaultValue);
    }

    public static enum BoostCalculationMode {
        ADDITIVE,
        MULTIPLICATIVE,
        HIGHEST;

    }
}

