/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.listener;

import com.nexomc.nexo.api.NexoBlocks;
import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.action.ActionProcessor;
import fr.ax_dev.universejobs.action.ActionType;
import fr.ax_dev.universejobs.cache.ConfigurationCache;
import fr.ax_dev.universejobs.cache.PlayerJobCache;
import fr.ax_dev.universejobs.condition.ConditionContext;
import fr.ax_dev.universejobs.integration.MythicMobsHandler;
import fr.ax_dev.universejobs.protection.BlockProtectionManager;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.Villager;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockCookEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityBreedEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityTameEvent;
import org.bukkit.event.inventory.BrewEvent;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerShearEntityEvent;
import org.bukkit.inventory.BrewerInventory;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Merchant;
import org.bukkit.inventory.MerchantInventory;
import org.bukkit.inventory.MerchantRecipe;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionType;

public class JobActionListener
implements Listener {
    private static final String TARGET_SUFFIX = " - target: ";
    private static final String COLOR_CODE_PATTERN = "\u00a7[0-9a-fk-or]";
    private static final String TARGET_KEY = "target";
    private final UniverseJobs plugin;
    private final ActionProcessor actionProcessor;
    private final BlockProtectionManager protectionManager;
    private final MythicMobsHandler mythicMobsHandler;
    private final ConfigurationCache configCache;
    private final PlayerJobCache playerCache;
    private final AtomicLong totalEvents = new AtomicLong(0L);
    private final AtomicLong processedEvents = new AtomicLong(0L);
    private final NamespacedKey furnaceOwnerKey;
    private final NamespacedKey furnaceLastUseKey;

    public JobActionListener(UniverseJobs plugin, ActionProcessor actionProcessor, BlockProtectionManager protectionManager, MythicMobsHandler mythicMobsHandler, ConfigurationCache configCache, PlayerJobCache playerCache) {
        this.plugin = plugin;
        this.actionProcessor = actionProcessor;
        this.protectionManager = protectionManager;
        this.mythicMobsHandler = mythicMobsHandler;
        this.configCache = configCache;
        this.playerCache = playerCache;
        this.furnaceOwnerKey = new NamespacedKey((Plugin)plugin, "furnace_owner");
        this.furnaceLastUseKey = new NamespacedKey((Plugin)plugin, "furnace_last_use");
    }

    public Map<String, Object> getPerformanceStats() {
        ConcurrentHashMap<String, Object> stats = new ConcurrentHashMap<String, Object>();
        stats.put("total_events", this.totalEvents.get());
        stats.put("processed_events", this.processedEvents.get());
        stats.put("mythicmobs_available", this.mythicMobsHandler.isAvailable());
        stats.putAll(this.playerCache.getStats());
        long processed = this.processedEvents.get();
        long total = this.totalEvents.get();
        double processingRate = total > 0L ? (double)processed / (double)total * 100.0 : 0.0;
        stats.put("processing_rate_percent", processingRate);
        return stats;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityDeath(EntityDeathEvent event) {
        LivingEntity killed = event.getEntity();
        Player killer = null;
        if (killed instanceof LivingEntity) {
            killer = killed.getKiller();
        }
        if (killer == null) {
            return;
        }
        this.totalEvents.incrementAndGet();
        try {
            ConditionContext context = new ConditionContext().setEntity((Entity)killed).set(TARGET_KEY, killed.getType().name());
            this.mythicMobsHandler.populateMythicMobContext((Entity)killed, context);
            this.actionProcessor.processAction(killer, ActionType.KILL, (Event)event, context);
            this.processedEvents.incrementAndGet();
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error processing KILL action for player " + killer.getName() + ": " + e.getMessage());
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        if (this.isNexoBlock(event.getBlock())) {
            if (this.configCache.isDebugEnabled()) {
                this.plugin.getLogger().info("Skipping vanilla BlockBreakEvent for Nexo block - handled by NexoEventListener");
            }
            return;
        }
        if (this.isItemsAdderBlock(event.getBlock())) {
            if (this.configCache.isDebugEnabled()) {
                this.plugin.getLogger().info("Skipping vanilla BlockBreakEvent for ItemsAdder block - handled by ItemsAdderEventListener");
            }
            return;
        }
        if (this.configCache.isDebugEnabled()) {
            this.plugin.getLogger().info("Block break event: " + String.valueOf(event.getBlock().getType()) + " by " + player.getName());
        }
        this.totalEvents.incrementAndGet();
        try {
            boolean shouldCancel;
            if (this.protectionManager.isPlayerPlacedBlock(event.getBlock())) {
                this.protectionManager.removeTrackedBlock(event.getBlock());
                if (this.configCache.isDebugEnabled()) {
                    this.plugin.getLogger().info("Player " + player.getName() + " mined a player-placed block - no XP awarded");
                }
                return;
            }
            if (this.isFurnaceType(event.getBlock().getType())) {
                String blockCoords = event.getBlock().getX() + ":" + event.getBlock().getY() + ":" + event.getBlock().getZ();
                this.cleanupFurnaceNBT(event.getBlock(), blockCoords);
                if (this.configCache.isDebugEnabled()) {
                    this.plugin.getLogger().info("Cleaned up furnace NBT data for broken " + String.valueOf(event.getBlock().getType()) + " at " + String.valueOf(event.getBlock().getLocation()));
                }
            }
            ConditionContext context = new ConditionContext().setBlock(event.getBlock()).set(TARGET_KEY, event.getBlock().getType().name());
            if (this.configCache.isDebugEnabled()) {
                this.plugin.getLogger().info("Processing BREAK action for " + player.getName() + TARGET_SUFFIX + event.getBlock().getType().name());
            }
            if (shouldCancel = this.actionProcessor.processAction(player, ActionType.BREAK, (Event)event, context)) {
                event.setCancelled(true);
            }
            this.processedEvents.incrementAndGet();
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error processing BREAK action for player " + player.getName() + ": " + e.getMessage());
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockPlace(BlockPlaceEvent event) {
        Player player = event.getPlayer();
        if (this.isNexoBlock(event.getBlock())) {
            if (this.configCache.isDebugEnabled()) {
                this.plugin.getLogger().info("Skipping vanilla BlockPlaceEvent for Nexo block - handled by NexoEventListener");
            }
            return;
        }
        if (this.isItemsAdderBlock(event.getBlock())) {
            if (this.configCache.isDebugEnabled()) {
                this.plugin.getLogger().info("Skipping vanilla BlockPlaceEvent for ItemsAdder block - handled by ItemsAdderEventListener");
            }
            return;
        }
        this.protectionManager.recordBlockPlacement(player, event.getBlock());
        ConditionContext context = new ConditionContext().setBlock(event.getBlock()).set(TARGET_KEY, event.getBlock().getType().name());
        boolean shouldCancel = this.actionProcessor.processAction(player, ActionType.PLACE, (Event)event, context);
        if (shouldCancel) {
            event.setCancelled(true);
            this.protectionManager.removeTrackedBlock(event.getBlock());
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEntityBreed(EntityBreedEvent event) {
        LivingEntity livingEntity = event.getBreeder();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        ConditionContext context = new ConditionContext().setEntity((Entity)event.getEntity()).set(TARGET_KEY, event.getEntityType().name());
        boolean shouldCancel = this.actionProcessor.processAction(player, ActionType.BREED, (Event)event, context);
        if (shouldCancel) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerFish(PlayerFishEvent event) {
        boolean shouldCancel;
        Item caughtItem;
        ItemStack itemStack;
        if (event.getState() != PlayerFishEvent.State.CAUGHT_FISH) {
            return;
        }
        Player player = event.getPlayer();
        String target = "FISH";
        if (event.getCaught() instanceof Item && (itemStack = (caughtItem = (Item)event.getCaught()).getItemStack()) != null) {
            target = itemStack.getType().name();
            if (this.plugin.getConfigManager().isDebugEnabled()) {
                this.plugin.getLogger().info("Vanilla fishing caught: " + target + " by " + player.getName());
            }
        }
        ConditionContext context = new ConditionContext().set(TARGET_KEY, target);
        if (event.getCaught() != null) {
            context.setEntity(event.getCaught());
            if (event.getCaught() instanceof Item) {
                Item itemEntity = (Item)event.getCaught();
                context.setItem(itemEntity.getItemStack());
            }
        }
        if (this.plugin.getConfigManager().isDebugEnabled()) {
            this.plugin.getLogger().info("Processing FISH action with target: " + target + " by " + player.getName());
        }
        if (shouldCancel = this.actionProcessor.processAction(player, ActionType.FISH, (Event)event, context)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEntityTame(EntityTameEvent event) {
        AnimalTamer animalTamer = event.getOwner();
        if (!(animalTamer instanceof Player)) {
            return;
        }
        Player player = (Player)animalTamer;
        ConditionContext context = new ConditionContext().setEntity((Entity)event.getEntity()).set(TARGET_KEY, event.getEntityType().name());
        boolean shouldCancel = this.actionProcessor.processAction(player, ActionType.TAME, (Event)event, context);
        if (shouldCancel) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerShearEntity(PlayerShearEntityEvent event) {
        boolean shouldCancel;
        Player player = event.getPlayer();
        ConditionContext context = new ConditionContext().setEntity(event.getEntity()).set(TARGET_KEY, event.getEntity().getType().name());
        if (event.getEntity() instanceof Sheep) {
            Sheep sheep = (Sheep)event.getEntity();
            context.set("color", sheep.getColor().name());
            if (this.plugin.getConfigManager().isDebugEnabled()) {
                this.plugin.getLogger().info("Shearing sheep with color: " + sheep.getColor().name() + " by " + player.getName());
            }
        }
        if (shouldCancel = this.actionProcessor.processAction(player, ActionType.SHEAR, (Event)event, context)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerItemConsume(PlayerItemConsumeEvent event) {
        ActionType actionType;
        Player player = event.getPlayer();
        ItemStack item = event.getItem();
        if (item == null) {
            return;
        }
        String target = this.detectItemTarget(item);
        ConditionContext context = new ConditionContext().setItem(item).set(TARGET_KEY, target);
        if (item.hasItemMeta()) {
            this.addCustomItemContext(item, context);
            if (this.plugin.getConfigManager().isDebugEnabled()) {
                this.plugin.getLogger().info("Player " + player.getName() + " consumed item with target: " + target);
            }
        }
        if (item.getType().name().contains("POTION")) {
            actionType = ActionType.POTION;
            this.addPotionContext(item, context);
        } else {
            actionType = ActionType.EAT;
        }
        boolean shouldCancel = this.actionProcessor.processAction(player, actionType, (Event)event, context);
        if (shouldCancel) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerInteract(PlayerInteractEvent event) {
        boolean shouldCancel;
        Player player = event.getPlayer();
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        if (event.getClickedBlock() == null) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        this.totalEvents.incrementAndGet();
        String interactType = player.isSneaking() ? "RIGHT_SHIFT_CLICK" : "RIGHT_CLICK";
        ConditionContext context = new ConditionContext().setBlock(event.getClickedBlock()).set(TARGET_KEY, event.getClickedBlock().getType().name()).set("interact-type", interactType);
        if (this.plugin.getConfigManager().isDebugEnabled()) {
            this.plugin.getLogger().info("Block interact (RIGHT_CLICK): " + String.valueOf(event.getClickedBlock().getType()) + " by " + player.getName() + " - interact-type: " + interactType);
        }
        if (shouldCancel = this.actionProcessor.processAction(player, ActionType.BLOCK_INTERACT, (Event)event, context)) {
            event.setCancelled(true);
        }
        this.processedEvents.incrementAndGet();
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        Player player = event.getPlayer();
        Entity entity = event.getRightClicked();
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        this.totalEvents.incrementAndGet();
        if (this.isMilkingAction(player, entity)) {
            this.processMilkAction(player, entity, event);
            return;
        }
        String interactType = player.isSneaking() ? "RIGHT_SHIFT_CLICK" : "RIGHT_CLICK";
        ConditionContext context = new ConditionContext().setEntity(entity).set(TARGET_KEY, entity.getType().name()).set("interact-type", interactType);
        this.mythicMobsHandler.populateMythicMobContext(entity, context);
        boolean shouldCancel = this.actionProcessor.processAction(player, ActionType.ENTITY_INTERACT, (Event)event, context);
        if (shouldCancel) {
            event.setCancelled(true);
        }
        this.processedEvents.incrementAndGet();
    }

    private boolean isMilkingAction(Player player, Entity entity) {
        if (entity.getType() != EntityType.COW && entity.getType() != EntityType.GOAT) {
            return false;
        }
        ItemStack mainHand = player.getInventory().getItemInMainHand();
        ItemStack offHand = player.getInventory().getItemInOffHand();
        return mainHand != null && mainHand.getType() == Material.BUCKET || offHand != null && offHand.getType() == Material.BUCKET;
    }

    private void processMilkAction(Player player, Entity entity, PlayerInteractEntityEvent event) {
        try {
            boolean shouldCancel;
            ConditionContext context = new ConditionContext().setEntity(entity).set(TARGET_KEY, entity.getType().name()).set("milk_source", entity.getType().name());
            if (this.plugin.getConfigManager().isDebugEnabled()) {
                this.plugin.getLogger().info("Processing MILK action for " + player.getName() + " - source: " + entity.getType().name());
            }
            if (shouldCancel = this.actionProcessor.processAction(player, ActionType.MILK, (Event)event, context)) {
                event.setCancelled(true);
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error processing MILK action for player " + player.getName() + ": " + e.getMessage());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onCraftItem(CraftItemEvent event) {
        if (!this.isValidCraftEvent(event)) {
            return;
        }
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        this.totalEvents.incrementAndGet();
        ItemStack resultStack = event.getRecipe().getResult();
        ItemStack toCraft = event.getCurrentItem();
        if (!this.canProcessCraftEvent(player, event, resultStack, toCraft)) {
            return;
        }
        this.debugLogCraftEvent(player, event, toCraft);
        this.processCraftAction(player, event, resultStack, toCraft);
        this.processedEvents.incrementAndGet();
    }

    private boolean isValidCraftEvent(CraftItemEvent event) {
        switch (event.getAction()) {
            case NOTHING: 
            case PLACE_ONE: 
            case PLACE_ALL: 
            case PLACE_SOME: {
                return false;
            }
        }
        if (event.getSlotType() != InventoryType.SlotType.RESULT) {
            return false;
        }
        return event.isLeftClick() || event.isRightClick();
    }

    private boolean canProcessCraftEvent(Player player, CraftItemEvent event, ItemStack resultStack, ItemStack toCraft) {
        if (event.isShiftClick() && !this.canInventoryAcceptItems(player.getInventory(), resultStack)) {
            this.debugLog("Craft blocked - inventory cannot accept items with shift-click by " + player.getName());
            return false;
        }
        return this.hasItems(toCraft);
    }

    private void debugLogCraftEvent(Player player, CraftItemEvent event, ItemStack toCraft) {
        this.debugLog("Craft event: " + String.valueOf(toCraft.getType()) + " x" + toCraft.getAmount() + ", Action: " + String.valueOf(event.getAction()) + ", Shift-click: " + event.isShiftClick() + " by " + player.getName());
    }

    private void processCraftAction(Player player, CraftItemEvent event, ItemStack resultStack, ItemStack toCraft) {
        if (event.isShiftClick()) {
            this.schedulePostDetection(player, toCraft.clone(), resultStack.clone());
        } else if (this.isStackSumLegal(toCraft, event.getCursor())) {
            int craftCount = toCraft.getAmount() / resultStack.getAmount();
            this.processCraftRewards(player, resultStack, craftCount);
        }
    }

    private void debugLog(String message) {
        if (this.plugin.getConfigManager().isDebugEnabled()) {
            this.plugin.getLogger().info(message);
        }
    }

    private void schedulePostDetection(Player player, ItemStack compareItem, ItemStack resultStack) {
        ItemStack[] preInv = this.cloneInventoryContents(player.getInventory().getContents());
        this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> this.processPostDetectionComparison(player, compareItem, resultStack, preInv), 1L);
    }

    private ItemStack[] cloneInventoryContents(ItemStack[] contents) {
        ItemStack[] cloned = new ItemStack[contents.length];
        for (int i = 0; i < contents.length; ++i) {
            if (contents[i] == null) continue;
            cloned[i] = contents[i].clone();
        }
        return cloned;
    }

    private void processPostDetectionComparison(Player player, ItemStack compareItem, ItemStack resultStack, ItemStack[] preInv) {
        ItemStack[] postInv = player.getInventory().getContents();
        int newItemsCount = this.calculateNewItemsCount(preInv, postInv, compareItem);
        if (resultStack != null && newItemsCount > 0) {
            int craftCount = newItemsCount / resultStack.getAmount();
            this.debugLog("Post-detection: " + player.getName() + " crafted " + newItemsCount + " " + String.valueOf(compareItem.getType()) + " (" + craftCount + " crafts)");
            this.processCraftRewards(player, resultStack, craftCount);
        }
    }

    private int calculateNewItemsCount(ItemStack[] preInv, ItemStack[] postInv, ItemStack compareItem) {
        int newItemsCount = 0;
        for (int i = 0; i < preInv.length; ++i) {
            ItemStack pre = preInv[i];
            ItemStack post = postInv[i];
            if (!this.hasSameItem(compareItem, post) || !this.hasSameItem(compareItem, pre) && pre != null) continue;
            newItemsCount += post.getAmount() - (pre != null ? pre.getAmount() : 0);
        }
        return newItemsCount;
    }

    private void processCraftRewards(Player player, ItemStack resultStack, int craftCount) {
        if (craftCount <= 0) {
            return;
        }
        ConditionContext context = new ConditionContext().setItem(resultStack).set(TARGET_KEY, resultStack.getType().name()).set("amount", resultStack.getAmount() * craftCount).set("recipe_yield", resultStack.getAmount()).set("recipe_executions", craftCount).set("craft_multiplier", craftCount);
        this.actionProcessor.processAction(player, ActionType.CRAFT, null, context);
    }

    private boolean hasItems(ItemStack stack) {
        return stack != null && stack.getAmount() > 0;
    }

    private boolean hasSameItem(ItemStack a, ItemStack b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        return a.getType() == b.getType() && a.getDurability() == b.getDurability() && Objects.equals(a.getEnchantments(), b.getEnchantments()) && Objects.equals(a.getItemMeta(), b.getItemMeta());
    }

    private boolean isStackSumLegal(ItemStack a, ItemStack b) {
        if (a == null || b == null) {
            return true;
        }
        return a.getAmount() + b.getAmount() <= a.getType().getMaxStackSize();
    }

    private boolean canInventoryAcceptItems(PlayerInventory inventory, ItemStack itemToAdd) {
        if (itemToAdd == null || itemToAdd.getAmount() <= 0) {
            return true;
        }
        if (inventory.firstEmpty() != -1) {
            return true;
        }
        int maxStackSize = itemToAdd.getMaxStackSize();
        for (int i = 0; i < 36; ++i) {
            ItemStack slot = inventory.getItem(i);
            if (slot == null || !this.hasSameItem(itemToAdd, slot) || slot.getAmount() >= maxStackSize) continue;
            return true;
        }
        return false;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onInventoryClick(InventoryClickEvent event) {
        if (event.getInventory().getType() != InventoryType.FURNACE && event.getInventory().getType() != InventoryType.BLAST_FURNACE && event.getInventory().getType() != InventoryType.SMOKER && event.getInventory().getType() != InventoryType.BREWING) {
            return;
        }
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (event.getInventory().getType() == InventoryType.FURNACE ? event.getSlot() != 0 && event.getSlot() != 1 : event.getInventory().getType() == InventoryType.BREWING && (event.getSlot() < 0 || event.getSlot() > 4)) {
            return;
        }
        if (event.getCursor() == null || event.getCursor().getType().isAir()) {
            return;
        }
        Location inventoryLocation = event.getInventory().getLocation();
        if (inventoryLocation == null) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        Block furnaceBlock = inventoryLocation.getBlock();
        furnaceBlock.getChunk().getPersistentDataContainer().set(this.furnaceOwnerKey, PersistentDataType.STRING, (Object)(furnaceBlock.getX() + ":" + furnaceBlock.getY() + ":" + furnaceBlock.getZ() + ":" + player.getUniqueId().toString()));
        furnaceBlock.getChunk().getPersistentDataContainer().set(this.furnaceLastUseKey, PersistentDataType.STRING, (Object)(furnaceBlock.getX() + ":" + furnaceBlock.getY() + ":" + furnaceBlock.getZ() + ":" + currentTime));
        if (this.plugin.getConfigManager().isDebugEnabled()) {
            String inventoryType = event.getInventory().getType().name();
            this.plugin.getLogger().info(inventoryType + " owner tracked: " + player.getName() + " at " + inventoryLocation.toString() + " (slot " + event.getSlot() + ")");
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockCook(BlockCookEvent event) {
        Player player = this.getFurnaceOwner(event.getBlock().getLocation());
        if (player == null) {
            if (this.plugin.getConfigManager().isDebugEnabled()) {
                this.plugin.getLogger().info("No tracked owner for " + String.valueOf(event.getBlock().getType()) + " at " + String.valueOf(event.getBlock().getLocation()) + " - no XP awarded");
            }
            return;
        }
        this.totalEvents.incrementAndGet();
        ItemStack result = event.getResult();
        if (result == null) {
            return;
        }
        try {
            ConditionContext context = new ConditionContext().setItem(result).set(TARGET_KEY, this.detectItemTarget(result)).set("amount", result.getAmount()).set("furnace_type", event.getBlock().getType().name());
            ItemStack source = event.getSource();
            if (source != null) {
                context.set("source_target", this.detectItemTarget(source)).set("source_amount", source.getAmount());
            }
            if (this.plugin.getConfigManager().isDebugEnabled()) {
                this.plugin.getLogger().info("Processing SMELT action for " + player.getName() + TARGET_SUFFIX + String.valueOf(context.get(TARGET_KEY)) + " - source: " + String.valueOf(context.get("source_target")));
            }
            this.actionProcessor.processAction(player, ActionType.SMELT, (Event)event, context);
            this.processedEvents.incrementAndGet();
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error processing SMELT action for player " + player.getName() + ": " + e.getMessage());
        }
    }

    private Player getFurnaceOwner(Location furnaceLocation) {
        String[] useParts;
        UUID ownerUUID;
        Block furnaceBlock = furnaceLocation.getBlock();
        String blockCoords = furnaceBlock.getX() + ":" + furnaceBlock.getY() + ":" + furnaceBlock.getZ();
        String ownerData = (String)furnaceBlock.getChunk().getPersistentDataContainer().get(this.furnaceOwnerKey, PersistentDataType.STRING);
        if (ownerData == null) {
            return null;
        }
        String[] ownerParts = ownerData.split(":");
        if (ownerParts.length != 4 || !ownerData.startsWith(blockCoords + ":")) {
            return null;
        }
        try {
            ownerUUID = UUID.fromString(ownerParts[3]);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        Player owner = this.plugin.getServer().getPlayer(ownerUUID);
        if (owner == null || !owner.isOnline()) {
            this.cleanupFurnaceNBT(furnaceBlock, blockCoords);
            return null;
        }
        String lastUseData = (String)furnaceBlock.getChunk().getPersistentDataContainer().get(this.furnaceLastUseKey, PersistentDataType.STRING);
        if (lastUseData != null && lastUseData.startsWith(blockCoords + ":") && (useParts = lastUseData.split(":")).length == 4) {
            try {
                long lastUse = Long.parseLong(useParts[3]);
                if (System.currentTimeMillis() - lastUse > 1800000L) {
                    this.cleanupFurnaceNBT(furnaceBlock, blockCoords);
                    return null;
                }
            }
            catch (NumberFormatException e) {
                this.cleanupFurnaceNBT(furnaceBlock, blockCoords);
                return null;
            }
        }
        return owner;
    }

    private void cleanupFurnaceNBT(Block furnaceBlock, String blockCoords) {
        furnaceBlock.getChunk().getPersistentDataContainer().remove(this.furnaceOwnerKey);
        furnaceBlock.getChunk().getPersistentDataContainer().remove(this.furnaceLastUseKey);
    }

    private boolean isFurnaceType(Material material) {
        return material == Material.FURNACE || material == Material.BLAST_FURNACE || material == Material.SMOKER || material == Material.BREWING_STAND;
    }

    private String detectItemTarget(ItemStack item) {
        if (item == null) {
            return "AIR";
        }
        String nexoTarget = this.detectNexoItem(item);
        if (nexoTarget != null) {
            return nexoTarget;
        }
        String itemsAdderTarget = this.detectItemsAdderItem(item);
        if (itemsAdderTarget != null) {
            return itemsAdderTarget;
        }
        String customFishingTarget = this.detectCustomFishingItem(item);
        if (customFishingTarget != null) {
            return customFishingTarget;
        }
        String customCropsTarget = this.detectCustomCropsItem(item);
        if (customCropsTarget != null) {
            return customCropsTarget;
        }
        return item.getType().name();
    }

    private String detectNexoItem(ItemStack item) {
        try {
            if (this.plugin.getServer().getPluginManager().isPluginEnabled("Nexo") && item.hasItemMeta() && item.getItemMeta().hasCustomModelData()) {
                return "nexo:item_" + item.getItemMeta().getCustomModelData();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private String detectItemsAdderItem(ItemStack item) {
        try {
            if (this.plugin.getServer().getPluginManager().isPluginEnabled("ItemsAdder") && item.hasItemMeta() && item.getItemMeta().hasCustomModelData()) {
                return "itemsadder:item_" + item.getItemMeta().getCustomModelData();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private String detectCustomFishingItem(ItemStack item) {
        try {
            String cleanName;
            String displayName;
            if (this.plugin.getServer().getPluginManager().isPluginEnabled("CustomFishing") && item.hasItemMeta() && (displayName = item.getItemMeta().getDisplayName()) != null && !displayName.isEmpty() && ((cleanName = displayName.replaceAll(COLOR_CODE_PATTERN, "").toLowerCase()).contains("fish") || cleanName.contains("catch"))) {
                return "customfishing:" + cleanName.replaceAll("[^a-z0-9]", "_");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private String detectCustomCropsItem(ItemStack item) {
        try {
            String cleanName;
            String displayName;
            if (this.plugin.getServer().getPluginManager().isPluginEnabled("CustomCrops") && item.hasItemMeta() && (displayName = item.getItemMeta().getDisplayName()) != null && !displayName.isEmpty() && ((cleanName = displayName.replaceAll(COLOR_CODE_PATTERN, "").toLowerCase()).contains("crop") || cleanName.contains("seed") || cleanName.contains("harvest"))) {
                return "customcrops:" + cleanName.replaceAll("[^a-z0-9]", "_");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onMerchantTradeClick(InventoryClickEvent event) {
        if (event.getInventory().getType() != InventoryType.MERCHANT) {
            return;
        }
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (event.getSlot() != 2) {
            return;
        }
        ItemStack result = event.getCurrentItem();
        if (result == null || result.getType().isAir()) {
            return;
        }
        this.totalEvents.incrementAndGet();
        try {
            boolean shouldCancel;
            MerchantRecipe selectedRecipe;
            MerchantInventory merchantInv = (MerchantInventory)event.getInventory();
            Merchant merchant = merchantInv.getMerchant();
            ConditionContext context = new ConditionContext().setItem(result).set(TARGET_KEY, result.getType().name());
            if (merchant instanceof Villager) {
                Villager villager = (Villager)merchant;
                context.setEntity((Entity)villager).set("profession", villager.getProfession().name());
                if (this.plugin.getConfigManager().isDebugEnabled()) {
                    this.plugin.getLogger().info("Trade with villager profession: " + villager.getProfession().name() + TARGET_SUFFIX + result.getType().name() + " by " + player.getName());
                }
            }
            if ((selectedRecipe = merchantInv.getSelectedRecipe()) != null) {
                context.set("trade_uses", selectedRecipe.getUses()).set("trade_max_uses", selectedRecipe.getMaxUses());
            }
            if (shouldCancel = this.actionProcessor.processAction(player, ActionType.TRADE, (Event)event, context)) {
                event.setCancelled(true);
            }
            this.processedEvents.incrementAndGet();
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error processing TRADE action for player " + player.getName() + ": " + e.getMessage());
        }
    }

    private void addCustomItemContext(ItemStack item, ConditionContext context) {
        block5: {
            if (!item.hasItemMeta()) {
                return;
            }
            try {
                String mmoItemsNBT = this.detectMMOItemsNBT(item);
                if (mmoItemsNBT != null) {
                    context.set("nbt", mmoItemsNBT);
                    context.set("mmoitems_type", mmoItemsNBT);
                    if (this.plugin.getConfigManager().isDebugEnabled()) {
                        this.plugin.getLogger().info("Detected MMOItems NBT: " + mmoItemsNBT);
                    }
                }
                this.addPluginSpecificContext(item, context);
            }
            catch (Exception e) {
                if (!this.plugin.getConfigManager().isDebugEnabled()) break block5;
                this.plugin.getLogger().warning("Error detecting custom item context: " + e.getMessage());
            }
        }
    }

    private String detectMMOItemsNBT(ItemStack item) {
        try {
            String displayName;
            if (this.plugin.getServer().getPluginManager().isPluginEnabled("MMOItems") && item.hasItemMeta() && item.getItemMeta().hasDisplayName() && (displayName = item.getItemMeta().getDisplayName()).contains("\u00a7") && item.getItemMeta().hasLore()) {
                return "MMOITEMS:CONSUMABLE:" + displayName.replaceAll(COLOR_CODE_PATTERN, "").replaceAll("[^A-Z0-9]", "_").toUpperCase();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void addPluginSpecificContext(ItemStack item, ConditionContext context) {
        String itemsAdderId;
        String nexoId;
        String customFishingId;
        String customCropsId;
        if (this.plugin.getServer().getPluginManager().isPluginEnabled("CustomCrops") && (customCropsId = this.detectCustomCropsItem(item)) != null) {
            context.set("customcrops_id", customCropsId);
            context.set("nbt", customCropsId);
        }
        if (this.plugin.getServer().getPluginManager().isPluginEnabled("CustomFishing") && (customFishingId = this.detectCustomFishingItem(item)) != null) {
            context.set("customfishing_id", customFishingId);
            context.set("nbt", customFishingId);
        }
        if (this.plugin.getServer().getPluginManager().isPluginEnabled("Nexo") && (nexoId = this.detectNexoItem(item)) != null) {
            context.set("nexo_id", nexoId);
            context.set("nbt", nexoId);
        }
        if (this.plugin.getServer().getPluginManager().isPluginEnabled("ItemsAdder") && (itemsAdderId = this.detectItemsAdderItem(item)) != null) {
            context.set("itemsadder_id", itemsAdderId);
            context.set("nbt", itemsAdderId);
        }
    }

    private void addPotionContext(ItemStack item, ConditionContext context) {
        block7: {
            if (!item.hasItemMeta() || !(item.getItemMeta() instanceof PotionMeta)) {
                return;
            }
            try {
                PotionMeta potionMeta = (PotionMeta)item.getItemMeta();
                if (potionMeta.getBasePotionType() != null) {
                    PotionType baseType = potionMeta.getBasePotionType();
                    String potionTypeName = baseType.name();
                    boolean isExtended = potionTypeName.contains("LONG");
                    boolean isUpgraded = potionTypeName.contains("STRONG");
                    String effectName = potionTypeName.replace("LONG_", "").replace("STRONG_", "");
                    int level = isUpgraded ? 2 : 1;
                    String potionTypeString = effectName + ":" + level;
                    context.set("potion-type", potionTypeString);
                    if (this.plugin.getConfigManager().isDebugEnabled()) {
                        this.plugin.getLogger().info("Detected potion type: " + potionTypeString + " (base: " + potionTypeName + ", extended: " + isExtended + ", upgraded: " + isUpgraded + ")");
                    }
                }
                if (potionMeta.hasCustomEffects() && !potionMeta.getCustomEffects().isEmpty()) {
                    PotionEffect firstEffect = (PotionEffect)potionMeta.getCustomEffects().get(0);
                    String effectType = firstEffect.getType().getName().toUpperCase();
                    int amplifier = firstEffect.getAmplifier() + 1;
                    String customPotionType = effectType + ":" + amplifier;
                    context.set("potion-type", customPotionType);
                    if (this.plugin.getConfigManager().isDebugEnabled()) {
                        this.plugin.getLogger().info("Detected custom potion effect: " + customPotionType);
                    }
                }
            }
            catch (Exception e) {
                if (!this.plugin.getConfigManager().isDebugEnabled()) break block7;
                this.plugin.getLogger().warning("Error detecting potion context: " + e.getMessage());
            }
        }
    }

    private boolean isNexoBlock(Block block) {
        try {
            if (!this.plugin.getServer().getPluginManager().isPluginEnabled("Nexo")) {
                return false;
            }
            return NexoBlocks.isCustomBlock((Block)block);
        }
        catch (Exception e) {
            return false;
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBrew(BrewEvent event) {
        Player player = this.getBrewingStandOwner(event.getBlock().getLocation());
        if (player == null) {
            if (this.plugin.getConfigManager().isDebugEnabled()) {
                this.plugin.getLogger().info("No tracked owner for brewing stand at " + String.valueOf(event.getBlock().getLocation()) + " - no XP awarded");
            }
            return;
        }
        this.totalEvents.incrementAndGet();
        try {
            BrewerInventory inventory = event.getContents();
            for (int i = 0; i < 3; ++i) {
                ItemStack result = inventory.getItem(i);
                if (result == null || result.getType().isAir()) continue;
                ConditionContext context = new ConditionContext().setItem(result).set(TARGET_KEY, this.detectItemTarget(result)).set("amount", result.getAmount());
                if (this.plugin.getConfigManager().isDebugEnabled()) {
                    this.plugin.getLogger().info("Processing BREW action for " + player.getName() + TARGET_SUFFIX + String.valueOf(context.get(TARGET_KEY)));
                }
                this.actionProcessor.processAction(player, ActionType.BREW, (Event)event, context);
                this.processedEvents.incrementAndGet();
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Error processing BREW action for player " + player.getName() + ": " + e.getMessage());
        }
    }

    private Player getBrewingStandOwner(Location brewingLocation) {
        return this.getFurnaceOwner(brewingLocation);
    }

    private boolean isItemsAdderBlock(Block block) {
        try {
            if (!this.plugin.getServer().getPluginManager().isPluginEnabled("ItemsAdder")) {
                return false;
            }
            Class<?> customBlockClass = Class.forName("dev.lone.itemsadder.api.CustomBlock");
            Method byAlreadyPlacedMethod = customBlockClass.getMethod("byAlreadyPlaced", Block.class);
            Object customBlock = byAlreadyPlacedMethod.invoke(null, block);
            return customBlock != null;
        }
        catch (Exception e) {
            return false;
        }
    }
}

