/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.menu.config;

import fr.ax_dev.universejobs.UniverseJobs;
import fr.ax_dev.universejobs.menu.config.SimpleConfigurationSection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;

public class MenuItemConfig {
    private final boolean enabled;
    private final String material;
    private final int amount;
    private final String displayName;
    private List<String> lore;
    private final int customModelData;
    private final Map<String, Integer> enchantments;
    private final boolean glow;
    private final boolean hideAttributes;
    private final boolean hideEnchants;
    private final boolean hideToolTip;
    private final List<Integer> slots;
    private final String action;
    private final String actionValue;
    private final String skullOwner;
    private final String playerHead;
    private final String sound;
    private final String elseMaterial;
    private final String elseDisplayName;
    private final List<String> elseLore;
    private final int elseCustomModelData;

    public MenuItemConfig(ConfigurationSection config) {
        Map<String, Object> defaults = MenuItemConfig.getGlobalDefaults();
        this.enabled = config.getBoolean("enabled", ((Boolean)defaults.getOrDefault("enabled", true)).booleanValue());
        this.material = config.getString("material", (String)defaults.getOrDefault("material", "STONE"));
        this.amount = config.getInt("amount", ((Integer)defaults.getOrDefault("amount", 1)).intValue());
        this.displayName = config.getString("display-name", (String)defaults.getOrDefault("display-name", ""));
        List defaultLore = defaults.getOrDefault("lore", new ArrayList());
        this.lore = config.getStringList("lore");
        if (this.lore.isEmpty() && !defaultLore.isEmpty()) {
            this.lore = new ArrayList<String>(defaultLore);
        }
        this.customModelData = config.getInt("custom-model-data", ((Integer)defaults.getOrDefault("custom-model-data", 0)).intValue());
        this.glow = config.getBoolean("glow", ((Boolean)defaults.getOrDefault("glow", false)).booleanValue());
        this.hideAttributes = config.getBoolean("hide-attributes", ((Boolean)defaults.getOrDefault("hide-attributes", false)).booleanValue());
        this.hideEnchants = config.getBoolean("hide-enchants", ((Boolean)defaults.getOrDefault("hide-enchants", false)).booleanValue());
        this.hideToolTip = config.getBoolean("hideToolTip", false);
        this.slots = config.getIntegerList("slots");
        this.action = config.getString("action", (String)defaults.getOrDefault("action", "none"));
        this.actionValue = config.getString("action-value", "");
        this.skullOwner = config.getString("skull-owner", "");
        this.playerHead = config.getString("player-head", "");
        this.sound = config.getString("sound", (String)defaults.getOrDefault("sound", ""));
        ConfigurationSection elseSection = config.getConfigurationSection("else");
        if (elseSection != null) {
            this.elseMaterial = elseSection.getString("material", "");
            this.elseDisplayName = elseSection.getString("display-name", "");
            this.elseLore = elseSection.getStringList("lore");
            this.elseCustomModelData = elseSection.getInt("custom-model-data", 0);
        } else {
            this.elseMaterial = "";
            this.elseDisplayName = "";
            this.elseLore = new ArrayList<String>();
            this.elseCustomModelData = 0;
        }
        this.enchantments = new HashMap<String, Integer>();
        ConfigurationSection enchantSection = config.getConfigurationSection("enchantments");
        if (enchantSection != null) {
            for (String enchantKey : enchantSection.getKeys(false)) {
                int level = enchantSection.getInt(enchantKey, 1);
                this.enchantments.put(enchantKey, level);
            }
        }
    }

    public static MenuItemConfig defaultItem(String material, String displayName, String ... lore) {
        HashMap<String, Object> configMap = new HashMap<String, Object>();
        configMap.put("enabled", true);
        configMap.put("material", material);
        configMap.put("amount", 1);
        configMap.put("display-name", displayName);
        configMap.put("lore", Arrays.asList(lore));
        configMap.put("custom-model-data", 0);
        configMap.put("glow", false);
        configMap.put("hide-attributes", false);
        configMap.put("hide-enchants", false);
        configMap.put("hideToolTip", false);
        configMap.put("slots", new ArrayList());
        configMap.put("action", "none");
        configMap.put("action-value", "");
        return new MenuItemConfig((ConfigurationSection)new SimpleConfigurationSection(configMap));
    }

    public static MenuItemConfig navigationItem(String material, String displayName, String action, List<Integer> slots, String ... lore) {
        HashMap<String, Object> configMap = new HashMap<String, Object>();
        configMap.put("enabled", true);
        configMap.put("material", material);
        configMap.put("amount", 1);
        configMap.put("display-name", displayName);
        configMap.put("lore", Arrays.asList(lore));
        configMap.put("custom-model-data", 0);
        configMap.put("glow", false);
        configMap.put("hide-attributes", false);
        configMap.put("hide-enchants", false);
        configMap.put("hideToolTip", false);
        configMap.put("slots", slots);
        configMap.put("action", action);
        configMap.put("action-value", "");
        return new MenuItemConfig((ConfigurationSection)new SimpleConfigurationSection(configMap));
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getMaterial() {
        return this.material;
    }

    public int getAmount() {
        return this.amount;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public List<String> getLore() {
        return new ArrayList<String>(this.lore);
    }

    public int getCustomModelData() {
        return this.customModelData;
    }

    public Map<String, Integer> getEnchantments() {
        return new HashMap<String, Integer>(this.enchantments);
    }

    public boolean isGlow() {
        return this.glow;
    }

    public boolean isHideAttributes() {
        return this.hideAttributes;
    }

    public boolean isHideEnchants() {
        return this.hideEnchants;
    }

    public boolean isHideToolTip() {
        return this.hideToolTip;
    }

    public List<Integer> getSlots() {
        return new ArrayList<Integer>(this.slots);
    }

    public String getAction() {
        return this.action;
    }

    public String getActionValue() {
        return this.actionValue;
    }

    public String getSkullOwner() {
        return this.skullOwner;
    }

    public String getPlayerHead() {
        return this.playerHead;
    }

    public String getSound() {
        return this.sound;
    }

    public String getElseMaterial() {
        return this.elseMaterial;
    }

    public String getElseDisplayName() {
        return this.elseDisplayName;
    }

    public List<String> getElseLore() {
        return new ArrayList<String>(this.elseLore);
    }

    public int getElseCustomModelData() {
        return this.elseCustomModelData;
    }

    public boolean hasElseConfiguration() {
        return this.elseMaterial != null && !this.elseMaterial.isEmpty();
    }

    private static Map<String, Object> getGlobalDefaults() {
        try {
            ConfigurationSection defaultsSection;
            UniverseJobs plugin = UniverseJobs.getInstance();
            if (plugin != null && (defaultsSection = plugin.getConfig().getConfigurationSection("gui-default-settings")) != null) {
                HashMap<String, Object> defaults = new HashMap<String, Object>();
                defaults.put("enabled", defaultsSection.getBoolean("enabled", true));
                defaults.put("amount", defaultsSection.getInt("amount", 1));
                defaults.put("display-name", defaultsSection.getString("display-name", ""));
                defaults.put("material", defaultsSection.getString("material", "STONE"));
                defaults.put("lore", defaultsSection.getStringList("lore"));
                defaults.put("glow", defaultsSection.getBoolean("glow", false));
                defaults.put("hide-attributes", defaultsSection.getBoolean("hide-attributes", false));
                defaults.put("hide-enchants", defaultsSection.getBoolean("hide-enchants", false));
                defaults.put("sound", defaultsSection.getString("sound", ""));
                defaults.put("custom-model-data", defaultsSection.getInt("custom-model-data", 0));
                defaults.put("action", defaultsSection.getString("action", "none"));
                return defaults;
            }
        }
        catch (Exception plugin) {
            // empty catch block
        }
        HashMap<String, Object> defaults = new HashMap<String, Object>();
        defaults.put("enabled", true);
        defaults.put("amount", 1);
        defaults.put("display-name", "");
        defaults.put("material", "STONE");
        defaults.put("lore", new ArrayList());
        defaults.put("glow", false);
        defaults.put("hide-attributes", false);
        defaults.put("hide-enchants", false);
        defaults.put("sound", "");
        defaults.put("custom-model-data", 0);
        defaults.put("action", "none");
        return defaults;
    }
}

