/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.storage.dao;

import fr.ax_dev.universejobs.storage.SqlIdentifierValidator;
import fr.ax_dev.universejobs.storage.database.DatabaseConfig;
import fr.ax_dev.universejobs.storage.database.HikariConnectionPool;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class JobStatsDao {
    private final HikariConnectionPool connectionPool;
    private final String tableName;
    private final String insertOrUpdateSql;
    private final String selectByJobAndStatSql;
    private final String selectByJobSql;
    private final String deleteByJobAndStatSql;
    private final String deleteByJobSql;

    public JobStatsDao(HikariConnectionPool connectionPool, DatabaseConfig config) {
        this.connectionPool = connectionPool;
        this.tableName = SqlIdentifierValidator.buildSafeTableName(config.getPrefix(), "job_stats");
        this.insertOrUpdateSql = config.getType().getName().equals("mysql") ? "INSERT INTO " + this.tableName + " (job_id, stat_name, stat_value, last_updated) VALUES (?, ?, ?, ?) ON DUPLICATE KEY UPDATE stat_value = VALUES(stat_value), last_updated = VALUES(last_updated)" : "INSERT OR REPLACE INTO " + this.tableName + " (job_id, stat_name, stat_value, last_updated) VALUES (?, ?, ?, ?)";
        this.selectByJobAndStatSql = "SELECT stat_value FROM " + this.tableName + " WHERE job_id = ? AND stat_name = ?";
        this.selectByJobSql = "SELECT stat_name, stat_value, last_updated FROM " + this.tableName + " WHERE job_id = ?";
        this.deleteByJobAndStatSql = "DELETE FROM " + this.tableName + " WHERE job_id = ? AND stat_name = ?";
        this.deleteByJobSql = "DELETE FROM " + this.tableName + " WHERE job_id = ?";
    }

    public CompletableFuture<Void> setStat(String jobId, String statName, String value) {
        return CompletableFuture.runAsync(() -> {
            try (Connection conn = this.connectionPool.getConnection();
                 PreparedStatement stmt = conn.prepareStatement(this.insertOrUpdateSql);){
                stmt.setString(1, jobId);
                stmt.setString(2, statName);
                stmt.setString(3, value);
                stmt.setLong(4, System.currentTimeMillis());
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                throw new RuntimeException("Failed to set stat " + statName + " for job " + jobId, e);
            }
        });
    }

    public CompletableFuture<String> getStat(String jobId, String statName) {
        return CompletableFuture.supplyAsync(() -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
    }

    public CompletableFuture<Map<String, String>> getJobStats(String jobId) {
        return CompletableFuture.supplyAsync(() -> {
            HashMap<String, String> stats = new HashMap<String, String>();
            try (Connection conn = this.connectionPool.getConnection();){
                HashMap<String, String> hashMap;
                block22: {
                    PreparedStatement stmt = conn.prepareStatement(this.selectByJobSql);
                    try {
                        stmt.setString(1, jobId);
                        try (ResultSet rs = stmt.executeQuery();){
                            while (rs.next()) {
                                String statName = rs.getString("stat_name");
                                String statValue = rs.getString("stat_value");
                                stats.put(statName, statValue);
                            }
                        }
                        hashMap = stats;
                        if (stmt == null) break block22;
                    }
                    catch (Throwable throwable) {
                        if (stmt != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    stmt.close();
                }
                return hashMap;
            }
            catch (SQLException e) {
                throw new RuntimeException("Failed to get stats for job " + jobId, e);
            }
        });
    }

    public CompletableFuture<Void> removeStat(String jobId, String statName) {
        return CompletableFuture.runAsync(() -> {
            try (Connection conn = this.connectionPool.getConnection();
                 PreparedStatement stmt = conn.prepareStatement(this.deleteByJobAndStatSql);){
                stmt.setString(1, jobId);
                stmt.setString(2, statName);
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                throw new RuntimeException("Failed to remove stat " + statName + " for job " + jobId, e);
            }
        });
    }

    public CompletableFuture<Void> removeAllJobStats(String jobId) {
        return CompletableFuture.runAsync(() -> {
            try (Connection conn = this.connectionPool.getConnection();
                 PreparedStatement stmt = conn.prepareStatement(this.deleteByJobSql);){
                stmt.setString(1, jobId);
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                throw new RuntimeException("Failed to remove all stats for job " + jobId, e);
            }
        });
    }
}

