/*
 * Decompiled with CFR 0.152.
 */
package fr.ax_dev.universejobs.storage.database;

public enum DatabaseType {
    MYSQL("mysql", "jdbc:mysql://", 3306),
    SQLITE("sqlite", "jdbc:sqlite:", 0);

    private final String name;
    private final String protocol;
    private final int defaultPort;

    private DatabaseType(String name, String protocol, int defaultPort) {
        this.name = name;
        this.protocol = protocol;
        this.defaultPort = defaultPort;
    }

    public String getName() {
        return this.name;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public int getDefaultPort() {
        return this.defaultPort;
    }

    public static DatabaseType fromString(String type) {
        for (DatabaseType dbType : DatabaseType.values()) {
            if (!dbType.name.equalsIgnoreCase(type)) continue;
            return dbType;
        }
        return SQLITE;
    }
}

